/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client;

import com.mailjet.client.Base64;
import com.mailjet.client.ClientOptions;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.MailjetResponse;
import com.mailjet.client.MailjetResponseUtil;
import com.mailjet.client.errors.MailjetClientCommunicationException;
import com.mailjet.client.errors.MailjetException;
import com.mailjet.client.errors.MailjetUnauthorizedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class MailjetClient {
    private ClientOptions _options;
    private OkHttpClient _client;
    private static final String userAgent = "mailjet-apiv3-java/v5.2.0";

    @Deprecated
    public MailjetClient(String apiKey, String apiSecret) {
        this(ClientOptions.builder().apiKey(apiKey).apiSecretKey(apiSecret).build());
    }

    @Deprecated
    public MailjetClient(String token) {
        this(ClientOptions.builder().bearerAccessToken(token).build());
    }

    public MailjetClient(ClientOptions clientOptions) {
        this._options = clientOptions;
        this._client = clientOptions.getOkHttpClient() == null ? MailjetClient.createDefaultOkHttpClient() : clientOptions.getOkHttpClient();
    }

    public MailjetResponse get(MailjetRequest request) throws MailjetException {
        MailjetResponse mailjetResponse;
        block8: {
            Response okHttpResponse = this.getGetCall(request).execute();
            try {
                mailjetResponse = this.parseResponse(request, okHttpResponse);
                if (okHttpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (okHttpResponse != null) {
                        try {
                            okHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new MailjetClientCommunicationException("Connection Exception", ex);
                }
            }
            okHttpResponse.close();
        }
        return mailjetResponse;
    }

    public CompletableFuture<MailjetResponse> getAsync(MailjetRequest request) {
        CompletableFuture<MailjetResponse> resultFuture = new CompletableFuture<MailjetResponse>();
        try {
            this.getGetCall(request).enqueue(this.getAsyncCallback(request, resultFuture));
        }
        catch (MailjetException e) {
            resultFuture.completeExceptionally(e);
        }
        return resultFuture;
    }

    private Call getGetCall(MailjetRequest request) throws MailjetException {
        Request okHttpRequest = this.getPreconfiguredRequestBuilder(request).get().build();
        return this._client.newCall(okHttpRequest);
    }

    public MailjetResponse post(MailjetRequest request) throws MailjetException {
        MailjetResponse mailjetResponse;
        block8: {
            Response okHttpResponse = this.getPostCall(request).execute();
            try {
                mailjetResponse = this.parseResponse(request, okHttpResponse);
                if (okHttpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (okHttpResponse != null) {
                        try {
                            okHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new MailjetClientCommunicationException("Connection Exception", ex);
                }
            }
            okHttpResponse.close();
        }
        return mailjetResponse;
    }

    public CompletableFuture<MailjetResponse> postAsync(MailjetRequest request) {
        CompletableFuture<MailjetResponse> resultFuture = new CompletableFuture<MailjetResponse>();
        try {
            this.getPostCall(request).enqueue(this.getAsyncCallback(request, resultFuture));
        }
        catch (MailjetException e) {
            resultFuture.completeExceptionally(e);
        }
        return resultFuture;
    }

    private Call getPostCall(MailjetRequest request) throws MailjetException {
        byte[] bodyContent = request.getBody().getBytes(StandardCharsets.UTF_8);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)request.getContentType()), (byte[])bodyContent);
        Request okHttpRequest = this.getPreconfiguredRequestBuilder(request).post(requestBody).build();
        return this._client.newCall(okHttpRequest);
    }

    public MailjetResponse put(MailjetRequest request) throws MailjetException {
        MailjetResponse mailjetResponse;
        block8: {
            Response okHttpResponse = this.getPutCall(request).execute();
            try {
                mailjetResponse = this.parseResponse(request, okHttpResponse);
                if (okHttpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (okHttpResponse != null) {
                        try {
                            okHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new MailjetClientCommunicationException("Connection Exception", ex);
                }
            }
            okHttpResponse.close();
        }
        return mailjetResponse;
    }

    public CompletableFuture<MailjetResponse> putAsync(MailjetRequest request) {
        CompletableFuture<MailjetResponse> resultFuture = new CompletableFuture<MailjetResponse>();
        try {
            this.getPutCall(request).enqueue(this.getAsyncCallback(request, resultFuture));
        }
        catch (MailjetException e) {
            resultFuture.completeExceptionally(e);
        }
        return resultFuture;
    }

    private Call getPutCall(MailjetRequest request) throws MailjetException {
        byte[] bodyContent = request.getBody().getBytes(StandardCharsets.UTF_8);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)request.getContentType()), (byte[])bodyContent);
        Request okHttpRequest = this.getPreconfiguredRequestBuilder(request).put(requestBody).build();
        return this._client.newCall(okHttpRequest);
    }

    public MailjetResponse delete(MailjetRequest request) throws MailjetException {
        MailjetResponse mailjetResponse;
        block8: {
            Response okHttpResponse = this.getDeleteCall(request).execute();
            try {
                mailjetResponse = this.parseResponse(request, okHttpResponse);
                if (okHttpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (okHttpResponse != null) {
                        try {
                            okHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new MailjetClientCommunicationException("Connection Exception", ex);
                }
            }
            okHttpResponse.close();
        }
        return mailjetResponse;
    }

    public CompletableFuture<MailjetResponse> deleteAsync(MailjetRequest request) {
        CompletableFuture<MailjetResponse> resultFuture = new CompletableFuture<MailjetResponse>();
        try {
            this.getDeleteCall(request).enqueue(this.getAsyncCallback(request, resultFuture));
        }
        catch (MailjetException e) {
            resultFuture.completeExceptionally(e);
        }
        return resultFuture;
    }

    private Call getDeleteCall(MailjetRequest request) throws MailjetException {
        Request okHttpRequest = this.getPreconfiguredRequestBuilder(request).delete().build();
        return this._client.newCall(okHttpRequest);
    }

    private Callback getAsyncCallback(final MailjetRequest request, final CompletableFuture<MailjetResponse> completableFuture) {
        return new Callback(){

            public void onFailure(Call call, IOException e) {
                completableFuture.completeExceptionally(new MailjetClientCommunicationException("Connection Exception", e));
            }

            public void onResponse(Call call, Response response) throws IOException {
                try {
                    completableFuture.complete(MailjetClient.this.parseResponse(request, response));
                }
                catch (MailjetException e) {
                    completableFuture.completeExceptionally(e);
                }
            }
        };
    }

    private MailjetResponse parseResponse(MailjetRequest request, Response okHttpResponse) throws IOException, MailjetException {
        int responseStatusCode = okHttpResponse.code();
        String responseBody = okHttpResponse.body() != null ? okHttpResponse.body().string() : null;
        MailjetResponseUtil.validateMailjetResponse(request, responseStatusCode, responseBody);
        String json = MailjetResponseUtil.isValidJSON(responseBody) ? responseBody : new JSONObject().put("status", responseStatusCode).toString();
        return new MailjetResponse(responseStatusCode, json);
    }

    private static OkHttpClient createDefaultOkHttpClient() {
        return new OkHttpClient.Builder().build();
    }

    private Request.Builder getPreconfiguredRequestBuilder(MailjetRequest request) throws MailjetException {
        String url;
        try {
            url = request.buildUrl(this._options.getBaseUrl());
        }
        catch (UnsupportedEncodingException e) {
            throw new MailjetClientCommunicationException("Connection Exception", e);
        }
        Request.Builder builder = new Request.Builder().addHeader("Accept", "application/json").addHeader("User-Agent", userAgent).url(url);
        switch (request.getAuthenticationType()) {
            case Basic: {
                if (this._options.getApiKey() == null || this._options.getApiSecretKey() == null) {
                    throw new MailjetUnauthorizedException("To do a request to MailJet api, api key and api secret should be set");
                }
                String authEncBytes = Base64.encode((this._options.getApiKey() + ":" + this._options.getApiSecretKey()).getBytes());
                builder.addHeader("Authorization", "Basic " + authEncBytes);
                break;
            }
            case Bearer: {
                if (this._options.getBearerAccessToken() == null) {
                    throw new MailjetUnauthorizedException("To do a request to MailJet api, api access token should be set");
                }
                builder.addHeader("Authorization", "Bearer " + this._options.getBearerAccessToken());
            }
        }
        return builder;
    }
}

