/*
 * Decompiled with CFR 0.152.
 */
package com.mahc.custombottomsheetbehavior;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.View;
import com.mahc.custombottomsheetbehavior.BottomSheetBehaviorGoogleMapsLike;
import com.mahc.custombottomsheetbehavior.MergedAppBarLayout;
import java.lang.ref.WeakReference;

public class ScrollAwareFABBehavior
extends FloatingActionButton.Behavior {
    private float offset = 0.0f;
    private WeakReference<BottomSheetBehaviorGoogleMapsLike> mBottomSheetBehaviorRef = null;

    public ScrollAwareFABBehavior(Context context, AttributeSet attrs) {
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, FloatingActionButton child, View directTargetChild, View target, int nestedScrollAxes) {
        return nestedScrollAxes == 2;
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, FloatingActionButton child, View dependency) {
        if (dependency instanceof NestedScrollView) {
            try {
                BottomSheetBehaviorGoogleMapsLike.from(dependency);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, FloatingActionButton child, View dependency) {
        if (this.offset == 0.0f) {
            this.setOffsetValue(parent);
        }
        if (this.mBottomSheetBehaviorRef == null) {
            this.getBottomSheetBehavior(parent);
        }
        int DyFix = this.getDyBetweenChildAndDependency(child, dependency);
        if (child.getY() + (float)DyFix < this.offset) {
            child.hide();
        } else if (child.getY() + (float)DyFix >= this.offset) {
            if (this.mBottomSheetBehaviorRef == null || this.mBottomSheetBehaviorRef.get() == null) {
                this.getBottomSheetBehavior(parent);
            }
            int collapsedY = dependency.getHeight() - ((BottomSheetBehaviorGoogleMapsLike)((Object)this.mBottomSheetBehaviorRef.get())).getPeekHeight();
            if (child.getY() + (float)DyFix > (float)collapsedY) {
                child.hide();
            } else {
                child.show();
            }
        }
        return false;
    }

    private int getDyBetweenChildAndDependency(@NonNull FloatingActionButton child, @NonNull View dependency) {
        if (dependency.getY() == 0.0f || dependency.getY() < this.offset) {
            return 0;
        }
        if (dependency.getY() - child.getY() > (float)child.getHeight()) {
            return Math.max(0, (int)(dependency.getY() - (float)(child.getHeight() / 2) - child.getY()));
        }
        return 0;
    }

    private void setOffsetValue(CoordinatorLayout coordinatorLayout) {
        for (int i = 0; i < coordinatorLayout.getChildCount(); ++i) {
            View child = coordinatorLayout.getChildAt(i);
            if (!(child instanceof MergedAppBarLayout)) continue;
            this.offset = child.getY() + (float)child.getHeight();
            break;
        }
    }

    private void getBottomSheetBehavior(@NonNull CoordinatorLayout coordinatorLayout) {
        for (int i = 0; i < coordinatorLayout.getChildCount(); ++i) {
            View child = coordinatorLayout.getChildAt(i);
            if (!(child instanceof NestedScrollView)) continue;
            try {
                BottomSheetBehaviorGoogleMapsLike<View> temp = BottomSheetBehaviorGoogleMapsLike.from(child);
                this.mBottomSheetBehaviorRef = new WeakReference<BottomSheetBehaviorGoogleMapsLike<View>>(temp);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

