/*
 * Decompiled with CFR 0.152.
 */
package com.mahc.custombottomsheetbehavior;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.design.R;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.mahc.custombottomsheetbehavior.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Vector;

public class BottomSheetBehaviorGoogleMapsLike<V extends View>
extends CoordinatorLayout.Behavior<V> {
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int STATE_ANCHOR_POINT = 3;
    public static final int STATE_EXPANDED = 4;
    public static final int STATE_COLLAPSED = 5;
    public static final int STATE_HIDDEN = 6;
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final float HIDE_FRICTION = 0.1f;
    private float mMinimumVelocity;
    private int mPeekHeight;
    private int mMinOffset;
    private int mMaxOffset;
    private static final int DEFAULT_ANCHOR_POINT = 700;
    private int mAnchorPoint;
    private boolean mHideable;
    private boolean mCollapsible;
    private int mState = 3;
    private int mLastStableState = 3;
    private ViewDragHelper mViewDragHelper;
    private boolean mIgnoreEvents;
    private boolean mNestedScrolled;
    private int mParentHeight;
    private WeakReference<V> mViewRef;
    private WeakReference<View> mNestedScrollingChildRef;
    private Vector<BottomSheetCallback> mCallback;
    private int mActivePointerId;
    private int mInitialY;
    private boolean mTouchingScrollingChild;
    private ScrollVelocityTracker mScrollVelocityTracker = new ScrollVelocityTracker();
    private final ViewDragHelper.Callback mDragCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            View scroll;
            if (BottomSheetBehaviorGoogleMapsLike.this.mState == 1) {
                return false;
            }
            if (BottomSheetBehaviorGoogleMapsLike.this.mTouchingScrollingChild) {
                return false;
            }
            if (BottomSheetBehaviorGoogleMapsLike.this.mState == 4 && BottomSheetBehaviorGoogleMapsLike.this.mActivePointerId == pointerId && (scroll = (View)BottomSheetBehaviorGoogleMapsLike.this.mNestedScrollingChildRef.get()) != null && scroll.canScrollVertically(-1)) {
                return false;
            }
            return BottomSheetBehaviorGoogleMapsLike.this.mViewRef != null && BottomSheetBehaviorGoogleMapsLike.this.mViewRef.get() == child;
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            BottomSheetBehaviorGoogleMapsLike.this.dispatchOnSlide(top);
        }

        public void onViewDragStateChanged(int state) {
            if (state == 1) {
                BottomSheetBehaviorGoogleMapsLike.this.setStateInternal(1);
            }
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int targetState;
            int top;
            if (yvel < 0.0f) {
                top = BottomSheetBehaviorGoogleMapsLike.this.mMinOffset;
                targetState = 4;
            } else if (BottomSheetBehaviorGoogleMapsLike.this.mHideable && BottomSheetBehaviorGoogleMapsLike.this.shouldHide(releasedChild, yvel)) {
                top = BottomSheetBehaviorGoogleMapsLike.this.mParentHeight;
                targetState = 6;
            } else if (yvel == 0.0f) {
                int currentTop = releasedChild.getTop();
                if (Math.abs(currentTop - BottomSheetBehaviorGoogleMapsLike.this.mMinOffset) < Math.abs(currentTop - BottomSheetBehaviorGoogleMapsLike.this.mMaxOffset)) {
                    top = BottomSheetBehaviorGoogleMapsLike.this.mMinOffset;
                    targetState = 4;
                } else {
                    top = BottomSheetBehaviorGoogleMapsLike.this.mMaxOffset;
                    targetState = 5;
                }
            } else {
                top = BottomSheetBehaviorGoogleMapsLike.this.mMaxOffset;
                targetState = 5;
            }
            if (!BottomSheetBehaviorGoogleMapsLike.this.mCollapsible && targetState == 5) {
                top = BottomSheetBehaviorGoogleMapsLike.this.mAnchorPoint;
                targetState = 3;
            }
            if (BottomSheetBehaviorGoogleMapsLike.this.mViewDragHelper.settleCapturedViewAt(releasedChild.getLeft(), top)) {
                BottomSheetBehaviorGoogleMapsLike.this.setStateInternal(2);
                ViewCompat.postOnAnimation((View)releasedChild, (Runnable)new SettleRunnable(releasedChild, targetState));
            } else {
                BottomSheetBehaviorGoogleMapsLike.this.setStateInternal(targetState);
            }
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return this.constrain(top, BottomSheetBehaviorGoogleMapsLike.this.mMinOffset, BottomSheetBehaviorGoogleMapsLike.this.mHideable ? BottomSheetBehaviorGoogleMapsLike.this.mParentHeight : BottomSheetBehaviorGoogleMapsLike.this.mMaxOffset);
        }

        int constrain(int amount, int low, int high) {
            return amount < low ? low : (amount > high ? high : amount);
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return child.getLeft();
        }

        public int getViewVerticalDragRange(View child) {
            if (BottomSheetBehaviorGoogleMapsLike.this.mHideable) {
                return BottomSheetBehaviorGoogleMapsLike.this.mParentHeight - BottomSheetBehaviorGoogleMapsLike.this.mMinOffset;
            }
            return BottomSheetBehaviorGoogleMapsLike.this.mMaxOffset - BottomSheetBehaviorGoogleMapsLike.this.mMinOffset;
        }
    };

    public BottomSheetBehaviorGoogleMapsLike() {
    }

    public BottomSheetBehaviorGoogleMapsLike(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BottomSheetBehavior_Layout);
        this.setPeekHeight(a.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight, 0));
        this.setHideable(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_hideable, false));
        a.recycle();
        this.mAnchorPoint = 700;
        this.mCollapsible = true;
        a = context.obtainStyledAttributes(attrs, R.styleable.CustomBottomSheetBehavior);
        if (attrs != null) {
            this.mAnchorPoint = (int)a.getDimension(R.styleable.CustomBottomSheetBehavior_anchorPoint, 0.0f);
        }
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
    }

    public Parcelable onSaveInstanceState(CoordinatorLayout parent, V child) {
        return new SavedState(super.onSaveInstanceState(parent, child), this.mState);
    }

    public void onRestoreInstanceState(CoordinatorLayout parent, V child, Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(parent, child, ss.getSuperState());
        this.mState = ss.state == 1 || ss.state == 2 ? 5 : ss.state;
        this.mLastStableState = this.mState;
    }

    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        if (this.mState != 1 && this.mState != 2) {
            if (parent.getFitsSystemWindows() && !child.getFitsSystemWindows()) {
                child.setFitsSystemWindows(true);
            }
            parent.onLayoutChild(child, layoutDirection);
        }
        this.mParentHeight = parent.getHeight();
        this.mMinOffset = Math.max(0, this.mParentHeight - child.getHeight());
        this.mMaxOffset = Math.max(this.mParentHeight - this.mPeekHeight, this.mMinOffset);
        if (this.mState == 3) {
            ViewCompat.offsetTopAndBottom(child, (int)this.mAnchorPoint);
        } else if (this.mState == 4) {
            ViewCompat.offsetTopAndBottom(child, (int)this.mMinOffset);
        } else if (this.mHideable && this.mState == 6) {
            ViewCompat.offsetTopAndBottom(child, (int)this.mParentHeight);
        } else if (this.mState == 5) {
            ViewCompat.offsetTopAndBottom(child, (int)this.mMaxOffset);
        }
        if (this.mViewDragHelper == null) {
            this.mViewDragHelper = ViewDragHelper.create((ViewGroup)parent, (ViewDragHelper.Callback)this.mDragCallback);
        }
        this.mViewRef = new WeakReference<V>(child);
        this.mNestedScrollingChildRef = new WeakReference<View>(this.findScrollingChild((View)child));
        return true;
    }

    public boolean onInterceptTouchEvent(CoordinatorLayout parent, V child, MotionEvent event) {
        if (!child.isShown()) {
            this.mIgnoreEvents = true;
            return false;
        }
        int action = event.getActionMasked();
        if (action == 0) {
            this.reset();
        }
        switch (action) {
            case 1: 
            case 3: {
                this.mTouchingScrollingChild = false;
                this.mActivePointerId = -1;
                if (!this.mIgnoreEvents) break;
                this.mIgnoreEvents = false;
                return false;
            }
            case 0: {
                this.mScrollVelocityTracker.clear();
                int initialX = (int)event.getX();
                this.mInitialY = (int)event.getY();
                if (this.mState == 3) {
                    this.mActivePointerId = event.getPointerId(event.getActionIndex());
                    this.mTouchingScrollingChild = true;
                } else {
                    View scroll = (View)this.mNestedScrollingChildRef.get();
                    if (scroll != null && parent.isPointInChildBounds(scroll, initialX, this.mInitialY)) {
                        this.mActivePointerId = event.getPointerId(event.getActionIndex());
                        this.mTouchingScrollingChild = true;
                    }
                }
                this.mIgnoreEvents = this.mActivePointerId == -1 && !parent.isPointInChildBounds(child, initialX, this.mInitialY);
                break;
            }
        }
        if (!this.mIgnoreEvents && this.mViewDragHelper.shouldInterceptTouchEvent(event)) {
            return true;
        }
        View scroll = (View)this.mNestedScrollingChildRef.get();
        boolean ret = action == 2 && scroll != null && !this.mIgnoreEvents && this.mState != 1 && !parent.isPointInChildBounds(scroll, (int)event.getX(), (int)event.getY()) && Math.abs((float)this.mInitialY - event.getY()) > (float)this.mViewDragHelper.getTouchSlop();
        return ret;
    }

    public boolean onTouchEvent(CoordinatorLayout parent, V child, MotionEvent event) {
        if (!child.isShown()) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.mState == 1 && action == 0) {
            return true;
        }
        if (this.mLastStableState == 3 && action == 2 && event.getY() > (float)this.mInitialY && !this.mCollapsible) {
            this.reset();
            return false;
        }
        if (this.mViewDragHelper == null) {
            this.mViewDragHelper = ViewDragHelper.create((ViewGroup)parent, (ViewDragHelper.Callback)this.mDragCallback);
        }
        this.mViewDragHelper.processTouchEvent(event);
        if (action == 0) {
            this.reset();
        }
        if (action == 2 && !this.mIgnoreEvents && Math.abs((float)this.mInitialY - event.getY()) > (float)this.mViewDragHelper.getTouchSlop()) {
            this.mViewDragHelper.captureChildView(child, event.getPointerId(event.getActionIndex()));
        }
        return !this.mIgnoreEvents;
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V child, View directTargetChild, View target, int nestedScrollAxes, int type) {
        this.mNestedScrolled = false;
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed, int type) {
        View scrollingChild = (View)this.mNestedScrollingChildRef.get();
        if (target != scrollingChild) {
            return;
        }
        this.mScrollVelocityTracker.recordScroll(dy);
        int currentTop = child.getTop();
        int newTop = currentTop - dy;
        if (this.mLastStableState == 5 && newTop < this.mAnchorPoint || this.mLastStableState == 4 && newTop > this.mAnchorPoint) {
            consumed[1] = dy;
            ViewCompat.offsetTopAndBottom(child, (int)(this.mAnchorPoint - currentTop));
            this.dispatchOnSlide(child.getTop());
            this.mNestedScrolled = true;
            return;
        }
        if (dy > 0) {
            if (newTop < this.mMinOffset) {
                consumed[1] = currentTop - this.mMinOffset;
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                this.setStateInternal(4);
            } else {
                consumed[1] = dy;
                ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                this.setStateInternal(1);
            }
        } else if (dy < 0 && !ViewCompat.canScrollVertically((View)target, (int)-1)) {
            if (newTop <= this.mMaxOffset || this.mHideable) {
                if (this.mCollapsible || !this.mCollapsible && this.mAnchorPoint - newTop >= 0) {
                    consumed[1] = dy;
                    ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                    this.setStateInternal(1);
                }
            } else {
                consumed[1] = currentTop - this.mMaxOffset;
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                this.setStateInternal(5);
            }
        }
        this.dispatchOnSlide(child.getTop());
        this.mNestedScrolled = true;
    }

    public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V child, View target, int type) {
        int targetState;
        int top;
        if (child.getTop() == this.mMinOffset) {
            this.setStateInternal(4);
            this.mLastStableState = 4;
            return;
        }
        if (target != this.mNestedScrollingChildRef.get() || !this.mNestedScrolled) {
            return;
        }
        float scrollVelocity = this.mScrollVelocityTracker.getScrollVelocity();
        if (scrollVelocity > this.mMinimumVelocity) {
            if (this.mLastStableState == 5) {
                top = this.mAnchorPoint;
                targetState = 3;
            } else if (this.mLastStableState == 3) {
                top = this.mMinOffset;
                targetState = 4;
            } else {
                top = this.mMinOffset;
                targetState = 4;
            }
        } else if (scrollVelocity < -this.mMinimumVelocity) {
            if (this.mLastStableState == 4) {
                top = this.mAnchorPoint;
                targetState = 3;
            } else if (this.mCollapsible) {
                if (this.mLastStableState == 3) {
                    top = this.mMaxOffset;
                    targetState = 5;
                } else {
                    top = this.mMaxOffset;
                    targetState = 5;
                }
            } else {
                top = this.mAnchorPoint;
                targetState = 3;
            }
        } else {
            int currentTop = child.getTop();
            if ((double)currentTop > (double)this.mAnchorPoint * 1.25 && this.mCollapsible) {
                top = this.mMaxOffset;
                targetState = 5;
            } else if ((double)currentTop < (double)this.mAnchorPoint * 0.5) {
                top = this.mMinOffset;
                targetState = 4;
            } else {
                top = this.mAnchorPoint;
                targetState = 3;
            }
        }
        this.mLastStableState = targetState;
        if (this.mViewDragHelper.smoothSlideViewTo(child, child.getLeft(), top)) {
            this.setStateInternal(2);
            ViewCompat.postOnAnimation(child, (Runnable)new SettleRunnable((View)child, targetState));
        } else {
            this.setStateInternal(targetState);
        }
        this.mNestedScrolled = false;
    }

    public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY) {
        return target == this.mNestedScrollingChildRef.get() && (this.mState != 4 || super.onNestedPreFling(coordinatorLayout, child, target, velocityX, velocityY));
    }

    public final void setPeekHeight(int peekHeight) {
        this.mPeekHeight = Math.max(0, peekHeight);
        this.mMaxOffset = this.mParentHeight - peekHeight;
    }

    public final int getPeekHeight() {
        return this.mPeekHeight;
    }

    public void setAnchorPoint(int anchorPoint) {
        this.mAnchorPoint = anchorPoint;
    }

    public int getAnchorPoint() {
        return this.mAnchorPoint;
    }

    public void setHideable(boolean hideable) {
        this.mHideable = hideable;
    }

    public boolean isHideable() {
        return this.mHideable;
    }

    public void setCollapsible(boolean collapsible) {
        this.mCollapsible = collapsible;
    }

    public boolean isCollapsible() {
        return this.mCollapsible;
    }

    public void addBottomSheetCallback(BottomSheetCallback callback) {
        if (this.mCallback == null) {
            this.mCallback = new Vector();
        }
        this.mCallback.add(callback);
    }

    public final void setState(int state) {
        int top;
        View child;
        if (state == this.mState) {
            return;
        }
        if (state == 5 || state == 4 || state == 3 || this.mHideable && state == 6) {
            this.mState = state;
            this.mLastStableState = state;
        }
        View view = child = this.mViewRef == null ? null : (View)this.mViewRef.get();
        if (child == null) {
            return;
        }
        if (state == 5) {
            top = this.mMaxOffset;
        } else if (state == 3) {
            top = this.mAnchorPoint;
        } else if (state == 4) {
            top = this.mMinOffset;
        } else if (this.mHideable && state == 6) {
            top = this.mParentHeight;
        } else {
            throw new IllegalArgumentException("Illegal state argument: " + state);
        }
        this.setStateInternal(2);
        if (this.mViewDragHelper.smoothSlideViewTo(child, child.getLeft(), top)) {
            ViewCompat.postOnAnimation((View)child, (Runnable)new SettleRunnable(child, state));
        }
    }

    public final int getState() {
        return this.mState;
    }

    private void setStateInternal(int state) {
        if (this.mState == state) {
            return;
        }
        this.mState = state;
        View bottomSheet = (View)this.mViewRef.get();
        if (bottomSheet != null && this.mCallback != null) {
            this.notifyStateChangedToListeners(bottomSheet, state);
        }
    }

    private void notifyStateChangedToListeners(@NonNull View bottomSheet, int newState) {
        for (BottomSheetCallback bottomSheetCallback : this.mCallback) {
            bottomSheetCallback.onStateChanged(bottomSheet, newState);
        }
    }

    private void notifyOnSlideToListeners(@NonNull View bottomSheet, float slideOffset) {
        for (BottomSheetCallback bottomSheetCallback : this.mCallback) {
            bottomSheetCallback.onSlide(bottomSheet, slideOffset);
        }
    }

    private void reset() {
        this.mActivePointerId = -1;
    }

    private boolean shouldHide(View child, float yvel) {
        if (child.getTop() < this.mMaxOffset) {
            return false;
        }
        float newTop = (float)child.getTop() + yvel * 0.1f;
        return Math.abs(newTop - (float)this.mMaxOffset) / (float)this.mPeekHeight > 0.5f;
    }

    private View findScrollingChild(View view) {
        if (view instanceof NestedScrollingChild) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                View scrollingChild = this.findScrollingChild(group.getChildAt(i));
                if (scrollingChild == null) continue;
                return scrollingChild;
            }
        }
        return null;
    }

    private void dispatchOnSlide(int top) {
        View bottomSheet = (View)this.mViewRef.get();
        if (bottomSheet != null && this.mCallback != null) {
            if (top > this.mMaxOffset) {
                this.notifyOnSlideToListeners(bottomSheet, (float)(this.mMaxOffset - top) / (float)this.mPeekHeight);
            } else {
                this.notifyOnSlideToListeners(bottomSheet, (float)(this.mMaxOffset - top) / (float)(this.mMaxOffset - this.mMinOffset));
            }
        }
    }

    public static <V extends View> BottomSheetBehaviorGoogleMapsLike<V> from(V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof BottomSheetBehaviorGoogleMapsLike)) {
            throw new IllegalArgumentException("The view is not associated with BottomSheetBehaviorGoogleMapsLike");
        }
        return (BottomSheetBehaviorGoogleMapsLike)behavior;
    }

    protected static class SavedState
    extends View.BaseSavedState {
        final int state;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.state = source.readInt();
        }

        public SavedState(Parcelable superState, int state) {
            super(superState);
            this.state = state;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.state);
        }
    }

    private class SettleRunnable
    implements Runnable {
        private final View mView;
        private final int mTargetState;

        SettleRunnable(View view, int targetState) {
            this.mView = view;
            this.mTargetState = targetState;
        }

        @Override
        public void run() {
            if (BottomSheetBehaviorGoogleMapsLike.this.mViewDragHelper != null && BottomSheetBehaviorGoogleMapsLike.this.mViewDragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.mView, (Runnable)this);
            } else {
                BottomSheetBehaviorGoogleMapsLike.this.setStateInternal(this.mTargetState);
            }
        }
    }

    private class ScrollVelocityTracker {
        private long mPreviousScrollTime = 0L;
        private float mScrollVelocity = 0.0f;

        private ScrollVelocityTracker() {
        }

        public void recordScroll(int dy) {
            long now = System.currentTimeMillis();
            if (this.mPreviousScrollTime != 0L) {
                long elapsed = now - this.mPreviousScrollTime;
                this.mScrollVelocity = (float)dy / (float)elapsed * 1000.0f;
            }
            this.mPreviousScrollTime = now;
        }

        public void clear() {
            this.mPreviousScrollTime = 0L;
            this.mScrollVelocity = 0.0f;
        }

        public float getScrollVelocity() {
            return this.mScrollVelocity;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    public static abstract class BottomSheetCallback {
        public abstract void onStateChanged(@NonNull View var1, int var2);

        public abstract void onSlide(@NonNull View var1, float var2);
    }
}

