/*
 * Decompiled with CFR 0.152.
 */
package com.mahc.custombottomsheetbehavior;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.View;
import android.view.Window;
import com.mahc.custombottomsheetbehavior.BottomSheetBehaviorGoogleMapsLike;
import com.mahc.custombottomsheetbehavior.R;
import java.lang.ref.WeakReference;

public class ScrollingAppBarLayoutBehavior
extends AppBarLayout.ScrollingViewBehavior {
    private static final String TAG = ScrollingAppBarLayoutBehavior.class.getSimpleName();
    private boolean mInit = false;
    private Context mContext;
    private boolean mVisible = true;
    private WeakReference<BottomSheetBehaviorGoogleMapsLike> mBottomSheetBehaviorRef;
    private ValueAnimator mAppBarYValueAnimator;

    public ScrollingAppBarLayoutBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
        if (dependency instanceof NestedScrollView) {
            try {
                BottomSheetBehaviorGoogleMapsLike.from(dependency);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
        if (!this.mInit) {
            return this.init(parent, child, dependency);
        }
        if (this.mBottomSheetBehaviorRef == null || this.mBottomSheetBehaviorRef.get() == null) {
            this.getBottomSheetBehavior(parent);
        }
        this.setAppBarVisible((AppBarLayout)child, dependency.getY() >= (float)(dependency.getHeight() - ((BottomSheetBehaviorGoogleMapsLike)((Object)this.mBottomSheetBehaviorRef.get())).getPeekHeight()));
        return true;
    }

    public Parcelable onSaveInstanceState(CoordinatorLayout parent, View child) {
        return new SavedState(super.onSaveInstanceState(parent, child), this.mVisible);
    }

    public void onRestoreInstanceState(CoordinatorLayout parent, View child, Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(parent, child, ss.getSuperState());
        this.mVisible = ss.mVisible;
    }

    private boolean init(CoordinatorLayout parent, View child, View dependency) {
        this.getBottomSheetBehavior(parent);
        if (this.mBottomSheetBehaviorRef == null || this.mBottomSheetBehaviorRef.get() == null) {
            this.getBottomSheetBehavior(parent);
        }
        int mCollapsedY = dependency.getHeight() - ((BottomSheetBehaviorGoogleMapsLike)((Object)this.mBottomSheetBehaviorRef.get())).getPeekHeight();
        this.mVisible = dependency.getY() >= (float)mCollapsedY;
        this.setStatusBarBackgroundVisible(this.mVisible);
        if (!this.mVisible) {
            child.setY((float)((int)child.getY() - child.getHeight() - this.getStatusBarHeight()));
        }
        this.mInit = true;
        return !this.mVisible;
    }

    public void setAppBarVisible(final AppBarLayout appBarLayout, final boolean visible) {
        if (visible == this.mVisible) {
            return;
        }
        if (this.mAppBarYValueAnimator == null || !this.mAppBarYValueAnimator.isRunning()) {
            this.mAppBarYValueAnimator = ValueAnimator.ofFloat((float[])new float[]{(int)appBarLayout.getY(), visible ? (float)((int)appBarLayout.getY() + appBarLayout.getHeight() + this.getStatusBarHeight()) : (float)((int)appBarLayout.getY() - appBarLayout.getHeight() - this.getStatusBarHeight())});
            this.mAppBarYValueAnimator.setDuration((long)this.mContext.getResources().getInteger(0x10E0000));
            this.mAppBarYValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    appBarLayout.setY(((Float)animation.getAnimatedValue()).floatValue());
                }
            });
            this.mAppBarYValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    if (visible) {
                        ScrollingAppBarLayoutBehavior.this.setStatusBarBackgroundVisible(true);
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    if (!visible) {
                        ScrollingAppBarLayoutBehavior.this.setStatusBarBackgroundVisible(false);
                    }
                    ScrollingAppBarLayoutBehavior.this.mVisible = visible;
                    super.onAnimationEnd(animation);
                }
            });
            this.mAppBarYValueAnimator.start();
        }
    }

    private int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.mContext.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.mContext.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private void setStatusBarBackgroundVisible(boolean visible) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (visible) {
                Window window = ((Activity)this.mContext).getWindow();
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.colorPrimaryDark));
            } else {
                Window window = ((Activity)this.mContext).getWindow();
                window.clearFlags(Integer.MIN_VALUE);
                window.addFlags(0x4000000);
                window.setStatusBarColor(ContextCompat.getColor((Context)this.mContext, (int)17170445));
            }
        }
    }

    private void getBottomSheetBehavior(@NonNull CoordinatorLayout coordinatorLayout) {
        for (int i = 0; i < coordinatorLayout.getChildCount(); ++i) {
            View child = coordinatorLayout.getChildAt(i);
            if (!(child instanceof NestedScrollView)) continue;
            try {
                BottomSheetBehaviorGoogleMapsLike<View> temp = BottomSheetBehaviorGoogleMapsLike.from(child);
                this.mBottomSheetBehaviorRef = new WeakReference<BottomSheetBehaviorGoogleMapsLike<View>>(temp);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected static class SavedState
    extends View.BaseSavedState {
        final boolean mVisible;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.mVisible = source.readByte() != 0;
        }

        public SavedState(Parcelable superState, boolean visible) {
            super(superState);
            this.mVisible = visible;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(this.mVisible ? 1 : 0));
        }
    }
}

