/*
 * Decompiled with CFR 0.152.
 */
package com.mahc.custombottomsheetbehavior;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewPropertyAnimator;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.mahc.custombottomsheetbehavior.BottomSheetBehaviorGoogleMapsLike;
import com.mahc.custombottomsheetbehavior.MergedAppBarLayout;
import com.mahc.custombottomsheetbehavior.R;
import java.lang.ref.WeakReference;

public class MergedAppBarLayoutBehavior
extends AppBarLayout.ScrollingViewBehavior {
    private static final String TAG = MergedAppBarLayoutBehavior.class.getSimpleName();
    private boolean mInit = false;
    private FrameLayout.LayoutParams mBackGroundLayoutParams;
    private Context mContext;
    private WeakReference<BottomSheetBehaviorGoogleMapsLike> mBottomSheetBehaviorRef;
    private float mInitialY;
    private boolean mVisible = false;
    private String mToolbarTitle;
    private Toolbar mToolbar;
    private TextView mTitleTextView;
    private View mBackground;
    private View.OnClickListener mOnNavigationClickListener;
    private ValueAnimator mTitleAlphaValueAnimator;
    private int mCurrentTitleAlpha = 0;

    public MergedAppBarLayoutBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
        if (dependency instanceof NestedScrollView) {
            try {
                BottomSheetBehaviorGoogleMapsLike.from(dependency);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
        if (!this.mInit) {
            this.init(parent, child);
        }
        boolean childMoved = false;
        if (this.isDependencyYBelowAnchorPoint(parent, dependency)) {
            childMoved = this.setToolbarVisible(false, child);
        } else if (this.isDependencyYBetweenAnchorPointAndToolbar(parent, child, dependency)) {
            childMoved = this.setToolbarVisible(true, child);
            this.setFullBackGroundColor(17170445);
            this.setPartialBackGroundHeight(0);
        } else if (this.isDependencyYBelowToolbar(child, dependency) && !this.isDependencyYReachTop(dependency)) {
            childMoved = this.setToolbarVisible(true, child);
            if (this.isStatusBarVisible()) {
                this.setStatusBarBackgroundVisible(false);
            }
            if (this.isTitleVisible()) {
                this.setTitleVisible(false);
            }
            this.setFullBackGroundColor(17170445);
            this.setPartialBackGroundHeight((int)((float)child.getHeight() + child.getY() - dependency.getY()));
        } else if (this.isDependencyYBelowStatusToolbar(child, dependency) || this.isDependencyYReachTop(dependency)) {
            childMoved = this.setToolbarVisible(true, child);
            if (!this.isStatusBarVisible()) {
                this.setStatusBarBackgroundVisible(true);
            }
            if (!this.isTitleVisible()) {
                this.setTitleVisible(true);
            }
            this.setFullBackGroundColor(R.color.colorPrimary);
            this.setPartialBackGroundHeight(0);
        }
        return childMoved;
    }

    private void init(@NonNull CoordinatorLayout parent, @NonNull View child) {
        if (!(child instanceof MergedAppBarLayout)) {
            throw new IllegalArgumentException("The view is not a MergedAppBarLayout");
        }
        MergedAppBarLayout appBarLayout = (MergedAppBarLayout)child;
        if (Build.VERSION.SDK_INT >= 21) {
            appBarLayout.setOutlineProvider(ViewOutlineProvider.BACKGROUND);
        }
        this.mToolbar = appBarLayout.toolbar;
        this.mBackground = appBarLayout.background;
        this.mBackGroundLayoutParams = (FrameLayout.LayoutParams)this.mBackground.getLayoutParams();
        this.getBottomSheetBehavior(parent);
        this.mTitleTextView = this.findTitleTextView(this.mToolbar);
        if (this.mTitleTextView == null) {
            return;
        }
        this.mInitialY = child.getY();
        child.setVisibility(this.mVisible ? 0 : 4);
        this.setFullBackGroundColor(this.mVisible && this.mCurrentTitleAlpha == 1 ? R.color.colorPrimary : 17170445);
        this.setPartialBackGroundHeight(0);
        this.mTitleTextView.setText((CharSequence)this.mToolbarTitle);
        this.mTitleTextView.setAlpha((float)this.mCurrentTitleAlpha);
        this.mInit = true;
        this.setToolbarVisible(false, child);
    }

    private void getBottomSheetBehavior(@NonNull CoordinatorLayout coordinatorLayout) {
        for (int i = 0; i < coordinatorLayout.getChildCount(); ++i) {
            View child = coordinatorLayout.getChildAt(i);
            if (!(child instanceof NestedScrollView)) continue;
            try {
                BottomSheetBehaviorGoogleMapsLike<View> temp = BottomSheetBehaviorGoogleMapsLike.from(child);
                this.mBottomSheetBehaviorRef = new WeakReference<BottomSheetBehaviorGoogleMapsLike<View>>(temp);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private boolean isDependencyYBelowAnchorPoint(@NonNull CoordinatorLayout parent, @NonNull View dependency) {
        if (this.mBottomSheetBehaviorRef == null || this.mBottomSheetBehaviorRef.get() == null) {
            this.getBottomSheetBehavior(parent);
        }
        return dependency.getY() > (float)((BottomSheetBehaviorGoogleMapsLike)((Object)this.mBottomSheetBehaviorRef.get())).getAnchorPoint();
    }

    private boolean isDependencyYBetweenAnchorPointAndToolbar(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
        if (this.mBottomSheetBehaviorRef == null || this.mBottomSheetBehaviorRef.get() == null) {
            this.getBottomSheetBehavior(parent);
        }
        return dependency.getY() <= (float)((BottomSheetBehaviorGoogleMapsLike)((Object)this.mBottomSheetBehaviorRef.get())).getAnchorPoint() && dependency.getY() > child.getY() + (float)child.getHeight();
    }

    private boolean isDependencyYBelowToolbar(@NonNull View child, @NonNull View dependency) {
        return dependency.getY() <= child.getY() + (float)child.getHeight() && dependency.getY() > child.getY();
    }

    private boolean isDependencyYBelowStatusToolbar(@NonNull View child, @NonNull View dependency) {
        return dependency.getY() <= child.getY();
    }

    private boolean isDependencyYReachTop(@NonNull View dependency) {
        return dependency.getY() == 0.0f;
    }

    private void setPartialBackGroundHeight(int height) {
        this.mBackGroundLayoutParams.height = height;
        this.mBackground.setLayoutParams((ViewGroup.LayoutParams)this.mBackGroundLayoutParams);
    }

    private void setFullBackGroundColor(@ColorRes int colorRes) {
        this.mToolbar.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)colorRes));
    }

    private TextView findTitleTextView(Toolbar toolbar) {
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            View toolBarChild = toolbar.getChildAt(i);
            if (!(toolBarChild instanceof TextView) || ((TextView)toolBarChild).getText() == null || !((TextView)toolBarChild).getText().toString().contentEquals(this.mContext.getResources().getString(R.string.key_binding_default_toolbar_name))) continue;
            return (TextView)toolBarChild;
        }
        return null;
    }

    private boolean setToolbarVisible(boolean visible, final View child) {
        boolean childMoved = false;
        if (visible && !this.mVisible) {
            childMoved = true;
            child.setY((float)(-child.getHeight() / 3));
            ViewPropertyAnimator mAppBarLayoutAnimation = child.animate().setDuration((long)this.mContext.getResources().getInteger(0x10E0000));
            mAppBarLayoutAnimation.setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    child.setVisibility(0);
                }

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    ((AppCompatActivity)MergedAppBarLayoutBehavior.this.mContext).setSupportActionBar(MergedAppBarLayoutBehavior.this.mToolbar);
                    MergedAppBarLayoutBehavior.this.mToolbar.setNavigationOnClickListener(MergedAppBarLayoutBehavior.this.mOnNavigationClickListener);
                    ActionBar actionBar = ((AppCompatActivity)MergedAppBarLayoutBehavior.this.mContext).getSupportActionBar();
                    if (actionBar != null) {
                        actionBar.setDisplayHomeAsUpEnabled(true);
                    }
                    MergedAppBarLayoutBehavior.this.mVisible = true;
                }
            });
            mAppBarLayoutAnimation.alpha(1.0f).y(this.mInitialY).start();
        } else if (!visible && this.mVisible) {
            ViewPropertyAnimator mAppBarLayoutAnimation = child.animate().setDuration((long)this.mContext.getResources().getInteger(0x10E0000));
            mAppBarLayoutAnimation.setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    child.setVisibility(4);
                }

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    ((AppCompatActivity)MergedAppBarLayoutBehavior.this.mContext).setSupportActionBar(null);
                    MergedAppBarLayoutBehavior.this.mVisible = false;
                }
            });
            mAppBarLayoutAnimation.alpha(0.0f).start();
        }
        return childMoved;
    }

    private boolean isTitleVisible() {
        return this.mTitleTextView.getAlpha() == 1.0f;
    }

    private void setTitleVisible(boolean visible) {
        if (visible && this.mTitleTextView.getAlpha() == 1.0f || !visible && this.mTitleTextView.getAlpha() == 0.0f) {
            return;
        }
        if (this.mTitleAlphaValueAnimator == null || !this.mTitleAlphaValueAnimator.isRunning()) {
            this.mToolbar.setTitle((CharSequence)this.mToolbarTitle);
            boolean startAlpha = !visible;
            this.mCurrentTitleAlpha = visible ? 1 : 0;
            int endAlpha = this.mCurrentTitleAlpha;
            this.mTitleAlphaValueAnimator = ValueAnimator.ofFloat((float[])new float[]{(float)startAlpha, endAlpha});
            this.mTitleAlphaValueAnimator.setDuration((long)this.mContext.getResources().getInteger(0x10E0000));
            this.mTitleAlphaValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    MergedAppBarLayoutBehavior.this.mTitleTextView.setAlpha(((Float)animation.getAnimatedValue()).floatValue());
                }
            });
            this.mTitleAlphaValueAnimator.start();
        }
    }

    private boolean isStatusBarVisible() {
        if (Build.VERSION.SDK_INT >= 21) {
            return ((Activity)this.mContext).getWindow().getStatusBarColor() == ContextCompat.getColor((Context)this.mContext, (int)R.color.colorPrimaryDark);
        }
        return true;
    }

    private void setStatusBarBackgroundVisible(boolean visible) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (visible) {
                Window window = ((Activity)this.mContext).getWindow();
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.colorPrimaryDark));
            } else {
                Window window = ((Activity)this.mContext).getWindow();
                window.clearFlags(Integer.MIN_VALUE);
                window.addFlags(0x4000000);
                window.setStatusBarColor(ContextCompat.getColor((Context)this.mContext, (int)17170445));
            }
        }
    }

    public void setNavigationOnClickListener(View.OnClickListener listener) {
        this.mOnNavigationClickListener = listener;
    }

    public void setToolbarTitle(String title) {
        this.mToolbarTitle = title;
        if (this.mToolbar != null) {
            this.mToolbar.setTitle((CharSequence)title);
        }
    }

    public Parcelable onSaveInstanceState(CoordinatorLayout parent, View child) {
        return new SavedState(super.onSaveInstanceState(parent, child), this.mVisible, this.mToolbarTitle, this.mCurrentTitleAlpha);
    }

    public void onRestoreInstanceState(CoordinatorLayout parent, View child, Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(parent, child, ss.getSuperState());
        this.mVisible = ss.mVisible;
        this.mToolbarTitle = ss.mToolbarTitle;
        this.mCurrentTitleAlpha = ss.mTitleAlpha;
    }

    public static <V extends View> MergedAppBarLayoutBehavior from(V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof MergedAppBarLayoutBehavior)) {
            throw new IllegalArgumentException("The view is not associated with MergedAppBarLayoutBehavior");
        }
        return (MergedAppBarLayoutBehavior)behavior;
    }

    protected static class SavedState
    extends View.BaseSavedState {
        final boolean mVisible;
        final String mToolbarTitle;
        final int mTitleAlpha;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.mVisible = source.readByte() != 0;
            this.mToolbarTitle = source.readString();
            this.mTitleAlpha = source.readInt();
        }

        public SavedState(Parcelable superState, boolean visible, String toolBarTitle, int titleAlpha) {
            super(superState);
            this.mVisible = visible;
            this.mToolbarTitle = toolBarTitle;
            this.mTitleAlpha = titleAlpha;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(this.mVisible ? 1 : 0));
            out.writeString(this.mToolbarTitle);
            out.writeInt(this.mTitleAlpha);
        }
    }
}

