/*
 * Decompiled with CFR 0.152.
 */
package com.mahc.custombottomsheetbehavior;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.View;
import com.mahc.custombottomsheetbehavior.BottomSheetBehaviorGoogleMapsLike;
import java.lang.ref.WeakReference;

public class BackdropBottomSheetBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    private WeakReference<BottomSheetBehaviorGoogleMapsLike> mBottomSheetBehaviorRef;
    private int mCurrentChildY;

    public BackdropBottomSheetBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
        if (dependency instanceof NestedScrollView) {
            try {
                BottomSheetBehaviorGoogleMapsLike.from(dependency);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
        if (this.mBottomSheetBehaviorRef == null || this.mBottomSheetBehaviorRef.get() == null) {
            this.getBottomSheetBehavior(parent);
        }
        int collapsedY = dependency.getHeight() - ((BottomSheetBehaviorGoogleMapsLike)((Object)this.mBottomSheetBehaviorRef.get())).getPeekHeight();
        int achorPointY = child.getHeight();
        int lastCurrentChildY = this.mCurrentChildY;
        this.mCurrentChildY = (int)((dependency.getY() - (float)achorPointY) * (float)collapsedY / (float)(collapsedY - achorPointY));
        if (this.mCurrentChildY <= 0) {
            this.mCurrentChildY = 0;
            child.setY((float)0);
        } else {
            child.setY((float)this.mCurrentChildY);
        }
        return lastCurrentChildY == this.mCurrentChildY;
    }

    private void getBottomSheetBehavior(@NonNull CoordinatorLayout coordinatorLayout) {
        for (int i = 0; i < coordinatorLayout.getChildCount(); ++i) {
            View child = coordinatorLayout.getChildAt(i);
            if (!(child instanceof NestedScrollView)) continue;
            try {
                BottomSheetBehaviorGoogleMapsLike<View> temp = BottomSheetBehaviorGoogleMapsLike.from(child);
                this.mBottomSheetBehaviorRef = new WeakReference<BottomSheetBehaviorGoogleMapsLike<View>>(temp);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

