/*
 * Decompiled with CFR 0.152.
 */
package com.mafstech.mafsimageshape;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.widget.ImageView;

public class Shaper {
    public static void shape(Context context, int originalImage, int shapedImage, ImageView imgView, int expectedHeight, int expectedWidth) {
        Bitmap bitmap;
        Bitmap original = BitmapFactory.decodeResource((Resources)context.getResources(), (int)originalImage);
        Bitmap mask = bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)shapedImage);
        original = Shaper.getResizedBitmap(original, expectedHeight, expectedWidth);
        int bitmapHeight = bitmap.getHeight();
        int bitmapWidth = bitmap.getWidth();
        Bitmap result = Bitmap.createBitmap((int)mask.getWidth(), (int)mask.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas mCanvas = new Canvas(result);
        Paint paint = new Paint(1);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        int widthMask = mask.getWidth();
        int heightMask = mask.getHeight();
        float centerX = (float)(widthMask - original.getWidth()) * 0.5f;
        float centerY = (float)(heightMask - original.getHeight()) * 0.5f;
        mCanvas.drawBitmap(original, centerX, centerY, null);
        mCanvas.drawBitmap(mask, 0.0f, 0.0f, paint);
        paint.setXfermode(null);
        imgView.getLayoutParams().height = bitmapHeight;
        imgView.getLayoutParams().width = bitmapWidth;
        imgView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        imgView.setImageBitmap(result);
        imgView.setAdjustViewBounds(true);
    }

    public static Bitmap getResizedBitmap(Bitmap image, float newHeight, float newWidth) {
        int width = image.getWidth();
        int height = image.getHeight();
        float scaleWidth = newWidth / (float)width;
        float scaleHeight = newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        return resizedBitmap;
    }
}

