/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.InvalidTagNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagCommand
extends GitCommand<RevTag> {
    private RevObject id;
    private String name;
    private String message;
    private PersonIdent tagger;
    private boolean signed;
    private boolean forceUpdate;

    protected TagCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevTag call() throws JGitInternalException, ConcurrentRefUpdateException, InvalidTagNameException, NoHeadException {
        this.checkCallable();
        RepositoryState state = this.repo.getRepositoryState();
        this.processOptions(state);
        try {
            TagBuilder newTag = new TagBuilder();
            newTag.setTag(this.name);
            newTag.setMessage(this.message);
            newTag.setTagger(this.tagger);
            if (this.id == null) {
                ObjectId objectId = this.repo.resolve("HEAD^{commit}");
                if (objectId == null) {
                    throw new NoHeadException(JGitText.get().tagOnRepoWithoutHEADCurrentlyNotSupported);
                }
                newTag.setObjectId(objectId, 1);
            } else {
                newTag.setObjectId(this.id);
            }
            ObjectInserter inserter = this.repo.newObjectInserter();
            try {
                ObjectId tagId = inserter.insert(newTag);
                inserter.flush();
                RevWalk revWalk = new RevWalk(this.repo);
                try {
                    RevTag revTag = revWalk.parseTag(tagId);
                    String refName = "refs/tags/" + newTag.getTag();
                    RefUpdate tagRef = this.repo.updateRef(refName);
                    tagRef.setNewObjectId(tagId);
                    tagRef.setForceUpdate(this.forceUpdate);
                    tagRef.setRefLogMessage("tagged " + this.name, false);
                    RefUpdate.Result updateResult = tagRef.update(revWalk);
                    switch (updateResult) {
                        case NEW: 
                        case FORCED: {
                            RevTag revTag2 = revTag;
                            return revTag2;
                        }
                        case LOCK_FAILURE: {
                            throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, tagRef.getRef(), updateResult);
                        }
                    }
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{refName, newTag.toString(), updateResult}));
                }
                finally {
                    revWalk.release();
                }
            }
            finally {
                inserter.release();
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfTagCommand, e);
        }
    }

    private void processOptions(RepositoryState state) throws InvalidTagNameException {
        if (this.tagger == null) {
            this.tagger = new PersonIdent(this.repo);
        }
        if (this.name == null || !Repository.isValidRefName("refs/tags/" + this.name)) {
            throw new InvalidTagNameException(MessageFormat.format(JGitText.get().tagNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (this.signed) {
            throw new UnsupportedOperationException(JGitText.get().signingNotSupportedOnTag);
        }
    }

    public TagCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public TagCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public TagCommand setSigned(boolean signed) {
        this.signed = signed;
        return this;
    }

    public TagCommand setTagger(PersonIdent tagger) {
        this.tagger = tagger;
        return this;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public RevObject getObjectId() {
        return this.id;
    }

    public TagCommand setObjectId(RevObject id) {
        this.id = id;
        return this;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public TagCommand setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }
}

