/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.ChangeIdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitCommand
extends GitCommand<RevCommit> {
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private boolean all;
    private List<String> only = new ArrayList<String>();
    private boolean[] onlyProcessed;
    private boolean amend;
    private boolean insertChangeId;
    private List<ObjectId> parents = new LinkedList<ObjectId>();

    protected CommitCommand(Repository repo) {
        super(repo);
    }

    /*
     * Exception decompiling
     */
    @Override
    public RevCommit call() throws NoHeadException, NoMessageException, UnmergedPathException, ConcurrentRefUpdateException, JGitInternalException, WrongRepositoryStateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void insertChangeId(ObjectId treeId) throws IOException {
        ObjectId firstParentId = null;
        if (!this.parents.isEmpty()) {
            firstParentId = this.parents.get(0);
        }
        ObjectId changeId = ChangeIdUtil.computeChangeId(treeId, firstParentId, this.author, this.committer, this.message);
        this.message = ChangeIdUtil.insertId(this.message, changeId);
        if (changeId != null) {
            this.message = this.message.replaceAll("\nChange-Id: I" + ObjectId.zeroId().getName() + "\n", "\nChange-Id: I" + changeId.getName() + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirCache createTemporaryIndex(ObjectId headId, DirCache index) throws IOException {
        ObjectInserter inserter = null;
        DirCacheEditor dcEditor = index.editor();
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder dcBuilder = inCoreIndex.builder();
        this.onlyProcessed = new boolean[this.only.size()];
        boolean emptyCommit = true;
        TreeWalk treeWalk = new TreeWalk(this.repo);
        int dcIdx = treeWalk.addTree(new DirCacheIterator(index));
        int fIdx = treeWalk.addTree(new FileTreeIterator(this.repo));
        int hIdx = -1;
        if (headId != null) {
            hIdx = treeWalk.addTree(new RevWalk(this.repo).parseTree(headId));
        }
        treeWalk.setRecursive(true);
        while (treeWalk.next()) {
            String path = treeWalk.getPathString();
            int pos = this.lookupOnly(path);
            CanonicalTreeParser hTree = null;
            if (hIdx != -1) {
                hTree = treeWalk.getTree(hIdx, CanonicalTreeParser.class);
            }
            if (pos >= 0) {
                boolean tracked;
                DirCacheIterator dcTree = treeWalk.getTree(dcIdx, DirCacheIterator.class);
                FileTreeIterator fTree = treeWalk.getTree(fIdx, FileTreeIterator.class);
                boolean bl = tracked = dcTree != null || hTree != null;
                if (!tracked) break;
                if (fTree != null) {
                    boolean objectExists;
                    final DirCacheEntry dcEntry = new DirCacheEntry(path);
                    long entryLength = fTree.getEntryLength();
                    dcEntry.setLength(entryLength);
                    dcEntry.setLastModified(fTree.getEntryLastModified());
                    dcEntry.setFileMode(fTree.getEntryFileMode());
                    boolean bl2 = objectExists = dcTree != null && fTree.idEqual(dcTree) || hTree != null && fTree.idEqual(hTree);
                    if (objectExists) {
                        dcEntry.setObjectId(fTree.getEntryObjectId());
                    } else {
                        Object var24_23;
                        if (inserter == null) {
                            inserter = this.repo.newObjectInserter();
                        }
                        InputStream inputStream = fTree.openEntryStream();
                        try {
                            dcEntry.setObjectId(inserter.insert(3, entryLength, inputStream));
                            var24_23 = null;
                        }
                        catch (Throwable throwable) {
                            var24_23 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                        {
                        }
                    }
                    dcEditor.add(new DirCacheEditor.PathEdit(path){

                        public void apply(DirCacheEntry ent) {
                            ent.copyMetaData(dcEntry);
                        }
                    });
                    dcBuilder.add(dcEntry);
                    if (emptyCommit && (hTree == null || !hTree.idEqual(fTree))) {
                        emptyCommit = false;
                    }
                } else {
                    dcEditor.add(new DirCacheEditor.DeletePath(path));
                    if (emptyCommit && hTree != null) {
                        emptyCommit = false;
                    }
                }
                this.onlyProcessed[pos] = true;
                continue;
            }
            if (hTree == null) continue;
            DirCacheEntry dcEntry = new DirCacheEntry(path);
            dcEntry.setObjectId(hTree.getEntryObjectId());
            dcEntry.setFileMode(hTree.getEntryFileMode());
            dcBuilder.add(dcEntry);
        }
        for (int i = 0; i < this.onlyProcessed.length; ++i) {
            if (this.onlyProcessed[i]) continue;
            throw new JGitInternalException(MessageFormat.format(JGitText.get().entryNotFoundByPath, this.only.get(i)));
        }
        if (emptyCommit) {
            throw new JGitInternalException(JGitText.get().emptyCommit);
        }
        dcEditor.commit();
        dcBuilder.finish();
        return inCoreIndex;
    }

    private int lookupOnly(String pathString) {
        int i = 0;
        for (String o : this.only) {
            String p = pathString;
            while (true) {
                if (p.equals(o)) {
                    return i;
                }
                int l = p.lastIndexOf("/");
                if (l < 1) break;
                p = p.substring(0, l);
            }
            ++i;
        }
        return -1;
    }

    private void processOptions(RepositoryState state) throws NoMessageException {
        if (this.committer == null) {
            this.committer = new PersonIdent(this.repo);
        }
        if (this.author == null) {
            this.author = this.committer;
        }
        if (state == RepositoryState.MERGING_RESOLVED) {
            try {
                this.parents = this.repo.readMergeHeads();
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
            }
            if (this.message == null) {
                try {
                    this.message = this.repo.readMergeCommitMsg();
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
                }
            }
        }
        if (this.message == null) {
            throw new NoMessageException(JGitText.get().commitMessageNotSpecified);
        }
    }

    public CommitCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommitCommand setCommitter(PersonIdent committer) {
        this.checkCallable();
        this.committer = committer;
        return this;
    }

    public CommitCommand setCommitter(String name, String email) {
        this.checkCallable();
        return this.setCommitter(new PersonIdent(name, email));
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public CommitCommand setAuthor(PersonIdent author) {
        this.checkCallable();
        this.author = author;
        return this;
    }

    public CommitCommand setAuthor(String name, String email) {
        this.checkCallable();
        return this.setAuthor(new PersonIdent(name, email));
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public CommitCommand setAll(boolean all) {
        this.checkCallable();
        if (!this.only.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--all", "--only"));
        }
        this.all = all;
        return this;
    }

    public CommitCommand setAmend(boolean amend) {
        this.checkCallable();
        this.amend = amend;
        return this;
    }

    public CommitCommand setOnly(String only) {
        String o;
        this.checkCallable();
        if (this.all) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--only", "--all"));
        }
        String string = o = only.endsWith("/") ? only.substring(0, only.length() - 1) : only;
        if (!this.only.contains(o)) {
            this.only.add(o);
        }
        return this;
    }

    public CommitCommand setInsertChangeId(boolean insertChangeId) {
        this.checkCallable();
        this.insertChangeId = insertChangeId;
        return this;
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result;

        static {
            $SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result = new int[RefUpdate.Result.values().length];
            try {
                2.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[RefUpdate.Result.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[RefUpdate.Result.FORCED.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[RefUpdate.Result.FAST_FORWARD.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[RefUpdate.Result.REJECTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$eclipse$jgit$lib$RefUpdate$Result[RefUpdate.Result.LOCK_FAILURE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

