/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver.diagnostics;

import com.machinepublishers.jbrowserdriver.JBrowserDriver;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.diagnostics.HttpServer;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.logging.LogEntry;

public class Test {
    private static final int TEST_PORT_HTTP = Integer.parseInt(System.getProperty("jbd.testporthttp", "9000"));
    private static final String TEST_PORTS_RMI = System.getProperty("jbd.testportsrmi", "10000-10002");
    private List<String> errors = new ArrayList<String>();
    private int curTest = 0;
    private final boolean inlineOutput;

    public static void main(String[] args) {
        Test test = new Test(true);
        long startTime = System.currentTimeMillis();
        test.doTests();
        long endTime = System.currentTimeMillis();
        System.out.println("Elapsed Time:  " + (endTime - startTime) + " ms  /  " + test.curTest + " tests");
        if (test.errors.isEmpty()) {
            System.out.println("System OK.");
        }
    }

    public static List<String> run() {
        Test test = new Test(false);
        test.doTests();
        return test.errors;
    }

    private Test(boolean inlineOutput) {
        this.inlineOutput = inlineOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void doTests() {
        block44: {
            JBrowserDriver driver = null;
            Thread shutdownHook = null;
            HttpServer.launch(TEST_PORT_HTTP);
            File cacheDir = Files.createTempDirectory("jbd_test_cache", new FileAttribute[0]).toFile();
            File userDataDir = Files.createTempDirectory("jbd_test_userdata", new FileAttribute[0]).toFile();
            shutdownHook = new Thread(() -> {
                FileUtils.deleteQuietly((File)cacheDir);
                FileUtils.deleteQuietly((File)userDataDir);
            });
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            String mainPage = "http://" + InetAddress.getLoopbackAddress().getHostAddress() + ":" + TEST_PORT_HTTP;
            int ajaxWait = 150;
            Settings.Builder builder = Settings.builder().processes(TEST_PORTS_RMI).screen(new Dimension(1024, 768)).logger(null).logJavascript(true).ajaxWait(150L).cacheDir(cacheDir).cache(true).ignoreDialogs(false);
            driver = new JBrowserDriver(builder.build());
            driver.get(mainPage);
            this.test(driver.getStatusCode() == 200);
            long initialRequestId = HttpServer.previousRequestId();
            driver.get(mainPage);
            this.test(driver.getStatusCode() == 200);
            this.test(HttpServer.previousRequestId() == initialRequestId);
            boolean viaHeader = false;
            for (Object line : HttpServer.previousRequest()) {
                if (!((String)line).toLowerCase().startsWith("via:")) continue;
                viaHeader = true;
                break;
            }
            this.test(!viaHeader);
            driver.reset();
            driver.get(mainPage);
            this.test(driver.getStatusCode() == 200);
            this.test(HttpServer.previousRequestId() == initialRequestId);
            driver.reset(builder.cacheDir(null).build());
            driver.get(mainPage);
            this.test(driver.getStatusCode() == 200);
            this.test(HttpServer.previousRequestId() != initialRequestId);
            int messages = 0;
            for (LogEntry entry : driver.manage().logs().get("javascript")) {
                ++messages;
                this.test(!StringUtils.isEmpty((String)entry.getMessage()));
            }
            this.test(messages == 3);
            driver.findElement(By.id((String)"populate-local-storage")).click();
            driver.findElement(By.id((String)"load-from-local-storage")).click();
            this.test("test-value".equals(driver.findElement(By.id((String)"local-storage-value-holder")).getText()));
            driver.get(mainPage);
            driver.findElement(By.id((String)"load-from-local-storage")).click();
            this.test("test-value".equals(driver.findElement(By.id((String)"local-storage-value-holder")).getText()));
            driver.reset();
            driver.get(mainPage);
            driver.findElement(By.id((String)"load-from-local-storage")).click();
            this.test("".equals(driver.findElement(By.id((String)"local-storage-value-holder")).getText()));
            driver.reset(builder.userDataDirectory(userDataDir).build());
            driver.get(mainPage);
            driver.findElement(By.id((String)"populate-local-storage")).click();
            driver.findElement(By.id((String)"load-from-local-storage")).click();
            this.test("test-value".equals(driver.findElement(By.id((String)"local-storage-value-holder")).getText()));
            driver.reset();
            driver.get(mainPage);
            driver.findElement(By.id((String)"load-from-local-storage")).click();
            this.test("test-value".equals(driver.findElement(By.id((String)"local-storage-value-holder")).getText()));
            this.test("test-data-attr".equals(driver.findElement(By.id((String)"divtext1")).getAttribute("data-selected")));
            this.test(driver.findElement(By.id((String)"divtext1")).getAttribute("undefinedattr") == null);
            this.test(driver.findElement(By.id((String)"divtext1")).getAttribute("innerText").equals("test1"));
            this.test(driver.findElements(By.name((String)"divs")).size() == 2);
            this.test(driver.findElements(By.name((String)"divs")).get(1).getAttribute("innerText").equals("test2"));
            this.test(driver.findElementByClassName("divclass").getAttribute("id").equals("divtext1"));
            this.test(driver.findElementsByClassName("divclass").get(1).getAttribute("id").equals("divtext2"));
            this.test(driver.findElementByCssSelector("#divtext1").getAttribute("id").equals("divtext1"));
            this.test(driver.findElementsByCssSelector("html > *").get(1).getAttribute("id").equals("testbody"));
            this.test(driver.findElementById("divtext1").getTagName().equals("div"));
            this.test(driver.findElementsById("divtext1").get(0).getTagName().equals("div"));
            this.test(driver.findElementByLinkText("anchor").getAttribute("id").equals("anchor1"));
            this.test(driver.findElementsByLinkText("anchor").get(1).getAttribute("id").equals("anchor2"));
            this.test(driver.findElementByName("divs").getAttribute("id").equals("divtext1"));
            this.test(driver.findElementsByName("divs").get(1).getAttribute("id").equals("divtext2"));
            this.test(driver.findElementByPartialLinkText("anch").getAttribute("id").equals("anchor1"));
            this.test(driver.findElementsByPartialLinkText("anch").get(1).getAttribute("id").equals("anchor2"));
            this.test(driver.findElementByTagName("div").getAttribute("id").equals("divtext1"));
            this.test(driver.findElementsByTagName("div").get(1).getAttribute("id").equals("divtext2"));
            this.test(driver.findElementByXPath("//*[@id='divtext1']").getAttribute("id").equals("divtext1"));
            this.test(driver.findElementByTagName("body").findElement(By.xpath((String)"//*[@id='divtext1']")).getAttribute("id").equals("divtext1"));
            this.test(driver.findElementsByXPath("//html/*").get(1).getAttribute("id").equals("testbody"));
            this.test(driver.findElement(By.xpath((String)"//a[contains(@href,'1')]")).getAttribute("id").equals("anchor1"));
            this.test(driver.findElementsByXPath("//a[contains(@href,'!!!')]").isEmpty());
            this.test(driver.findElementsByClassName("xx").isEmpty());
            this.test(driver.findElementsByTagName("xx").isEmpty());
            this.test(driver.findElementsByCssSelector("#xx").isEmpty());
            Throwable error = null;
            try {
                driver.findElementByTagName("xx");
            }
            catch (NoSuchElementException e) {
                error = e;
            }
            this.test(error != null);
            error = null;
            try {
                driver.findElementByCssSelector("#xx");
            }
            catch (NoSuchElementException e) {
                error = e;
            }
            this.test(error != null);
            error = null;
            try {
                driver.findElementsByXPath("!!!");
            }
            catch (WebDriverException e) {
                error = e;
            }
            this.test(error != null);
            error = null;
            try {
                driver.findElement(By.id((String)"divtext1")).findElements(By.cssSelector((String)"???"));
            }
            catch (WebDriverException e) {
                error = e;
            }
            this.test(error != null);
            this.test(driver.findElements(By.name((String)"divs")).get(0).equals(driver.findElements(By.name((String)"divs")).get(0)));
            this.test(driver.findElements(By.name((String)"divs")).get(0).hashCode() == driver.findElements(By.name((String)"divs")).get(0).hashCode());
            driver.findElement(By.id((String)"text-input")).sendKeys(new CharSequence[]{"testing"});
            driver.findElement(By.id((String)"text-input")).sendKeys(new CharSequence[]{""});
            this.test(driver.findElement(By.id((String)"text-input")).getAttribute("value").equals("testing"));
            driver.findElement(By.id((String)"text-input")).sendKeys(new CharSequence[]{"jbrowserdriver-keyboard-delete"});
            this.test(driver.findElement(By.id((String)"text-input")).getAttribute("value") == null);
            driver.findElement(By.id((String)"text-input")).sendKeys(new CharSequence[]{"testing"});
            this.test(driver.findElement(By.id((String)"text-input")).getAttribute("value").equals("testing"));
            driver.findElement(By.id((String)"text-input")).clear();
            this.test(driver.findElement(By.id((String)"text-input")).getAttribute("value") == null);
            this.test(!driver.findElement(By.id((String)"testoption2")).isSelected());
            driver.findElement(By.id((String)"testoption2")).click();
            this.test(driver.findElement(By.id((String)"testoption2")).isSelected());
            driver.findElement(By.id((String)"testoption1")).click();
            this.test(driver.findElement(By.id((String)"testoption1")).isSelected());
            driver.findElement(By.id((String)"anchor5")).click();
            this.test("anchor clicked".equals(driver.findElement(By.id((String)"testspan")).getText()));
            this.test(((WebElement)driver.executeScript("return arguments[0];", driver.findElement(By.id((String)"divtext1")))).getAttribute("innerText").equals("test1"));
            this.test(((WebElement)driver.executeScript("return arguments[0].parentNode;", driver.findElement(By.id((String)"divtext1")))).getTagName().equals("body"));
            this.test(((WebElement)((JavascriptExecutor)driver.findElement(By.id((String)"divtext1"))).executeAsyncScript("arguments[0](this);", new Object[0])).getAttribute("innerText").equals("test1"));
            this.test(driver.executeAsyncScript("arguments[1](arguments[0].innerText);", driver.findElement(By.id((String)"divtext1"))).equals("test1"));
            Map map = (Map)driver.executeScript("return {key1:['value1','value2','value3'], key2:5,key3:function(){return 'testing';}, key4:undefined, key5:null, key6:1/0, key7:0/0, key8:'', key9:[], key10:{}, key11:[{},{}],key12:document.getElementById('divtext1'), key13:document.getElementsByName('divs'), key14:[document.getElementById('divtext1'),document.getElementsByName('divs'),{subkey1:'subval1'}]};", new Object[0]);
            this.test(map.size() == 14);
            this.test(((List)map.get("key1")).size() == 3);
            this.test(((List)map.get("key1")).get(2).equals("value3"));
            this.test(((List)map.get("key1")).get(2) instanceof String);
            this.test(map.get("key2").equals(new Long(5L)));
            this.test("function () {return 'testing';}".equals(map.get("key3")) || "function (){return 'testing';}".equals(map.get("key3")));
            this.test(map.get("key4") == null);
            this.test(map.get("key5") == null);
            this.test(Double.isInfinite((Double)map.get("key6")));
            this.test(Double.isNaN((Double)map.get("key7")));
            this.test("".equals(map.get("key8")));
            this.test(map.get("key9") instanceof List);
            this.test(map.get("key10") instanceof Map);
            this.test(((List)map.get("key11")).size() == 2);
            this.test(((Map)((List)map.get("key11")).get(1)).isEmpty());
            this.test("test1".equals(((WebElement)map.get("key12")).getAttribute("innerText")));
            this.test(((List)map.get("key13")).size() == 2);
            this.test(((WebElement)((List)map.get("key13")).get(1)).getAttribute("innerText").equals("test2"));
            this.test(((List)map.get("key14")).size() == 3);
            this.test(((List)((List)map.get("key14")).get(1)).size() == 2);
            this.test(((WebElement)((List)((List)map.get("key14")).get(1)).get(1)).getAttribute("innerText").equals("test2"));
            this.test(((Map)((List)map.get("key14")).get(2)).size() == 1);
            this.test("subval1".equals(((Map)((List)map.get("key14")).get(2)).get("subkey1")));
            this.test(((List)driver.executeScript("return [];", new Object[0])).isEmpty());
            this.test(((Map)driver.executeScript("return {};", new Object[0])).isEmpty());
            error = null;
            try {
                driver.executeScript("invalid.execute()", new Object[0]);
            }
            catch (WebDriverException e) {
                error = e;
            }
            this.test(error != null);
            WebElement element = driver.findElement(By.id((String)"divtext1"));
            Point point = element.getLocation();
            this.test(point.getX() > 0);
            this.test(point.getY() > 0);
            Dimension dimension = element.getSize();
            this.test(dimension.width > 0);
            this.test(dimension.height > 0);
            Rectangle rect = element.getRect();
            this.test(rect.x == point.getX());
            this.test(rect.y == point.getY());
            this.test(rect.width == dimension.getWidth());
            this.test(rect.height == dimension.getHeight());
            this.test("Testing\ntext.".equals(driver.findElement(By.id((String)"text-node1")).getText()));
            this.test("".equals(driver.findElement(By.id((String)"text-node2")).getText()));
            this.test("".equals(driver.findElement(By.id((String)"text-node3")).getText()));
            List<WebElement> options = driver.findElementsByCssSelector("#testselect option");
            this.test(options.size() == 2);
            this.test(options.get(0).isSelected());
            this.test(!options.get(1).isSelected());
            this.test(driver.findElementById("checkbox1").isSelected());
            this.test(!driver.findElementById("checkbox2").isSelected());
            this.test(driver.getPageSource().startsWith("<!DOCTYPE"));
            this.test(driver.getPageSource().contains("<html>"));
            this.test(driver.getPageSource().contains("<head>"));
            this.test(driver.getPageSource().contains("<body "));
            this.test(driver.getPageSource().contains("</html>"));
            this.test(driver.getPageSource().contains("</head>"));
            this.test(driver.getPageSource().contains("</body>"));
            driver.manage().addCookie(new Cookie("testname", "testvalue"));
            Cookie cookie = driver.manage().getCookieNamed("testname");
            this.test(cookie.getValue().equals("testvalue"));
            this.test(InetAddress.getLoopbackAddress().getHostAddress().equals(cookie.getDomain()));
            this.test(((byte[])driver.getScreenshotAs(OutputType.BYTES)).length > 0);
            driver.findElement(By.id((String)"upload")).sendKeys(new CharSequence[]{"some-file"});
            this.test("event-test".equals(driver.findElement(By.id((String)"file-input-onchange")).getText()));
            this.test(driver.findElement(By.id((String)"upload")).getAttribute("value").endsWith("some-file"));
            driver.findElement(By.tagName((String)"button")).click();
            this.test(driver.switchTo().alert().getText().equals("test-alert"));
            driver.switchTo().alert().dismiss();
            this.test(driver.switchTo().alert().getText().equals("test-confirm"));
            driver.switchTo().alert().dismiss();
            this.test(driver.switchTo().alert().getText().equals("test-prompt"));
            driver.switchTo().alert().sendKeys("test-input");
            driver.switchTo().alert().accept();
            this.test(driver.findElement(By.id((String)"testspan")).getAttribute("innerHTML").equals("test-input"));
            List<String> request = HttpServer.previousRequest();
            if (TEST_PORT_HTTP != 443 && TEST_PORT_HTTP != 80) {
                this.test(request.get(1).endsWith(":" + TEST_PORT_HTTP));
            }
            this.test(request.size() > 1);
            HashSet<String> headers = new HashSet<String>();
            for (String line : request) {
                if (!line.contains(":")) continue;
                headers.add(line.split(":")[0].toLowerCase());
            }
            this.test(request.size() - 2 == headers.size());
            driver.findElement(By.id((String)"form-submit")).click();
            this.test(driver.getStatusCode() == 201);
            this.test("form-field=test-form-value".equals(HttpServer.previousRequest().get(HttpServer.previousRequest().size() - 1)));
            driver.switchTo().frame(driver.findElementByTagName("iframe"));
            this.test(driver.findElementById("iframebody") != null);
            driver.switchTo().parentFrame();
            this.test(driver.findElementById("testbody") != null);
            driver.switchTo().frame(0);
            this.test(driver.findElementById("iframebody") != null);
            driver.switchTo().defaultContent();
            driver.switchTo().frame("testiframe");
            this.test(driver.findElementById("iframebody") != null);
            driver.get(mainPage);
            this.test(driver.getPageSource() != null);
            driver.switchTo().frame(driver.findElementByTagName("iframe"));
            this.test(driver.findElementById("iframebody") != null);
            driver.switchTo().parentFrame();
            driver.findElement(By.id((String)"anchor3")).click();
            this.test(driver.getPageSource() != null);
            driver.switchTo().frame(driver.findElementByTagName("iframe"));
            driver.findElement(By.id((String)"iframe-anchor")).click();
            driver.pageWait();
            this.test(HttpServer.previousRequest().get(0).startsWith("GET /iframe.htm?param=fromiframe"));
            driver.get(mainPage);
            driver.switchTo().frame(driver.findElementByTagName("iframe"));
            Actions actions = new Actions((WebDriver)driver);
            actions.moveToElement(driver.findElement(By.id((String)"iframe-anchor")));
            actions.click();
            actions.build().perform();
            driver.pageWait();
            this.test(HttpServer.previousRequest().get(0).startsWith("GET /iframe.htm?param=fromiframe"));
            driver.get(mainPage);
            driver.switchTo().frame(driver.findElementByTagName("iframe"));
            driver.getMouse().click(((Locatable)driver.findElement(By.id((String)"iframe-anchor"))).getCoordinates());
            driver.getMouse().mouseMove(((Locatable)driver.findElement(By.id((String)"iframe-anchor"))).getCoordinates(), 5L, 5L);
            driver.pageWait();
            this.test(HttpServer.previousRequest().get(0).startsWith("GET /iframe.htm?param=fromiframe"));
            driver.get(mainPage + "/redirect/site1#testfragment");
            this.test(HttpServer.previousRequestId() != initialRequestId);
            this.test(driver.getStatusCode() == 200);
            this.test(driver.getCurrentUrl().endsWith("/redirect/site2#testfragment"));
            cookie = driver.manage().getCookieNamed("JSESSIONID");
            this.test(cookie.getValue().equals("ABC123"));
            this.test(InetAddress.getLoopbackAddress().getHostAddress().equals(cookie.getDomain()));
            this.test("jsCookieValue1".equals(driver.manage().getCookieNamed("jsCookieName1").getValue()));
            this.test("jsCookieValue2".equals(driver.manage().getCookieNamed("jsCookieName2").getValue()));
            this.test("jsCookieValue3".equals(driver.manage().getCookieNamed("jsCookieName3").getValue()));
            this.test("jsCookieValue4".equals(driver.manage().getCookieNamed("jsCookieName4").getValue()));
            driver.manage().window().setSize(new Dimension(5000, 5000));
            this.test(driver.manage().window().getSize().getWidth() == 1024);
            this.test(driver.manage().window().getSize().getHeight() == 768);
            driver.manage().window().setSize(new Dimension(800, 600));
            this.test(driver.manage().window().getSize().getWidth() == 800);
            this.test(driver.manage().window().getSize().getHeight() == 600);
            driver.manage().window().setPosition(new Point(5000, 5000));
            this.test(driver.manage().window().getPosition().getX() == 224);
            this.test(driver.manage().window().getPosition().getY() == 168);
            driver.manage().window().setPosition(new Point(20, 50));
            this.test(driver.manage().window().getPosition().getX() == 20);
            this.test(driver.manage().window().getPosition().getY() == 50);
            driver.manage().window().maximize();
            this.test(driver.manage().window().getPosition().getX() == 0);
            this.test(driver.manage().window().getPosition().getY() == 0);
            this.test(driver.manage().window().getSize().getWidth() == 1024);
            this.test(driver.manage().window().getSize().getHeight() == 768);
            driver.manage().window().setSize(new Dimension(800, 600));
            driver.manage().window().setPosition(new Point(20, 50));
            driver.manage().window().fullscreen();
            this.test(driver.manage().window().getPosition().getX() == 0);
            this.test(driver.manage().window().getPosition().getY() == 0);
            this.test(driver.manage().window().getSize().getWidth() == 1024);
            this.test(driver.manage().window().getSize().getHeight() == 768);
            driver.manage().window().fullscreen();
            this.test(driver.manage().window().getPosition().getX() == 20);
            this.test(driver.manage().window().getPosition().getY() == 50);
            this.test(driver.manage().window().getSize().getWidth() == 800);
            this.test(driver.manage().window().getSize().getHeight() == 600);
            driver.manage().window().setSize(new Dimension(400, 200));
            driver.manage().window().setPosition(new Point(10, 30));
            this.test(driver.manage().window().getPosition().getX() == 10);
            this.test(driver.manage().window().getPosition().getY() == 30);
            this.test(driver.manage().window().getSize().getWidth() == 400);
            this.test(driver.manage().window().getSize().getHeight() == 200);
            driver.manage().window().setSize(new Dimension(1024, 768));
            this.test(driver.manage().window().getPosition().getX() == 0);
            this.test(driver.manage().window().getPosition().getY() == 0);
            this.test(driver.manage().window().getSize().getWidth() == 1024);
            this.test(driver.manage().window().getSize().getHeight() == 768);
            this.test(driver.findElement(By.id((String)"iframe-anchor")).isDisplayed());
            this.test(!driver.findElement(By.id((String)"anchor-visibility-hidden")).isDisplayed());
            this.test(!driver.findElement(By.id((String)"anchor-display-none")).isDisplayed());
            error = null;
            try {
                driver.findElement(By.id((String)"anchor-visibility-hidden")).click();
            }
            catch (ElementNotVisibleException e) {
                error = e;
            }
            this.test(error != null);
            error = null;
            try {
                driver.findElement(By.id((String)"anchor-display-none")).click();
            }
            catch (ElementNotVisibleException e) {
                error = e;
            }
            this.test(error != null);
            WebElement body = driver.findElement(By.tagName((String)"body"));
            this.test(!StringUtils.isEmpty((String)body.getAttribute("outerHTML")));
            driver.get("about:blank");
            error = null;
            try {
                body.getAttribute("outerHTML");
            }
            catch (StaleElementReferenceException e) {
                error = e;
            }
            this.test(error != null);
            driver.manage().timeouts().pageLoadTimeout(1L, TimeUnit.MILLISECONDS);
            error = null;
            try {
                driver.get(mainPage + "/wait-forever");
            }
            catch (TimeoutException e) {
                error = e;
            }
            this.test(error != null);
            try {
                driver.quit();
            }
            catch (Throwable t) {
                this.outputError(Test.toString(t));
            }
            try {
                HttpServer.stop();
            }
            catch (Throwable t) {
                this.outputError(Test.toString(t));
            }
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
                shutdownHook.run();
            }
            catch (Throwable t) {}
            break block44;
            catch (Throwable t) {
                try {
                    this.outputError(Test.testLabel("failed", this.curTest + 1, t));
                }
                catch (Throwable throwable) {
                    try {
                        driver.quit();
                    }
                    catch (Throwable t2) {
                        this.outputError(Test.toString(t2));
                    }
                    try {
                        HttpServer.stop();
                    }
                    catch (Throwable t3) {
                        this.outputError(Test.toString(t3));
                    }
                    try {
                        Runtime.getRuntime().removeShutdownHook(shutdownHook);
                        shutdownHook.run();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    driver.quit();
                }
                catch (Throwable t4) {
                    this.outputError(Test.toString(t4));
                }
                try {
                    HttpServer.stop();
                }
                catch (Throwable t5) {
                    this.outputError(Test.toString(t5));
                }
                try {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                    shutdownHook.run();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void outputError(String label) {
        this.errors.add(label);
        if (this.inlineOutput) {
            System.err.println(label);
        }
    }

    private static String testLabel(String result, int curTest, Throwable throwable) {
        String stackTrace = throwable == null ? "" : " -- " + Test.toString(throwable);
        StackTraceElement[] elements = throwable == null ? new Throwable().getStackTrace() : throwable.getStackTrace();
        String testLocation = "";
        for (int i = 0; i < elements.length; ++i) {
            if (!Test.class.getName().equals(elements[i].getClassName()) || !"doTests".equals(elements[i].getMethodName())) continue;
            testLocation = elements[i].toString();
            break;
        }
        return "Test #" + curTest + " " + result + " -- " + testLocation + stackTrace;
    }

    private void test(boolean bool) {
        ++this.curTest;
        if (bool) {
            if (this.inlineOutput) {
                System.out.println(Test.testLabel("passed", this.curTest, null));
            }
        } else {
            this.outputError(Test.testLabel("failed", this.curTest, null));
        }
    }

    private static String toString(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString().replace("\n", " ").replace("\t", " ");
    }
}

