/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.Dimension;
import com.machinepublishers.jbrowserdriver.Point;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.StatusCode;
import com.machinepublishers.jbrowserdriver.WindowRemote;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicReference;
import javafx.stage.Stage;
import org.openqa.selenium.WebDriver;

class WindowServer
extends RemoteObject
implements WindowRemote,
WebDriver.Window {
    private final AtomicReference<Stage> stage;
    private final StatusCode statusCode;

    WindowServer(AtomicReference<Stage> stage, StatusCode statusCode) throws RemoteException {
        this.stage = stage;
        this.statusCode = statusCode;
    }

    @Override
    public void close() {
        AppThread.exec(this.statusCode, () -> {
            this.stage.get().close();
            return null;
        });
    }

    public org.openqa.selenium.Point getPosition() {
        return this.remoteGetPosition().toSelenium();
    }

    @Override
    public Point remoteGetPosition() {
        return AppThread.exec(() -> new Point((int)Math.rint(this.stage.get().getX()), (int)Math.rint(this.stage.get().getY())));
    }

    public org.openqa.selenium.Dimension getSize() {
        return this.remoteGetSize().toSelenium();
    }

    @Override
    public Dimension remoteGetSize() {
        return AppThread.exec(() -> new Dimension((int)Math.rint(this.stage.get().getWidth()), (int)Math.rint(this.stage.get().getHeight())));
    }

    @Override
    public void maximize() {
        AppThread.exec(() -> {
            this.stage.get().setMaximized(!this.stage.get().isMaximized());
            return null;
        });
    }

    public void setPosition(org.openqa.selenium.Point point) {
        AppThread.exec(() -> {
            if (!this.stage.get().isFullScreen()) {
                int screenWidth = SettingsManager.settings().screenWidth();
                int screenHeight = SettingsManager.settings().screenHeight();
                int width = (int)Math.rint(this.stage.get().getWidth());
                int height = (int)Math.rint(this.stage.get().getHeight());
                int newX = Math.max(0, Math.min(screenWidth - width, point.getX()));
                int newY = Math.max(0, Math.min(screenHeight - height, point.getY()));
                this.stage.get().hide();
                this.stage.get().setMaximized(false);
                this.stage.get().setX((double)newX);
                this.stage.get().setY((double)newY);
                this.stage.get().show();
            }
            return null;
        });
    }

    @Override
    public void remoteSetPosition(Point point) {
        this.setPosition(point.toSelenium());
    }

    public void setSize(org.openqa.selenium.Dimension dimension) {
        AppThread.exec(() -> {
            if (!this.stage.get().isFullScreen()) {
                int screenWidth = SettingsManager.settings().screenWidth();
                int screenHeight = SettingsManager.settings().screenHeight();
                int xPos = (int)Math.rint(this.stage.get().getX());
                int yPos = (int)Math.rint(this.stage.get().getY());
                if (dimension.getWidth() > screenWidth - xPos && xPos > 0 || dimension.getHeight() > screenHeight - yPos && yPos > 0) {
                    xPos = 0;
                    yPos = 0;
                }
                int newWidth = Math.max(0, Math.min(screenWidth - xPos, dimension.getWidth()));
                int newHeight = Math.max(0, Math.min(screenHeight - yPos, dimension.getHeight()));
                this.stage.get().hide();
                this.stage.get().setMaximized(false);
                this.stage.get().setX((double)xPos);
                this.stage.get().setY((double)yPos);
                this.stage.get().setWidth((double)newWidth);
                this.stage.get().setHeight((double)newHeight);
                this.stage.get().show();
            }
            return null;
        });
    }

    @Override
    public void remoteSetSize(Dimension dimension) {
        this.setSize(dimension.toSelenium());
    }

    @Override
    public void fullscreen() {
        AppThread.exec(() -> {
            this.stage.get().setFullScreen(!this.stage.get().isFullScreen());
            return null;
        });
    }
}

