/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.google.common.base.CaseFormat;
import com.machinepublishers.jbrowserdriver.Coordinates;
import com.machinepublishers.jbrowserdriver.Element;
import java.util.Arrays;
import java.util.Map;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;

public enum W3CActions {
    PAUSE{

        @Override
        Element perform(Object actionExecutor, Element lastProcessedElement, Map<String, Object> descriptor) {
            try {
                Thread.sleep((Long)descriptor.get("duration"));
                return lastProcessedElement;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }
    ,
    KEY_DOWN{

        @Override
        Element perform(Object actionExecutor, Element lastProcessedElement, Map<String, Object> descriptor) {
            ((Keyboard)actionExecutor).pressKey((CharSequence)descriptor.get("value"));
            return lastProcessedElement;
        }
    }
    ,
    KEY_UP{

        @Override
        Element perform(Object actionExecutor, Element lastProcessedElement, Map<String, Object> descriptor) {
            ((Keyboard)actionExecutor).releaseKey((CharSequence)descriptor.get("value"));
            return lastProcessedElement;
        }
    }
    ,
    POINTER_DOWN{

        @Override
        Element perform(Object actionExecutor, Element lastProcessedElement, Map<String, Object> descriptor) {
            ((Mouse)actionExecutor).mouseDown((org.openqa.selenium.interactions.Coordinates)this.getCoordinetes(lastProcessedElement));
            return lastProcessedElement;
        }
    }
    ,
    POINTER_UP{

        @Override
        Element perform(Object actionExecutor, Element lastProcessedElement, Map<String, Object> descriptor) {
            ((Mouse)actionExecutor).mouseUp((org.openqa.selenium.interactions.Coordinates)this.getCoordinetes(lastProcessedElement));
            return lastProcessedElement;
        }
    }
    ,
    POINTER_MOVE{

        @Override
        Element perform(Object actionExecutor, Element lastProcessedElement, Map<String, Object> descriptor) {
            int x = (Integer)descriptor.get("x");
            int y = (Integer)descriptor.get("y");
            Element currentElement = (Element)descriptor.get("origin");
            ((Mouse)actionExecutor).mouseMove((org.openqa.selenium.interactions.Coordinates)currentElement.getCoordinates(), (long)x, (long)y);
            return currentElement;
        }
    }
    ,
    POINTER_CANCEL{

        @Override
        Element perform(Object actionExecutor, Element lastProcessedElement, Map<String, Object> descriptor) {
            throw new UnsupportedOperationException("Action 'pointerCancel' is not supported");
        }
    };

    private final String type = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());

    abstract Element perform(Object var1, Element var2, Map<String, Object> var3);

    Coordinates getCoordinetes(Element element) {
        return element == null ? null : element.getCoordinates();
    }

    static W3CActions findActionByType(String type) {
        return Arrays.stream(W3CActions.values()).filter(v -> v.type.equals(type)).findFirst().orElseThrow(() -> new IllegalArgumentException("There is no action with type " + type));
    }
}

