/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.TimeoutsRemote;
import com.machinepublishers.jbrowserdriver.TimeoutsServer;
import com.machinepublishers.jbrowserdriver.Util;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriver;

class Timeouts
implements WebDriver.Timeouts {
    private final TimeoutsRemote remote;
    private final SocketLock lock;

    Timeouts(TimeoutsRemote remote, SocketLock lock) {
        this.remote = remote;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeouts implicitlyWait(long duration, TimeUnit unit) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                TimeoutsRemote timeouts = this.remote.implicitlyWait(duration, unit);
                if (timeouts == null) {
                    return null;
                }
                return new Timeouts(timeouts, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeouts pageLoadTimeout(long duration, TimeUnit unit) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                TimeoutsRemote timeouts = this.remote.pageLoadTimeout(duration, unit);
                if (timeouts == null) {
                    return null;
                }
                return new Timeouts(timeouts, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeouts setScriptTimeout(long duration, TimeUnit unit) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                TimeoutsRemote timeouts = this.remote.setScriptTimeout(duration, unit);
                if (timeouts == null) {
                    return null;
                }
                return new Timeouts(timeouts, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeouts setAlertTimeout(long duration, TimeUnit unit) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                TimeoutsServer timeouts = this.remote.setAlertTimeout(duration, unit);
                if (timeouts == null) {
                    return null;
                }
                return new Timeouts(timeouts, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getImplicitlyWaitMS() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getImplicitlyWaitMS();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPageLoadTimeoutMS() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getPageLoadTimeoutMS();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getScriptTimeoutMS() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getScriptTimeoutMS();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getAlertTimeoutMS() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getAlertTimeoutMS();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return -1L;
        }
    }
}

