/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.FileRemover;
import com.machinepublishers.jbrowserdriver.HttpCache;
import com.machinepublishers.jbrowserdriver.LaxCookieSpecProvider;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.ProxyAuth;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.StreamHandler;
import com.machinepublishers.jbrowserdriver.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.ssl.SSLContexts;

class StreamConnectionClient {
    private static final Set<String> nonCachedMethods = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("POST", "PUT", "DELETE", "PATCH")));
    private static final Registry<CookieSpecProvider> cookieProvider = RegistryBuilder.create().register("custom", (Object)new LaxCookieSpecProvider()).build();
    private static Pattern pemBlock = Pattern.compile("-----BEGIN CERTIFICATE-----\\s*(.*?)\\s*-----END CERTIFICATE-----", 32);
    private final HttpCache httpCache;
    private final File cacheDir;
    private final CacheConfig cacheConfig;
    private final Registry<ConnectionSocketFactory> registry;
    private final PoolingHttpClientConnectionManager manager;
    private final CloseableHttpClient client;
    private final CloseableHttpClient cachingClient;
    private final FileRemover shutdownHook;

    StreamConnectionClient() {
        File cacheDirTmp = SettingsManager.settings().cacheDir();
        FileRemover shutdownHookTmp = null;
        try {
            File file = cacheDirTmp = cacheDirTmp == null ? Files.createTempDirectory("jbd_webcache_", new FileAttribute[0]).toFile() : cacheDirTmp;
            if (SettingsManager.settings().cacheDir() == null) {
                shutdownHookTmp = new FileRemover(cacheDirTmp);
                Runtime.getRuntime().addShutdownHook(shutdownHookTmp);
            } else {
                cacheDirTmp.mkdirs();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        this.shutdownHook = shutdownHookTmp;
        this.cacheDir = cacheDirTmp;
        this.httpCache = new HttpCache(cacheDirTmp);
        this.cacheConfig = CacheConfig.custom().setSharedCache(false).setMaxCacheEntries(SettingsManager.settings().cacheEntries()).setMaxObjectSize(SettingsManager.settings().cacheEntrySize()).build();
        SSLConnectionSocketFactory sslSocketFactory = SettingsManager.settings().hostnameVerification() ? new SslSocketFactory(StreamConnectionClient.sslContext()) : new SslSocketWithoutHostnameVerificationFactory(StreamConnectionClient.sslContext());
        this.registry = RegistryBuilder.create().register("https", (Object)sslSocketFactory).register("http", (Object)new SocketFactory()).build();
        this.manager = new PoolingHttpClientConnectionManager(this.registry);
        this.manager.setDefaultMaxPerRoute(SettingsManager.settings().maxRouteConnections());
        this.manager.setMaxTotal(SettingsManager.settings().maxConnections());
        this.client = StreamConnectionClient.clientBuilderHelper(HttpClientBuilder.create(), this.manager);
        this.cachingClient = StreamConnectionClient.clientBuilderHelper((HttpClientBuilder)CachingHttpClientBuilder.create().setCacheConfig(this.cacheConfig).setHttpCacheStorage((HttpCacheStorage)this.httpCache), this.manager);
    }

    private static CloseableHttpClient clientBuilderHelper(HttpClientBuilder builder, PoolingHttpClientConnectionManager manager) {
        return builder.disableRedirectHandling().disableAutomaticRetries().setDefaultCookieSpecRegistry(cookieProvider).setConnectionManager((HttpClientConnectionManager)manager).setRequestExecutor(new HttpRequestExecutor(){

            protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
                request.removeHeaders("Via");
                return super.doSendRequest(request, conn, context);
            }
        }).setDefaultCredentialsProvider((CredentialsProvider)ProxyAuth.instance()).setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE).build();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    File cacheDir() {
        return this.cacheDir;
    }

    void cleanUp() {
        this.manager.closeExpiredConnections();
        this.manager.closeIdleConnections(30L, TimeUnit.SECONDS);
    }

    void shutDown() {
        this.manager.shutdown();
    }

    CloseableHttpResponse execute(HttpRequestBase req, HttpClientContext context) throws ClientProtocolException, IOException {
        return !SettingsManager.settings().cache() || nonCachedMethods.contains(req.getMethod()) ? this.client.execute((HttpUriRequest)req, (HttpContext)context) : this.cachingClient.execute((HttpUriRequest)req, (HttpContext)context);
    }

    private static SSLContext sslContext() {
        block11: {
            String property = SettingsManager.settings().ssl();
            if (property != null && !property.isEmpty() && !"null".equals(property)) {
                if ("trustanything".equals(property)) {
                    try {
                        return SSLContexts.custom().loadTrustMaterial(KeyStore.getInstance(KeyStore.getDefaultType()), (chain, authType) -> true).build();
                    }
                    catch (Throwable t) {
                        LogsServer.instance().exception(t);
                        break block11;
                    }
                }
                try {
                    boolean remote;
                    String location = property;
                    location = location.equals("compatible") ? "https://raw.githubusercontent.com/bagder/ca-bundle/master/ca-bundle.crt" : location;
                    File cachedPemFile = new File("./pemfile_cached");
                    boolean bl = remote = location.startsWith("https://") || location.startsWith("http://");
                    if (remote && cachedPemFile.exists() && System.currentTimeMillis() - cachedPemFile.lastModified() < 172800000L) {
                        location = cachedPemFile.getAbsolutePath();
                        remote = false;
                    }
                    String pemBlocks = null;
                    if (remote) {
                        HttpURLConnection remotePemFile = (HttpURLConnection)StreamHandler.defaultConnection(new URL(location));
                        remotePemFile.setRequestMethod("GET");
                        remotePemFile.connect();
                        pemBlocks = Util.toString(remotePemFile.getInputStream(), Util.charset(remotePemFile));
                        cachedPemFile.delete();
                        Files.write(Paths.get(cachedPemFile.getAbsolutePath(), new String[0]), pemBlocks.getBytes("utf-8"), new OpenOption[0]);
                    } else {
                        pemBlocks = new String(Files.readAllBytes(Paths.get(new File(location).getAbsolutePath(), new String[0])), "utf-8");
                    }
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load(null);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    Matcher matcher = pemBlock.matcher(pemBlocks);
                    boolean found = false;
                    while (matcher.find()) {
                        String pemBlock = matcher.group(1).replaceAll("[\\n\\r]+", "");
                        ByteArrayInputStream byteStream = new ByteArrayInputStream(Base64.getDecoder().decode(pemBlock));
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(byteStream);
                        String alias = cert.getSubjectX500Principal().getName("RFC2253");
                        if (alias == null || keyStore.containsAlias(alias)) continue;
                        found = true;
                        keyStore.setCertificateEntry(alias, cert);
                    }
                    if (found) {
                        KeyManagerFactory keyManager = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        keyManager.init(keyStore, null);
                        TrustManagerFactory trustManager = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustManager.init(keyStore);
                        SSLContext context = SSLContext.getInstance("TLS");
                        context.init(keyManager.getKeyManagers(), trustManager.getTrustManagers(), null);
                        return context;
                    }
                }
                catch (Throwable t) {
                    LogsServer.instance().exception(t);
                }
            }
        }
        return SSLContexts.createSystemDefault();
    }

    private static Socket newSocket(HttpContext context) throws IOException {
        InetSocketAddress proxySocks = (InetSocketAddress)context.getAttribute("proxy.socks.address");
        Socket socket = proxySocks != null ? new Socket(new Proxy(Proxy.Type.SOCKS, proxySocks)) : new Socket();
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        return socket;
    }

    private static class SocketFactory
    extends PlainConnectionSocketFactory {
        private SocketFactory() {
        }

        public Socket createSocket(HttpContext context) throws IOException {
            return StreamConnectionClient.newSocket(context);
        }
    }

    private static class SslSocketWithoutHostnameVerificationFactory
    extends SSLConnectionSocketFactory {
        public SslSocketWithoutHostnameVerificationFactory(SSLContext sslContext) {
            super(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }

        public Socket createSocket(HttpContext context) throws IOException {
            return StreamConnectionClient.newSocket(context);
        }
    }

    private static class SslSocketFactory
    extends SSLConnectionSocketFactory {
        public SslSocketFactory(SSLContext sslContext) {
            super(sslContext);
        }

        public Socket createSocket(HttpContext context) throws IOException {
            return StreamConnectionClient.newSocket(context);
        }
    }
}

