/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.Context;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.Util;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.Event;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Point;

class Robot {
    private static final Map<Keys, int[]> keysMap;
    private static final Map<String, int[]> textMap;
    private static final int LINE_FEED;
    private static final int CARRIAGE_RETURN;
    private static final int ENTER;
    private final AtomicReference<com.sun.glass.ui.Robot> robot = new AtomicReference();
    private final AtomicLong latestThread = new AtomicLong();
    private final AtomicLong curThread = new AtomicLong();
    private final Context context;

    Robot(Context context) {
        this.robot.set(AppThread.exec(context.item().statusCode, () -> Application.GetApplication().createRobot()));
        this.context = context;
    }

    private static int[] convertKey(int codePoint) {
        Keys key;
        char[] chars = Character.toChars(codePoint);
        if (chars.length == 1 && (key = Keys.getKeyFromUnicode((char)chars[0])) != null) {
            return keysMap.get(key);
        }
        String str = new String(new int[]{codePoint}, 0, 1);
        int[] mapping = textMap.get(str);
        return mapping;
    }

    private static boolean isChord(CharSequence charSequence) {
        char[] chars;
        int[] codePoints = charSequence.codePoints().toArray();
        if (codePoints.length > 0 && (chars = Character.toChars(codePoints[codePoints.length - 1])).length == 1) {
            return Keys.NULL.equals((Object)Keys.getKeyFromUnicode((char)chars[0]));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() {
        long myThread = this.latestThread.incrementAndGet();
        AtomicLong atomicLong = this.curThread;
        synchronized (atomicLong) {
            while (myThread != this.curThread.get() + 1L) {
                try {
                    this.curThread.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        AppThread.exec(this.context.item().statusCode, () -> null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        AppThread.exec(this.context.item().statusCode, () -> null);
        this.curThread.incrementAndGet();
        AtomicLong atomicLong = this.curThread;
        synchronized (atomicLong) {
            this.curThread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keysPress(CharSequence chars) {
        this.lock();
        try {
            int[] converted;
            int[] ints = chars.chars().toArray();
            if (ints.length > 0 && (converted = Robot.convertKey(ints[0])) != null) {
                AppThread.exec(this.context.item().statusCode, () -> {
                    for (int j = 0; j < converted.length; ++j) {
                        this.robot.get().keyPress(converted[j]);
                    }
                    return null;
                });
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keysRelease(CharSequence chars) {
        this.lock();
        try {
            int[] converted;
            int[] ints = chars.chars().toArray();
            if (ints.length > 0 && (converted = Robot.convertKey(ints[0])) != null) {
                AppThread.exec(this.context.item().statusCode, () -> {
                    for (int j = converted.length - 1; j > -1; --j) {
                        if (j == 0) {
                            this.context.item().httpListener.get().resetStatusCode();
                        }
                        this.robot.get().keyRelease(converted[j]);
                    }
                    return null;
                });
            }
        }
        finally {
            this.unlock();
        }
    }

    void keysType(CharSequence ... charsList) {
        for (CharSequence chars : charsList) {
            if ("jbrowserdriver-keyboard-delete".equals(chars.toString())) {
                this.keysTypeHelper(Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}));
                this.keysTypeHelper(Keys.BACK_SPACE.toString());
                continue;
            }
            this.keysTypeHelper(chars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keysTypeHelper(CharSequence chars) {
        this.lock();
        try {
            if (Robot.isChord(chars)) {
                int i;
                int[] ints = chars.chars().toArray();
                for (i = 0; i < ints.length; ++i) {
                    int[] converted = Robot.convertKey(ints[i]);
                    if (converted == null) continue;
                    AppThread.exec(true, this.context.item().statusCode, () -> {
                        for (int j = 0; j < converted.length; ++j) {
                            this.robot.get().keyPress(converted[j]);
                        }
                        return null;
                    });
                }
                for (i = ints.length - 1; i > -1; --i) {
                    boolean lastKey = i == 0;
                    int[] converted = Robot.convertKey(ints[i]);
                    if (converted == null) continue;
                    AppThread.exec(false, this.context.item().statusCode, () -> {
                        for (int j = converted.length - 1; j > -1; --j) {
                            if (lastKey && j == 0) {
                                this.context.item().httpListener.get().resetStatusCode();
                            }
                            this.robot.get().keyRelease(converted[j]);
                        }
                        return null;
                    });
                }
            } else {
                int[] ints = chars.chars().toArray();
                for (int i = 0; i < ints.length; ++i) {
                    boolean lastKey = i == ints.length - 1;
                    int codePoint = ints[i] == LINE_FEED || ints[i] == CARRIAGE_RETURN || ints[i] == ENTER ? 13 : ints[i];
                    AppThread.exec(!lastKey, this.context.item().statusCode, () -> {
                        int[] converted = Robot.convertKey(codePoint);
                        if (converted == null) {
                            if (lastKey) {
                                this.context.item().httpListener.get().resetStatusCode();
                            }
                            this.context.item().view.get().fireEvent((Event)new KeyEvent(KeyEvent.KEY_TYPED, new String(new int[]{codePoint}, 0, 1), "", KeyCode.UNDEFINED, false, false, false, false));
                        } else {
                            int j;
                            for (j = 0; j < converted.length; ++j) {
                                this.robot.get().keyPress(converted[j]);
                            }
                            for (j = converted.length - 1; j > -1; --j) {
                                if (lastKey && j == 0) {
                                    this.context.item().httpListener.get().resetStatusCode();
                                }
                                this.robot.get().keyRelease(converted[j]);
                            }
                        }
                        return null;
                    });
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    void typeEnter() {
        this.lock();
        try {
            AppThread.exec(this.context.item().statusCode, () -> {
                this.robot.get().keyPress(10);
                this.robot.get().keyRelease(10);
                return null;
            });
        }
        finally {
            this.unlock();
        }
    }

    void mouseMove(Point point) {
        this.mouseMove(point.getX(), point.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mouseMove(double viewportX, double viewportY) {
        this.lock();
        try {
            AppThread.exec(this.context.item().statusCode, () -> {
                Stage stage = this.context.item().stage.get();
                double adjustedX = Math.max(0.0, Math.min(viewportX, stage.getScene().getWidth() - 1.0));
                double adjustedY = Math.max(0.0, Math.min(viewportY, stage.getScene().getHeight() - 1.0));
                this.robot.get().mouseMove((int)Math.rint(adjustedX + Double.valueOf(stage.getX()) + Double.valueOf(stage.getScene().getX())), (int)Math.rint(adjustedY + Double.valueOf(stage.getY()) + Double.valueOf(stage.getScene().getY())));
                return null;
            });
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mouseMoveBy(double viewportX, double viewportY) {
        this.lock();
        try {
            AppThread.exec(this.context.item().statusCode, () -> {
                Stage stage = this.context.item().stage.get();
                this.robot.get().mouseMove((int)Math.rint(Math.max(0.0, Math.min(stage.getScene().getWidth() - 1.0, viewportX + new Double(Integer.valueOf(this.robot.get().getMouseX()).intValue())))), (int)Math.rint(Math.max(0.0, Math.min(stage.getScene().getHeight() - 1.0, viewportY + new Double(Integer.valueOf(this.robot.get().getMouseY()).intValue())))));
                return null;
            });
        }
        finally {
            this.unlock();
        }
    }

    void mouseClick(MouseButton button) {
        this.lock();
        try {
            this.mousePressHelper(button);
            this.mouseReleaseHelper(button);
        }
        finally {
            this.unlock();
        }
    }

    void mousePress(MouseButton button) {
        this.lock();
        try {
            this.mousePressHelper(button);
        }
        finally {
            this.unlock();
        }
    }

    private void mousePressHelper(MouseButton button) {
        AppThread.exec(this.context.item().statusCode, () -> {
            this.robot.get().mousePress(button.getValue());
            return null;
        });
    }

    void mouseRelease(MouseButton button) {
        this.lock();
        try {
            this.mouseReleaseHelper(button);
        }
        finally {
            this.unlock();
        }
    }

    private void mouseReleaseHelper(MouseButton button) {
        AppThread.exec(true, this.context.item().statusCode, () -> {
            if (button == MouseButton.LEFT) {
                this.context.item().httpListener.get().resetStatusCode();
            }
            this.robot.get().mouseRelease(button.getValue());
            return null;
        });
    }

    void mouseWheel(int wheelAmt) {
        this.lock();
        try {
            AppThread.exec(this.context.item().statusCode, () -> {
                this.robot.get().mouseWheel(wheelAmt);
                return null;
            });
        }
        finally {
            this.unlock();
        }
    }

    byte[] screenshot() {
        this.lock();
        try {
            byte[] byArray = AppThread.exec(this.context.item().statusCode, () -> {
                Object scene;
                BufferedImage image = null;
                Throwable attempt1 = null;
                try {
                    image = SwingFXUtils.fromFXImage((Image)this.context.item().view.get().snapshot(new SnapshotParameters(), new WritableImage((int)Math.rint(this.context.item().view.get().getWidth()), (int)Math.rint(this.context.item().view.get().getHeight()))), null);
                }
                catch (Throwable t) {
                    attempt1 = t;
                }
                Throwable attempt2 = null;
                if (image == null && SettingsManager.isMonocle()) {
                    try {
                        Stage stage = this.context.item().stage.get();
                        scene = stage.getScene();
                        Pixels pixels = this.robot.get().getScreenCapture((int)Math.rint(stage.getX() + scene.getX()), (int)Math.rint(stage.getY() + scene.getY()), (int)Math.rint(scene.getWidth()), (int)Math.rint(scene.getHeight()), false);
                        ByteBuffer pixelBuffer = pixels.asByteBuffer();
                        byte[] bytes = new byte[pixelBuffer.remaining()];
                        pixelBuffer.get(bytes);
                        int bytesPerComponent = pixels.getBytesPerComponent();
                        int width = pixels.getWidth();
                        int height = pixels.getHeight();
                        DataBufferByte buffer = new DataBufferByte(bytes, bytes.length);
                        WritableRaster raster = Raster.createInterleavedRaster(buffer, width, height, bytesPerComponent * width, bytesPerComponent, new int[]{2, 1, 0}, null);
                        ComponentColorModel colorModel = new ComponentColorModel(ColorModel.getRGBdefault().getColorSpace(), false, true, 1, 0);
                        image = new BufferedImage(colorModel, raster, true, null);
                    }
                    catch (Throwable t) {
                        attempt2 = t;
                    }
                }
                if (image != null) {
                    ByteArrayOutputStream out = null;
                    try {
                        out = new ByteArrayOutputStream();
                        ImageIO.write(image, "png", out);
                        scene = out.toByteArray();
                        return scene;
                    }
                    catch (Throwable t) {
                        LogsServer.instance().exception(t);
                    }
                    finally {
                        Util.close(out);
                    }
                }
                LogsServer.instance().exception(attempt1);
                LogsServer.instance().exception(attempt2);
                return null;
            });
            return byArray;
        }
        finally {
            this.unlock();
        }
    }

    static {
        HashMap<Keys, int[]> keysMapTmp = new HashMap<Keys, int[]>();
        keysMapTmp.put(Keys.ADD, new int[]{107});
        keysMapTmp.put(Keys.ALT, new int[]{18});
        keysMapTmp.put(Keys.ARROW_DOWN, new int[]{40});
        keysMapTmp.put(Keys.ARROW_LEFT, new int[]{37});
        keysMapTmp.put(Keys.ARROW_RIGHT, new int[]{39});
        keysMapTmp.put(Keys.ARROW_UP, new int[]{38});
        keysMapTmp.put(Keys.BACK_SPACE, new int[]{8});
        keysMapTmp.put(Keys.CANCEL, new int[]{3});
        keysMapTmp.put(Keys.CLEAR, new int[]{12});
        keysMapTmp.put(Keys.COMMAND, new int[]{157});
        keysMapTmp.put(Keys.CONTROL, new int[]{17});
        keysMapTmp.put(Keys.DECIMAL, new int[]{110});
        keysMapTmp.put(Keys.DELETE, new int[]{127});
        keysMapTmp.put(Keys.DIVIDE, new int[]{111});
        keysMapTmp.put(Keys.DOWN, new int[]{40});
        keysMapTmp.put(Keys.END, new int[]{35});
        keysMapTmp.put(Keys.ENTER, new int[]{10});
        keysMapTmp.put(Keys.EQUALS, new int[]{61});
        keysMapTmp.put(Keys.ESCAPE, new int[]{27});
        keysMapTmp.put(Keys.F1, new int[]{112});
        keysMapTmp.put(Keys.F10, new int[]{121});
        keysMapTmp.put(Keys.F11, new int[]{122});
        keysMapTmp.put(Keys.F12, new int[]{123});
        keysMapTmp.put(Keys.F2, new int[]{113});
        keysMapTmp.put(Keys.F3, new int[]{114});
        keysMapTmp.put(Keys.F4, new int[]{115});
        keysMapTmp.put(Keys.F5, new int[]{116});
        keysMapTmp.put(Keys.F6, new int[]{117});
        keysMapTmp.put(Keys.F7, new int[]{118});
        keysMapTmp.put(Keys.F8, new int[]{119});
        keysMapTmp.put(Keys.F9, new int[]{120});
        keysMapTmp.put(Keys.HELP, new int[]{156});
        keysMapTmp.put(Keys.HOME, new int[]{36});
        keysMapTmp.put(Keys.INSERT, new int[]{155});
        keysMapTmp.put(Keys.LEFT, new int[]{37});
        keysMapTmp.put(Keys.LEFT_ALT, new int[]{18});
        keysMapTmp.put(Keys.LEFT_CONTROL, new int[]{17});
        keysMapTmp.put(Keys.LEFT_SHIFT, new int[]{16});
        keysMapTmp.put(Keys.META, new int[]{157});
        keysMapTmp.put(Keys.MULTIPLY, new int[]{106});
        keysMapTmp.put(Keys.NUMPAD0, new int[]{96});
        keysMapTmp.put(Keys.NUMPAD1, new int[]{97});
        keysMapTmp.put(Keys.NUMPAD2, new int[]{98});
        keysMapTmp.put(Keys.NUMPAD3, new int[]{99});
        keysMapTmp.put(Keys.NUMPAD4, new int[]{100});
        keysMapTmp.put(Keys.NUMPAD5, new int[]{101});
        keysMapTmp.put(Keys.NUMPAD6, new int[]{102});
        keysMapTmp.put(Keys.NUMPAD7, new int[]{103});
        keysMapTmp.put(Keys.NUMPAD8, new int[]{104});
        keysMapTmp.put(Keys.NUMPAD9, new int[]{105});
        keysMapTmp.put(Keys.PAGE_DOWN, new int[]{34});
        keysMapTmp.put(Keys.PAGE_UP, new int[]{33});
        keysMapTmp.put(Keys.PAUSE, new int[]{19});
        keysMapTmp.put(Keys.RETURN, new int[]{10});
        keysMapTmp.put(Keys.RIGHT, new int[]{39});
        keysMapTmp.put(Keys.SEMICOLON, new int[]{59});
        keysMapTmp.put(Keys.SEPARATOR, new int[]{108});
        keysMapTmp.put(Keys.SHIFT, new int[]{16});
        keysMapTmp.put(Keys.SPACE, new int[]{32});
        keysMapTmp.put(Keys.SUBTRACT, new int[]{109});
        keysMapTmp.put(Keys.TAB, new int[]{9});
        keysMapTmp.put(Keys.UP, new int[]{38});
        keysMap = Collections.unmodifiableMap(keysMapTmp);
        HashMap<String, int[]> textMapTmp = new HashMap<String, int[]>();
        textMapTmp.put("1", new int[]{49});
        textMapTmp.put("2", new int[]{50});
        textMapTmp.put("3", new int[]{51});
        textMapTmp.put("4", new int[]{52});
        textMapTmp.put("5", new int[]{53});
        textMapTmp.put("6", new int[]{54});
        textMapTmp.put("7", new int[]{55});
        textMapTmp.put("8", new int[]{56});
        textMapTmp.put("9", new int[]{57});
        textMapTmp.put("0", new int[]{48});
        textMapTmp.put("a", new int[]{65});
        textMapTmp.put("b", new int[]{66});
        textMapTmp.put("c", new int[]{67});
        textMapTmp.put("d", new int[]{68});
        textMapTmp.put("e", new int[]{69});
        textMapTmp.put("f", new int[]{70});
        textMapTmp.put("g", new int[]{71});
        textMapTmp.put("h", new int[]{72});
        textMapTmp.put("i", new int[]{73});
        textMapTmp.put("j", new int[]{74});
        textMapTmp.put("k", new int[]{75});
        textMapTmp.put("l", new int[]{76});
        textMapTmp.put("m", new int[]{77});
        textMapTmp.put("n", new int[]{78});
        textMapTmp.put("o", new int[]{79});
        textMapTmp.put("p", new int[]{80});
        textMapTmp.put("q", new int[]{81});
        textMapTmp.put("r", new int[]{82});
        textMapTmp.put("s", new int[]{83});
        textMapTmp.put("t", new int[]{84});
        textMapTmp.put("u", new int[]{85});
        textMapTmp.put("v", new int[]{86});
        textMapTmp.put("w", new int[]{87});
        textMapTmp.put("x", new int[]{88});
        textMapTmp.put("y", new int[]{89});
        textMapTmp.put("z", new int[]{90});
        textMapTmp.put("A", new int[]{16, 65});
        textMapTmp.put("B", new int[]{16, 66});
        textMapTmp.put("C", new int[]{16, 67});
        textMapTmp.put("D", new int[]{16, 68});
        textMapTmp.put("E", new int[]{16, 69});
        textMapTmp.put("F", new int[]{16, 70});
        textMapTmp.put("G", new int[]{16, 71});
        textMapTmp.put("H", new int[]{16, 72});
        textMapTmp.put("I", new int[]{16, 73});
        textMapTmp.put("J", new int[]{16, 74});
        textMapTmp.put("K", new int[]{16, 75});
        textMapTmp.put("L", new int[]{16, 76});
        textMapTmp.put("M", new int[]{16, 77});
        textMapTmp.put("N", new int[]{16, 78});
        textMapTmp.put("O", new int[]{16, 79});
        textMapTmp.put("P", new int[]{16, 80});
        textMapTmp.put("Q", new int[]{16, 81});
        textMapTmp.put("R", new int[]{16, 82});
        textMapTmp.put("S", new int[]{16, 83});
        textMapTmp.put("T", new int[]{16, 84});
        textMapTmp.put("U", new int[]{16, 85});
        textMapTmp.put("V", new int[]{16, 86});
        textMapTmp.put("W", new int[]{16, 87});
        textMapTmp.put("X", new int[]{16, 88});
        textMapTmp.put("Y", new int[]{16, 89});
        textMapTmp.put("Z", new int[]{16, 90});
        textMapTmp.put("`", new int[]{192});
        textMapTmp.put("-", new int[]{45});
        textMapTmp.put("=", new int[]{61});
        textMapTmp.put("[", new int[]{91});
        textMapTmp.put("]", new int[]{93});
        textMapTmp.put("\\", new int[]{92});
        textMapTmp.put(";", new int[]{59});
        textMapTmp.put("'", new int[]{222});
        textMapTmp.put(",", new int[]{44});
        textMapTmp.put(".", new int[]{46});
        textMapTmp.put("/", new int[]{47});
        textMapTmp.put("~", new int[]{16, 192});
        textMapTmp.put("_", new int[]{16, 45});
        textMapTmp.put("+", new int[]{16, 61});
        textMapTmp.put("{", new int[]{16, 91});
        textMapTmp.put("}", new int[]{16, 93});
        textMapTmp.put("|", new int[]{16, 92});
        textMapTmp.put(":", new int[]{16, 59});
        textMapTmp.put("\"", new int[]{16, 222});
        textMapTmp.put("<", new int[]{16, 44});
        textMapTmp.put(">", new int[]{16, 46});
        textMapTmp.put("?", new int[]{16, 47});
        textMapTmp.put("!", new int[]{16, 49});
        textMapTmp.put("@", new int[]{16, 50});
        textMapTmp.put("#", new int[]{16, 51});
        textMapTmp.put("$", new int[]{16, 52});
        textMapTmp.put("%", new int[]{16, 53});
        textMapTmp.put("^", new int[]{16, 54});
        textMapTmp.put("&", new int[]{16, 55});
        textMapTmp.put("*", new int[]{16, 56});
        textMapTmp.put("(", new int[]{16, 57});
        textMapTmp.put(")", new int[]{16, 48});
        textMapTmp.put("\t", new int[]{9});
        textMapTmp.put("\n", new int[]{10});
        textMapTmp.put(" ", new int[]{32});
        textMap = Collections.unmodifiableMap(textMapTmp);
        LINE_FEED = "\n".codePointAt(0);
        CARRIAGE_RETURN = "\r".codePointAt(0);
        ENTER = Keys.ENTER.toString().codePointAt(0);
    }

    static enum MouseButton {
        LEFT(1),
        MIDDLE(4),
        RIGHT(2);

        private final int value;

        private MouseButton(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

