/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Coordinates;
import com.machinepublishers.jbrowserdriver.MouseRemote;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.Robot;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.interactions.Mouse;

class MouseServer
extends RemoteObject
implements MouseRemote,
Mouse {
    private final AtomicReference<Robot> robot;

    MouseServer(AtomicReference<Robot> robot) throws RemoteException {
        this.robot = robot;
    }

    public void click(org.openqa.selenium.interactions.Coordinates coords) {
        if (coords != null) {
            this.robot.get().mouseMove(coords.inViewPort());
        }
        this.robot.get().mouseClick(Robot.MouseButton.LEFT);
    }

    @Override
    public void remoteClick(Coordinates coords) {
        this.click(coords);
    }

    public void contextClick(org.openqa.selenium.interactions.Coordinates coords) {
        if (coords != null) {
            this.robot.get().mouseMove(coords.inViewPort());
        }
        this.robot.get().mouseClick(Robot.MouseButton.RIGHT);
    }

    @Override
    public void remoteContextClick(Coordinates coords) {
        this.contextClick(coords);
    }

    public void doubleClick(org.openqa.selenium.interactions.Coordinates coords) {
        if (coords != null) {
            this.robot.get().mouseMove(coords.inViewPort());
        }
        this.robot.get().mouseClick(Robot.MouseButton.LEFT);
        this.robot.get().mouseClick(Robot.MouseButton.LEFT);
    }

    @Override
    public void remoteDoubleClick(Coordinates coords) {
        this.doubleClick(coords);
    }

    public void mouseDown(org.openqa.selenium.interactions.Coordinates coords) {
        if (coords != null) {
            this.robot.get().mouseMove(coords.inViewPort());
        }
        this.robot.get().mousePress(Robot.MouseButton.LEFT);
    }

    @Override
    public void remoteMouseDown(Coordinates coords) {
        this.mouseDown(coords);
    }

    public void mouseMove(org.openqa.selenium.interactions.Coordinates coords) {
        this.robot.get().mouseMove(coords.inViewPort());
    }

    @Override
    public void remoteMouseMove(Coordinates coords) {
        this.mouseMove(coords);
    }

    public void mouseMove(org.openqa.selenium.interactions.Coordinates coords, long xOffset, long yOffset) {
        if (coords != null) {
            this.robot.get().mouseMove(coords.inViewPort());
        } else {
            this.robot.get().mouseMoveBy(xOffset, yOffset);
        }
    }

    @Override
    public void remoteMouseMove(Coordinates coords, long xOffset, long yOffset) {
        this.mouseMove(coords, xOffset, yOffset);
    }

    public void mouseUp(org.openqa.selenium.interactions.Coordinates coords) {
        if (coords != null) {
            this.robot.get().mouseMove(coords.inViewPort());
        }
        this.robot.get().mouseRelease(Robot.MouseButton.LEFT);
    }

    @Override
    public void remoteMouseUp(Coordinates coords) {
        this.mouseUp(coords);
    }
}

