/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.glass.ui.monocle.NativePlatform;
import com.machinepublishers.glass.ui.monocle.NativePlatformFactory;
import com.machinepublishers.jbrowserdriver.TitleListener;
import com.sun.glass.ui.Screen;
import com.sun.javafx.webkit.Accessor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class App
extends Application {
    private static final int HISTORY_SIZE = 8;
    private static final Object lock = new Object();
    private static Stage myStage;
    private static WebView myView;
    private int width;
    private int height;
    private boolean headless;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Stage getStage() {
        Object object = lock;
        synchronized (object) {
            while (myStage == null) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return myStage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WebView getView() {
        Object object = lock;
        synchronized (object) {
            while (myView == null) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return myView;
        }
    }

    void init(int width, int height, boolean headless) {
        this.width = width;
        this.height = height;
        this.headless = headless;
    }

    public void init() throws Exception {
        List params = this.getParameters().getRaw();
        this.width = Integer.parseInt((String)params.get(0));
        this.height = Integer.parseInt((String)params.get(1));
        this.headless = Boolean.parseBoolean((String)params.get(2));
    }

    void start() throws Exception {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Stage stage) throws Exception {
        if (this.headless) {
            System.setProperty("headless.geometry", this.width + "x" + this.height);
            NativePlatform platform = NativePlatformFactory.getNativePlatform();
            Field field = NativePlatform.class.getDeclaredField("screen");
            field.setAccessible(true);
            field.set(platform, null);
            Method method = Screen.class.getDeclaredMethod("notifySettingsChanged", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        if (stage == null) {
            stage = new Stage();
        }
        Platform.setImplicitExit((boolean)false);
        WebView view = new WebView();
        view.setCache(false);
        StackPane root = new StackPane();
        root.setCache(false);
        if (this.headless) {
            stage.initStyle(StageStyle.UNDECORATED);
        }
        WebEngine engine = view.getEngine();
        File style = File.createTempFile("jbd_style_", ".css");
        style.deleteOnExit();
        Files.write(style.toPath(), "body::-webkit-scrollbar {width: 0px !important;height:0px !important;}".getBytes("utf-8"), new OpenOption[0]);
        engine.setUserStyleSheetLocation(style.toPath().toUri().toURL().toExternalForm());
        engine.getHistory().setMaxSize(8);
        Accessor.getPageFor((WebEngine)engine).setDeveloperExtrasEnabled(false);
        Accessor.getPageFor((WebEngine)engine).setUsePageCache(false);
        root.getChildren().add((Object)view);
        stage.setScene(new Scene((Parent)root, (double)this.width, (double)this.height));
        stage.sizeToScene();
        engine.titleProperty().addListener((ChangeListener)new TitleListener(stage));
        stage.show();
        Object object = lock;
        synchronized (object) {
            myStage = stage;
            myView = view;
            lock.notifyAll();
        }
    }
}

