/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.glass.ui.monocle;

import com.machinepublishers.glass.ui.monocle.KeyInput;
import com.machinepublishers.glass.ui.monocle.KeyState;
import com.machinepublishers.glass.ui.monocle.MonoclePixels;
import com.machinepublishers.glass.ui.monocle.MouseInput;
import com.machinepublishers.glass.ui.monocle.MouseState;
import com.machinepublishers.glass.ui.monocle.NativePlatformFactory;
import com.machinepublishers.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javafx.application.Platform;

class MonocleRobot
extends Robot {
    MonocleRobot() {
    }

    protected void _create() {
    }

    protected void _destroy() {
    }

    protected void _keyPress(int code) {
        Platform.runLater(() -> {
            KeyState state = new KeyState();
            KeyInput.getInstance().getState(state);
            state.pressKey(code);
            KeyInput.getInstance().setState(state);
        });
    }

    protected void _keyRelease(int code) {
        Platform.runLater(() -> {
            KeyState state = new KeyState();
            KeyInput.getInstance().getState(state);
            state.releaseKey(code);
            KeyInput.getInstance().setState(state);
        });
    }

    protected void _mouseMove(int x, int y) {
        Platform.runLater(() -> {
            MouseState state = new MouseState();
            MouseInput.getInstance().getState(state);
            state.setX(x);
            state.setY(y);
            MouseInput.getInstance().setState(state, false);
        });
    }

    protected void _mousePress(int buttons) {
        Platform.runLater(() -> {
            MouseState state = new MouseState();
            MouseInput.getInstance().getState(state);
            if ((buttons & 1) != 0) {
                state.pressButton(212);
            }
            if ((buttons & 4) != 0) {
                state.pressButton(214);
            }
            if ((buttons & 2) != 0) {
                state.pressButton(213);
            }
            MouseInput.getInstance().setState(state, false);
        });
    }

    protected void _mouseRelease(int buttons) {
        Platform.runLater(() -> {
            MouseState state = new MouseState();
            MouseInput.getInstance().getState(state);
            if ((buttons & 1) != 0) {
                state.releaseButton(212);
            }
            if ((buttons & 4) != 0) {
                state.releaseButton(214);
            }
            if ((buttons & 2) != 0) {
                state.releaseButton(213);
            }
            MouseInput.getInstance().setState(state, false);
        });
    }

    protected void _mouseWheel(int wheelAmt) {
        Platform.runLater(() -> {
            MouseState state = new MouseState();
            MouseInput mouse = MouseInput.getInstance();
            mouse.getState(state);
            int direction = wheelAmt < 0 ? -1 : 1;
            for (int i = 0; i < Math.abs(wheelAmt); ++i) {
                state.setWheel(direction);
                mouse.setState(state, false);
                state.setWheel(0);
                mouse.setState(state, false);
            }
        });
    }

    protected int _getMouseX() {
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        return state.getX();
    }

    protected int _getMouseY() {
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        return state.getY();
    }

    protected int _getPixelColor(int x, int y) {
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int byteDepth = screen.getDepth() >>> 3;
        int bwidth = screen.getWidth();
        int bheight = screen.getHeight();
        if (x < 0 || x > bwidth || y < 0 || y > bheight) {
            return 0;
        }
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            ByteBuffer buffer = screen.getScreenCapture();
            if (byteDepth == 2) {
                ShortBuffer shortbuf = buffer.asShortBuffer();
                short v = shortbuf.get(y * bwidth + x);
                int red = (v & 0xF800) >> 11 << 3;
                int green = (v & 0x7E0) >> 5 << 2;
                int blue = (v & 0x1F) << 3;
                int p = 0xFF000000 | red << 16 | green << 8 | blue;
                return p;
            }
            if (byteDepth >= 4) {
                IntBuffer intbuf = buffer.asIntBuffer();
                return intbuf.get(y * bwidth + x);
            }
            throw new RuntimeException("Unknown bit depth");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pixels _getScreenCapture(int x, int y, int width, int height, boolean isHiDPI) {
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int byteDepth = screen.getDepth() >>> 3;
        int scrWidth = screen.getWidth();
        int scrHeight = screen.getHeight();
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            IntBuffer buffer = screen.getScreenCapture().asIntBuffer();
            if (x == 0 && y == 0 && width == scrWidth && height == scrHeight) {
                return new MonoclePixels(width, height, buffer);
            }
            IntBuffer ret = IntBuffer.allocate(width * height);
            int rowStop = Math.min(y + height, scrHeight);
            int colStop = Math.min(x + width, scrWidth);
            for (int row = y; row < rowStop; ++row) {
                for (int col = x; col < colStop; ++col) {
                    ret.put(buffer.get(row * scrWidth + col));
                }
            }
            ret.rewind();
            return new MonoclePixels(width, height, ret);
        }
    }
}

