/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.Context;
import com.machinepublishers.jbrowserdriver.JBrowserDriverServer;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.NavigationRemote;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.WebDriver;

class NavigationServer
extends RemoteObject
implements NavigationRemote,
WebDriver.Navigation {
    private final AtomicReference<JBrowserDriverServer> driver;
    private final Context context;

    NavigationServer(AtomicReference<JBrowserDriverServer> driver, Context context) throws RemoteException {
        this.driver = driver;
        this.context = context;
    }

    @Override
    public void back() {
        AppThread.exec(this.context.item().statusCode, this.driver.get().manage().timeouts().getPageLoadTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                try {
                    ((NavigationServer)NavigationServer.this).context.item().view.get().getEngine().getHistory().go(-1);
                }
                catch (IndexOutOfBoundsException e) {
                    LogsServer.instance().exception(e);
                }
                return null;
            }
        });
    }

    @Override
    public void forward() {
        AppThread.exec(this.context.item().statusCode, this.driver.get().manage().timeouts().getPageLoadTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                try {
                    ((NavigationServer)NavigationServer.this).context.item().view.get().getEngine().getHistory().go(1);
                }
                catch (IndexOutOfBoundsException e) {
                    LogsServer.instance().exception(e);
                }
                return null;
            }
        });
    }

    @Override
    public void refresh() {
        AppThread.exec(this.context.item().statusCode, this.driver.get().manage().timeouts().getPageLoadTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ((NavigationServer)NavigationServer.this).context.item().view.get().getEngine().reload();
                return null;
            }
        });
    }

    @Override
    public void to(String url) {
        this.driver.get().get(url);
    }

    @Override
    public void to(URL url) {
        this.driver.get().get(url.toExternalForm());
    }
}

