/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.PortGroup;
import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.Util;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMISocketFactory;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

class SocketFactory
extends RMISocketFactory
implements Serializable {
    private final InetAddress host;
    private final int childPort;
    private final int parentPort;
    private final int parentAltPort;
    private final Set<SocketLock> locks;
    private final transient AtomicReference<Socket> clientSocket = new AtomicReference<Socket>(new Socket());
    private final transient AtomicReference<Socket> clientAltSocket = new AtomicReference<Socket>(new Socket());

    SocketFactory(String host, PortGroup ports, Set<SocketLock> locks) {
        InetAddress hostTmp = null;
        try {
            hostTmp = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            Util.handleException(e);
        }
        this.host = hostTmp;
        this.childPort = (int)ports.child;
        this.parentPort = (int)ports.parent;
        this.parentAltPort = (int)ports.parentAlt;
        this.locks = locks;
    }

    private SocketFactory(SocketFactory other) {
        this.host = other.host;
        this.childPort = other.childPort;
        this.parentPort = other.parentPort;
        this.parentAltPort = other.parentAltPort;
        this.locks = other.locks;
    }

    private Object readResolve() {
        return new SocketFactory(this);
    }

    @Override
    public ServerSocket createServerSocket(int p) throws IOException {
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setReuseAddress(true);
        serverSocket.bind(new InetSocketAddress(this.host, this.childPort), Integer.MAX_VALUE);
        return serverSocket;
    }

    @Override
    public Socket createSocket(String h, int p) throws IOException {
        if (this.holdsLock()) {
            return this.createSocket(this.clientSocket, this.parentPort, this.childPort, false);
        }
        return this.createSocket(this.clientAltSocket, this.parentAltPort, this.childPort, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean holdsLock() {
        Set<SocketLock> set = this.locks;
        synchronized (set) {
            for (SocketLock lock : this.locks) {
                if (!Thread.holdsLock(lock)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket createSocket(AtomicReference<Socket> socket, int localPort, int foreignPort, boolean background) throws IOException {
        Class<Object> clazz = Object.class;
        synchronized (Object.class) {
            int retries = 15;
            int i = 1;
            int sleep = 2;
            while (i <= 15) {
                try {
                    if (!background) {
                        Util.close(socket.get());
                    }
                    socket.set(new Socket());
                    socket.get().setReuseAddress(true);
                    socket.get().setTcpNoDelay(true);
                    socket.get().setKeepAlive(true);
                    socket.get().bind(new InetSocketAddress(this.host, localPort));
                    socket.get().connect(new InetSocketAddress(this.host, foreignPort));
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return socket.get();
                }
                catch (IOException e) {
                    try {
                        if (background || i == 15) {
                            throw e;
                        }
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    finally {
                        Util.close(socket.get());
                    }
                    ++i;
                    sleep *= 2;
                }
            }
            throw new IOException();
        }
    }

    public int hashCode() {
        return SocketFactory.class.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SocketFactory;
    }
}

