/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import java.io.Serializable;

public class ProxyConfig
implements Serializable {
    private final Type type;
    private final String host;
    private final int port;
    private final String hostAndPort;
    private final String user;
    private final String password;
    private final boolean expectContinue;

    public ProxyConfig() {
        this.type = null;
        this.host = null;
        this.port = -1;
        this.hostAndPort = null;
        this.user = null;
        this.password = null;
        this.expectContinue = false;
    }

    public ProxyConfig(Type type, String host, int port) {
        this(type, host, port, null, null, true);
    }

    public ProxyConfig(Type type, String host, int port, String user, String password) {
        this(type, host, port, user, password, true);
    }

    public ProxyConfig(Type type, String host, int port, String user, String password, boolean expectContinue) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.hostAndPort = host + ":" + port;
        this.user = user;
        this.password = password;
        this.expectContinue = expectContinue;
    }

    boolean directConnection() {
        return this.type == null || this.host == null || this.host.isEmpty() || this.port == -1;
    }

    boolean credentials() {
        return this.user != null && !this.user.isEmpty() && this.password != null;
    }

    Type type() {
        return this.type;
    }

    String host() {
        return this.host;
    }

    int port() {
        return this.port;
    }

    String hostAndPort() {
        return this.hostAndPort;
    }

    String user() {
        return this.user == null ? "" : this.user;
    }

    String password() {
        return this.password == null ? "" : this.password;
    }

    boolean expectContinue() {
        return this.expectContinue;
    }

    public static enum Type {
        SOCKS,
        HTTP;

    }
}

