/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public class JbdWireLog
implements Log,
Serializable {
    private static final Pattern request = Pattern.compile("^http-outgoing-[0-9]+\\s>>\\s\"(.+)\"$");
    private static final Pattern response = Pattern.compile("^http-outgoing-[0-9]+\\s<<\\s\"((?:HTTP/.+)|(?:[^:]+:\\s.+))\"$");
    private static final int MAX_LEN = 500;
    private static final AtomicReference<Appendable> appender = new AtomicReference();

    public static void setAppender(Appendable appender) {
        JbdWireLog.appender.set(appender);
    }

    public JbdWireLog(String s) {
    }

    public void debug(Object objMessage) {
        String message;
        if (objMessage != null && (message = objMessage.toString()) != null && message.length() < 500) {
            Matcher matcher = request.matcher(message);
            if (matcher.matches()) {
                message = matcher.group(1).replace("[\\r]", "").replace("[\\n]", "");
                if (!message.isEmpty()) {
                    try {
                        appender.get().append("----->> " + message);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                matcher = response.matcher(message);
                if (matcher.matches() && !(message = matcher.group(1).replace("[\\r]", "").replace("[\\n]", "")).isEmpty()) {
                    try {
                        appender.get().append("<<----- " + message);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void debug(Object message, Throwable t) {
    }

    public void error(Object message) {
    }

    public void error(Object message, Throwable t) {
    }

    public void fatal(Object message) {
    }

    public void fatal(Object message, Throwable t) {
    }

    public void info(Object message) {
    }

    public void info(Object message, Throwable t) {
    }

    public void trace(Object message) {
    }

    public void trace(Object message, Throwable t) {
    }

    public void warn(Object message) {
    }

    public void warn(Object message, Throwable t) {
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return false;
    }

    public boolean isFatalEnabled() {
        return false;
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return false;
    }
}

