/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLProtocolException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.ConnectionClosedException;
import org.openqa.selenium.WebDriverException;

class Util {
    private static final Pattern charsetPattern = Pattern.compile("charset\\s*=\\s*([^;]+)", 2);
    private static final Random rand = new Random();
    private static final Random secureRand = new Random();
    static final String KEYBOARD_DELETE = "jbrowserdriver-keyboard-delete";

    Util() {
    }

    static String randomPropertyName() {
        return RandomStringUtils.randomAlphabetic((int)(12 + rand.nextInt(12)));
    }

    static String randomFileName() {
        long num = secureRand.nextLong();
        if (num == Long.MIN_VALUE) {
            num = 0L;
        }
        return RandomStringUtils.randomAlphabetic((int)5).toLowerCase() + Long.toString(Math.abs(num), Math.min(36, 36));
    }

    static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String toString(InputStream inputStream, String charset) {
        try {
            char[] chars = new char[8192];
            StringBuilder builder = new StringBuilder(chars.length);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset), chars.length);
            try {
                int len;
                while (-1 != (len = reader.read(chars, 0, chars.length))) {
                    builder.append(chars, 0, len);
                }
            }
            catch (EOFException | SocketException | SSLProtocolException | ConnectionClosedException throwable) {
                // empty catch block
            }
            String string = builder.toString();
            return string;
        }
        catch (Throwable t) {
            String string = null;
            return string;
        }
        finally {
            Util.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] toBytes(InputStream inputStream) throws IOException {
        try {
            byte[] bytes = new byte[8192];
            ByteArrayOutputStream out = new ByteArrayOutputStream(bytes.length);
            try {
                int len = 0;
                while (-1 != (len = inputStream.read(bytes, 0, bytes.length))) {
                    out.write(bytes, 0, len);
                }
            }
            catch (EOFException | SocketException | SSLProtocolException | ConnectionClosedException throwable) {
                // empty catch block
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            Util.close(inputStream);
        }
    }

    static String charset(URLConnection conn) {
        Matcher matcher;
        String charset = conn.getContentType();
        if (charset != null && (matcher = charsetPattern.matcher(charset)).find() && Charset.isSupported(charset = matcher.group(1))) {
            return charset;
        }
        return "utf-8";
    }

    static void handleException(Throwable throwable) {
        if (throwable != null) {
            Throwable throwable2 = throwable = throwable instanceof UncheckedExecutionException ? throwable.getCause() : throwable;
            if (throwable.getClass().getName().startsWith("org.openqa.selenium.")) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new WebDriverException(throwable);
            }
            if (throwable instanceof RemoteException) {
                throw new WebDriverException("Remote browser exception.", throwable.getCause());
            }
            throw new WebDriverException(throwable);
        }
    }
}

