/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import java.util.LinkedHashMap;
import java.util.Map;

public class UserAgent {
    private static final String baseNavigator;
    private static final String mozNavigator;
    private static final String webkitNavigator;
    public static UserAgent TOR;
    public static UserAgent CHROME;
    private final String script;
    private final String userAgentString;

    public UserAgent(Family family, String vendor, String platform, String oscpu, String appVersion, String userAgentString) {
        StringBuilder builder = new StringBuilder();
        builder.append(baseNavigator);
        if (family == Family.MOZILLA) {
            builder.append(mozNavigator);
        } else if (family == Family.WEBKIT) {
            builder.append(webkitNavigator);
        }
        LinkedHashMap<String, String> navigator = new LinkedHashMap<String, String>();
        navigator.put("language", "'en-US'");
        navigator.put("vendor", "'" + (vendor == null ? "" : vendor) + "'");
        navigator.put("platform", "'" + (platform == null ? "" : platform) + "'");
        navigator.put("oscpu", "'" + (oscpu == null ? "" : oscpu) + "'");
        navigator.put("appVersion", "'" + (appVersion == null ? "" : appVersion) + "'");
        navigator.put("userAgent", "'" + (userAgentString == null ? "" : userAgentString) + "'");
        builder.append(UserAgent.buildNavigator(navigator));
        this.userAgentString = userAgentString;
        this.script = builder.toString();
    }

    private static String buildNavigator(Map<String, String> navigator) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : navigator.entrySet()) {
            if (entry.getKey().contains(".")) {
                int lastDot = entry.getKey().lastIndexOf(".");
                String parent = entry.getKey().substring(0, lastDot);
                String child = entry.getKey().substring(lastDot + 1);
                builder.append("Object.defineProperty(window.navigator.").append(parent).append(",'").append(child).append("',");
                builder.append("{value:").append(entry.getValue()).append("});");
                continue;
            }
            builder.append("try{");
            builder.append("Object.defineProperty(window.navigator,'").append(entry.getKey());
            builder.append("',{value:").append(entry.getValue());
            builder.append("});");
            builder.append("}catch(e){");
            builder.append("window.navigator = Object.create(navigator, {" + entry.getKey());
            builder.append(":{value:").append(entry.getValue()).append("}");
            builder.append("});");
            builder.append("}");
        }
        return builder.toString();
    }

    String userAgentString() {
        return this.userAgentString;
    }

    String script() {
        return this.script;
    }

    static {
        LinkedHashMap<String, String> baseNavigatorTmp = new LinkedHashMap<String, String>();
        baseNavigatorTmp.put("vibrate", "function(){return true;}");
        baseNavigatorTmp.put("vibrate.toString", "function(){return 'function vibrate() { [native code] }';}");
        baseNavigatorTmp.put("javaEnabled", "function(){return false;}");
        baseNavigatorTmp.put("javaEnabled.toString", "function(){return 'function javaEnabled() { [native code] }';}");
        baseNavigatorTmp.put("sendBeacon", "function(){return false;}");
        baseNavigatorTmp.put("sendBeacon.toString", "function(){return 'function sendBeacon() { [native code] }';}");
        baseNavigatorTmp.put("registerProtocolHandler", "function(){}");
        baseNavigatorTmp.put("registerProtocolHandler.toString", "function(){return 'function registerProtocolHandler() { [native code] }';}");
        baseNavigatorTmp.put("registerContentHandler", "function(){}");
        baseNavigatorTmp.put("registerContentHandler.toString", "function(){return 'function registerContentHandler() { [native code] }';}");
        baseNavigatorTmp.put("taintEnabled", "function(){return false;}");
        baseNavigatorTmp.put("taintEnabled.toString", "function(){return 'function taintEnabled() { [native code] }';}");
        baseNavigatorTmp.put("mimeTypes", "navigator.mimeTypes");
        baseNavigatorTmp.put("mimeTypes.toString", "function(){return '[object MimeTypeArray]';}");
        baseNavigatorTmp.put("plugins", "navigator.plugins");
        baseNavigatorTmp.put("plugins.toString", "function(){return '[object PluginArray]';}");
        baseNavigatorTmp.put("doNotTrack", "'unspecified'");
        baseNavigatorTmp.put("cookieEnabled", "true");
        baseNavigatorTmp.put("onLine", "true");
        baseNavigator = UserAgent.buildNavigator(baseNavigatorTmp);
        LinkedHashMap<String, String> mozNavigatorTmp = new LinkedHashMap<String, String>();
        mozNavigatorTmp.put("mozId", "null");
        mozNavigatorTmp.put("mozPay", "null");
        mozNavigatorTmp.put("mozAlarms", "null");
        mozNavigatorTmp.put("mozContacts", "{toString:function(){return '[object ContactManager]';}," + "find:function(){return new Object();}," + "getAll:function(){return new Object();}," + "clear:function(){return new Object();}," + "save:function(){return new Object();}," + "remove:function(){return new Object();}," + "getRevision:function(){return new Object();}," + "getCount:function(){return new Object();}," + "oncontactchange:null," + "addEventListener:function(){return new Object();}," + "removeEventListener:function(){return new Object();}," + "dispatchEvent:function(){return new Object();}," + "}");
        mozNavigatorTmp.put("mozPhoneNumberService", "''");
        mozNavigatorTmp.put("mozApps", "{toString:function(){return '[xpconnect wrapped (nsISupports, mozIDOMApplicationRegistry, mozIDOMApplicationRegistry2)]';}," + "QueryInterface:function(){return new Object();}," + "install:function(){return new Object();}," + "getSelf:function(){return new Object();}," + "checkInstalled:function(){return new Object();}," + "getInstalled:function(){return new Object();}," + "installPackage:function(){return new Object();}," + "mgmt:null," + "}");
        mozNavigatorTmp.put("mozTCPSocket", "null");
        mozNavigatorTmp.put("mozIsLocallyAvailable", "function(){return false;}");
        mozNavigatorTmp.put("mozIsLocallyAvailable.toString", "function(){return 'function mozIsLocallyAvailable() { [native code] }';}");
        mozNavigatorTmp.put("vendorSub", "''");
        mozNavigatorTmp.put("productSub", "'20100101'");
        mozNavigatorTmp.put("buildID", "'20100101'");
        mozNavigatorTmp.put("appCodeName", "'Mozilla'");
        mozNavigatorTmp.put("appName", "'Netscape'");
        mozNavigatorTmp.put("product", "'Gecko'");
        mozNavigator = UserAgent.buildNavigator(mozNavigatorTmp);
        LinkedHashMap<String, String> webkitNavigatorTmp = new LinkedHashMap<String, String>();
        webkitNavigatorTmp.put("vendorSub", "''");
        webkitNavigatorTmp.put("productSub", "'20030107'");
        webkitNavigatorTmp.put("buildID", "'20030107'");
        webkitNavigatorTmp.put("appCodeName", "'Mozilla'");
        webkitNavigatorTmp.put("appName", "'Netscape'");
        webkitNavigatorTmp.put("product", "'Gecko'");
        webkitNavigator = UserAgent.buildNavigator(webkitNavigatorTmp);
        TOR = new UserAgent(Family.MOZILLA, "", "Win32", "Windows NT 6.1", "5.0 (Windows)", "Mozilla/5.0 (Windows NT 6.1; rv:38.0) Gecko/20100101 Firefox/38.0");
        CHROME = new UserAgent(Family.WEBKIT, "Google Inc.", "Win32", "Windows NT 6.1", "5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36");
    }

    public static enum Family {
        MOZILLA,
        WEBKIT;

    }
}

