/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Entries;
import com.machinepublishers.jbrowserdriver.Entry;
import com.machinepublishers.jbrowserdriver.LogsRemote;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.logging.JbdWireLog;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.Logs;

class LogsServer
extends RemoteObject
implements LogsRemote,
Logs {
    private final LinkedList<Entry> wire = new LinkedList();
    private final LinkedList<Entry> javascript = new LinkedList();
    private final LinkedList<Entry> trace = new LinkedList();
    private final LinkedList<Entry> warn = new LinkedList();
    private static final LogsServer instance;

    static void updateSettings() {
        Settings settings = SettingsManager.settings();
        if (settings != null && settings.logWire()) {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.JbdWireLog");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.wire", "DEBUG");
        } else {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "OFF");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.wire", "OFF");
        }
    }

    static LogsServer instance() {
        return instance;
    }

    private LogsServer() throws RemoteException {
    }

    public void clear(String type) {
        this.handleEntries(false, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleMessage(String message, LinkedList<Entry> entries, Level level, String type, Settings settings) {
        if (settings != null && settings.logsMax() > 0) {
            Entry entry = new Entry(level, System.currentTimeMillis(), message);
            LinkedList<Entry> linkedList = entries;
            synchronized (linkedList) {
                entries.add(entry);
                if (entries.size() > settings.logsMax()) {
                    entries.removeFirst();
                }
            }
        }
        if (settings == null || level.intValue() >= settings.loggerLevel()) {
            System.err.println(">" + level.getName() + "/" + type + "/" + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Entries handleEntries(boolean aggregate, String type) {
        LinkedList<Entry> linkedList;
        boolean all;
        ArrayList<Entry> combinedLogs = new ArrayList<Entry>();
        boolean bl = all = type == null || "all".equals(type);
        if (all || "wire".equals(type)) {
            linkedList = this.wire;
            synchronized (linkedList) {
                if (aggregate) {
                    combinedLogs.addAll(this.wire);
                }
                this.wire.clear();
            }
        }
        if (all || "javascript".equals(type)) {
            linkedList = this.javascript;
            synchronized (linkedList) {
                if (aggregate) {
                    combinedLogs.addAll(this.javascript);
                }
                this.javascript.clear();
            }
        }
        if (all || "trace".equals(type)) {
            linkedList = this.trace;
            synchronized (linkedList) {
                if (aggregate) {
                    combinedLogs.addAll(this.trace);
                }
                this.trace.clear();
            }
        }
        if (all || "warnings".equals(type)) {
            linkedList = this.warn;
            synchronized (linkedList) {
                if (aggregate) {
                    combinedLogs.addAll(this.warn);
                }
                this.warn.clear();
            }
        }
        Entries logEntries = new Entries(combinedLogs);
        return logEntries;
    }

    public void wire(String message) {
        Settings settings = SettingsManager.settings();
        if (settings != null && settings.logWire()) {
            LogsServer.handleMessage(message, this.wire, Level.FINEST, "wire", settings);
        }
    }

    public void javascript(String message) {
        Settings settings = SettingsManager.settings();
        if (settings != null && settings.logJavascript()) {
            LogsServer.handleMessage(message, this.javascript, Level.FINER, "javascript", settings);
        }
    }

    public void trace(String message) {
        Settings settings = SettingsManager.settings();
        if (settings != null && settings.logTrace()) {
            LogsServer.handleMessage(message, this.trace, Level.INFO, "trace", settings);
        }
    }

    public void warn(String message) {
        Settings settings = SettingsManager.settings();
        if (settings == null || settings.logWarnings()) {
            LogsServer.handleMessage(message, this.warn, Level.WARNING, "warnings", settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(Throwable throwable) {
        String message = null;
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            message = writer.toString();
        }
        catch (Throwable t) {
            message = "While logging a message, an error occurred: " + t.getMessage();
        }
        finally {
            Util.close(writer);
        }
        this.warn(message);
    }

    @Override
    public Entries getRemote(String type) {
        return this.handleEntries(true, type);
    }

    public LogEntries get(String type) {
        return this.getRemote(type).toLogEntries();
    }

    @Override
    public Set<String> getAvailableLogTypes() {
        return new HashSet<String>(Arrays.asList("all", "wire", "javascript", "trace", "warnings"));
    }

    static {
        JbdWireLog.setAppender(new WireAppender());
        LogsServer instanceTmp = null;
        try {
            instanceTmp = new LogsServer();
        }
        catch (RemoteException e) {
            Util.handleException(e);
        }
        instance = instanceTmp;
    }

    private static class WireAppender
    implements Appendable {
        private WireAppender() {
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            LogsServer.instance().wire(csq.toString());
            return null;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            return null;
        }

        @Override
        public Appendable append(char c) throws IOException {
            return null;
        }
    }
}

