/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AjaxListener;
import com.machinepublishers.jbrowserdriver.ContextItem;
import com.machinepublishers.jbrowserdriver.JavascriptLog;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.StatusMonitor;
import com.sun.javafx.webkit.Accessor;
import com.sun.webkit.LoadListenerClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javafx.scene.web.WebEngine;

class HttpListener
implements LoadListenerClient {
    private static final Map<Integer, String> states;
    private static final Map<Integer, String> errors;
    private final List<Thread> ajaxListeners = new ArrayList<Thread>();
    private final Map<String, Long> resources = new HashMap<String, Long>();
    private final ContextItem contextItem;
    private final AtomicInteger statusCode;
    private final AtomicLong timeoutMS;
    private final StatusMonitor statusMonitor;
    private final LogsServer logs;

    HttpListener(ContextItem contextItem, AtomicInteger statusCode, AtomicLong timeoutMS) {
        this.contextItem = contextItem;
        this.statusCode = statusCode;
        this.timeoutMS = timeoutMS;
        this.statusMonitor = StatusMonitor.instance();
        this.logs = LogsServer.instance();
    }

    private void trace(String label, long frame, int state, String url, String contentType, double progress, int errorCode) {
        if (state != 30) {
            this.logs.trace("-" + label + "-> " + url + " ** {timestamp: " + System.currentTimeMillis() + ", state: " + states.get(state) + ", progress: " + progress + ", error: " + errors.get(errorCode) + ", contentType: " + contentType + ", frame: " + frame + "}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchResourceLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
        Settings settings = SettingsManager.settings();
        if (settings == null) {
            throw new RuntimeException("Request made after browser closed. Ignoring...");
        }
        AtomicInteger atomicInteger = this.statusCode;
        synchronized (atomicInteger) {
            if (url.startsWith("http://") || url.startsWith("https://")) {
                if (state == 20) {
                    this.resources.put(frame + url, System.currentTimeMillis());
                } else if (state == 22 || state == 23) {
                    String original = null;
                    original = this.statusMonitor.originalFromRedirect(url);
                    this.resources.remove(frame + url);
                    if (original != null) {
                        this.resources.remove(frame + original);
                    }
                }
            }
        }
        if (settings.logTrace() && (url.startsWith("http://") || url.startsWith("https://"))) {
            this.trace("Rsrc", frame, state, url, contentType, progress, errorCode);
        }
    }

    void resetStatusCode() {
        this.resetStatusCode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatusCode(boolean startNewListener) {
        AtomicInteger atomicInteger = this.statusCode;
        synchronized (atomicInteger) {
            for (Thread thread : this.ajaxListeners) {
                thread.interrupt();
            }
            this.ajaxListeners.clear();
            this.statusCode.set(0);
            this.resources.clear();
            if (startNewListener) {
                Thread thread = new Thread(new AjaxListener(200, this.statusCode, this.resources, this.timeoutMS.get()));
                this.ajaxListeners.add(thread);
                thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
        Settings settings = SettingsManager.settings();
        if (settings == null) {
            throw new RuntimeException("Request made after browser closed. Ignoring...");
        }
        AtomicInteger atomicInteger = this.statusCode;
        synchronized (atomicInteger) {
            if (state == 0) {
                this.contextItem.resetFrameId(frame);
                if (settings.logJavascript()) {
                    JavascriptLog.attach(Accessor.getPageFor((WebEngine)this.contextItem.engine.get()), frame);
                }
            }
            this.contextItem.addFrameId(frame);
            if (state == 0 || state == 2 || state == 14) {
                if (this.contextItem.currentFrameId() == frame) {
                    if (state == 0) {
                        StatusMonitor.instance().clearStatusMonitor();
                    }
                    this.resetStatusCode(false);
                    this.resources.put(frame + url, System.currentTimeMillis());
                    this.statusMonitor.startStatusMonitor(url);
                }
                this.statusMonitor.addPrimaryDocument(url);
            } else if (this.statusCode.get() == 0 && this.contextItem.currentFrameId() == frame && (state == 1 || state == 6 || state == 5)) {
                int newStatusCode = this.statusMonitor.stopStatusMonitor(url);
                this.resources.remove(frame + url);
                Thread thread = new Thread(new AjaxListener(newStatusCode, this.statusCode, this.resources, this.timeoutMS.get()));
                this.ajaxListeners.add(thread);
                thread.start();
            }
        }
        if (settings.logTrace()) {
            this.trace("Page", frame, state, url, contentType, progress, errorCode);
        }
    }

    static {
        HashMap<Integer, String> statesTmp = new HashMap<Integer, String>();
        statesTmp.put(0, "page_started");
        statesTmp.put(1, "page_finished");
        statesTmp.put(2, "page_redirected");
        statesTmp.put(5, "load_failed");
        statesTmp.put(6, "load_stopped");
        statesTmp.put(10, "content_received");
        statesTmp.put(11, "title_received");
        statesTmp.put(12, "icon_received");
        statesTmp.put(13, "contenttype_received");
        statesTmp.put(14, "document_available");
        statesTmp.put(20, "resource_started");
        statesTmp.put(21, "resource_redirected");
        statesTmp.put(22, "resource_finished");
        statesTmp.put(23, "resource_failed");
        statesTmp.put(30, "progress_changed");
        states = Collections.unmodifiableMap(statesTmp);
        HashMap<Integer, String> errorsTmp = new HashMap<Integer, String>();
        errorsTmp.put(0, "none");
        errorsTmp.put(1, "unknown_host");
        errorsTmp.put(2, "malformed_url");
        errorsTmp.put(3, "ssl_handshake");
        errorsTmp.put(4, "connection_refused");
        errorsTmp.put(5, "connection_reset");
        errorsTmp.put(6, "no_route_to_host");
        errorsTmp.put(7, "connection_timed_out");
        errorsTmp.put(8, "permission_denied");
        errorsTmp.put(9, "invalid_response");
        errorsTmp.put(10, "too_many_redirects");
        errorsTmp.put(11, "file_not_found");
        errorsTmp.put(99, "unknown_error");
        errors = Collections.unmodifiableMap(errorsTmp);
    }
}

