/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.Context;
import com.machinepublishers.jbrowserdriver.ContextItem;
import com.machinepublishers.jbrowserdriver.Dimension;
import com.machinepublishers.jbrowserdriver.ElementId;
import com.machinepublishers.jbrowserdriver.ElementRemote;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.Point;
import com.machinepublishers.jbrowserdriver.Rectangle;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.Robot;
import com.machinepublishers.jbrowserdriver.Util;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.stage.Stage;
import netscape.javascript.JSObject;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLInputElement;
import org.w3c.dom.html.HTMLOptionElement;

class ElementServer
extends RemoteObject
implements ElementRemote,
WebElement,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath {
    private static final String IS_VISIBLE;
    private static final Pattern rgb;
    private static final Map<ElementId, ElementServer> map;
    private final JSObject node;
    private final Context context;
    private final AtomicLong frameId = new AtomicLong();

    ElementServer(final JSObject node, final Context context) throws RemoteException {
        AppThread.exec(context.statusCode, context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ElementServer.validate(node, context.item());
                node.getMember("");
                return null;
            }
        });
        this.node = node;
        this.context = context;
    }

    JSObject node() {
        return this.node;
    }

    void setFrameId(long frameId) {
        this.frameId.set(frameId);
    }

    long frameId() {
        return this.frameId.get();
    }

    static ElementServer create(final Context context) {
        JSObject doc = AppThread.exec(context.statusCode, context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<JSObject>(){

            @Override
            public JSObject perform() {
                ElementServer selectedFrame = context.item().selectedFrame();
                JSObject node = selectedFrame == null ? (JSObject)((Object)context.item().engine.get().getDocument()) : selectedFrame.node;
                return node;
            }
        });
        try {
            return new ElementServer(doc, context);
        }
        catch (RemoteException e) {
            Util.handleException(e);
            return null;
        }
    }

    @Override
    public void activate() {
        this.context.item().selectFrame(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scriptParam(ElementId id) {
        Map<ElementId, ElementServer> map = ElementServer.map;
        synchronized (map) {
            ElementServer.map.put(id, this);
        }
    }

    private static void validate(JSObject node, ContextItem contextItem) {
        JSObject doc;
        if (node == null) {
            throw new NoSuchElementException("Element not found or does not exist.");
        }
        JSObject jSObject = doc = node instanceof Document ? node : (JSObject)((Object)((Node)((Object)node)).getOwnerDocument());
        if (!contextItem.containsFrame(doc)) {
            throw new StaleElementReferenceException("The page containing the element no longer exists.");
        }
        if (!((Boolean)doc.call("contains", node)).booleanValue()) {
            throw new StaleElementReferenceException("The element no longer exists within the page.");
        }
    }

    private void validate(boolean mustBeVisible) {
        ElementServer.validate(this.node, this.context.item());
        if (mustBeVisible && !this.isDisplayed()) {
            throw new ElementNotVisibleException("Element is not visible.");
        }
    }

    @Override
    public void click() {
        AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ElementServer.this.validate(false);
                ElementServer.this.node.call("scrollIntoView", new Object[0]);
                if (((ElementServer)ElementServer.this).context.keyboard.get().isShiftPressed()) {
                    ElementServer.this.node.eval("this.origOnclick = this.onclick;" + "this.onclick=function(event){" + "  this.target='_blank';" + "  if(event){" + "    if(event.stopPropagation){" + "      event.stopPropagation();" + "    }" + "  }" + "  if(this.origOnclick){" + "    this.origOnclick(event? event: null);" + "  }" + "  this.onclick = this.origOnclick;" + "};");
                }
                return null;
            }
        });
        if (this.node instanceof HTMLOptionElement) {
            AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

                @Override
                public Object perform() {
                    ElementServer.this.validate(false);
                    try {
                        new ElementServer((JSObject)((Object)((HTMLOptionElement)((Object)ElementServer.this.node)).getParentNode()), ElementServer.this.context).click();
                    }
                    catch (RemoteException e) {
                        Util.handleException(e);
                    }
                    int index = ((HTMLOptionElement)((Object)ElementServer.this.node)).getIndex();
                    for (int i = 0; i <= index; ++i) {
                        ((ElementServer)ElementServer.this).context.robot.get().keysType(new CharSequence[]{Keys.DOWN});
                    }
                    ((ElementServer)ElementServer.this).context.robot.get().keysType(new CharSequence[]{Keys.SPACE});
                    return null;
                }
            });
        } else {
            AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

                @Override
                public Object perform() {
                    ElementServer.this.validate(true);
                    JSObject obj = (JSObject)ElementServer.this.node.call("getBoundingClientRect", new Object[0]);
                    double top = Double.parseDouble(obj.getMember("top").toString());
                    double left = Double.parseDouble(obj.getMember("left").toString());
                    double bottom = Double.parseDouble(obj.getMember("bottom").toString());
                    double right = Double.parseDouble(obj.getMember("right").toString());
                    double clickX = (left + right) / 2.0;
                    double clickY = (top + bottom) / 2.0;
                    ElementServer doc = ElementServer.create(ElementServer.this.context);
                    if (!ElementServer.this.node.equals(doc.node.eval("(function(){return document.elementFromPoint(" + clickX + "," + clickY + ");})();"))) {
                        Stage stage = ((ElementServer)ElementServer.this).context.item().stage.get();
                        int minX = Math.max(0, (int)Math.floor(left));
                        int maxX = Math.min((int)Math.ceil(stage.getScene().getWidth()), (int)Math.ceil(right));
                        int minY = Math.max(0, (int)Math.floor(top));
                        int maxY = Math.min((int)Math.ceil(stage.getScene().getHeight()), (int)Math.ceil(bottom));
                        int incX = (int)Math.max(1.0, 0.05 * (double)(maxX - minX));
                        int incY = (int)Math.max(1.0, 0.05 * (double)(maxY - minY));
                        for (int x = minX; x <= maxX; x += incX) {
                            boolean found = false;
                            for (int y = minY; y <= maxY; y += incY) {
                                if (!ElementServer.this.node.equals(doc.node.eval("(function(){return document.elementFromPoint(" + x + "," + y + ");})();"))) continue;
                                clickX = x;
                                clickY = y;
                                found = true;
                                break;
                            }
                            if (found) break;
                        }
                    }
                    org.openqa.selenium.Point frameLocation = ElementServer.this.context.item().selectedFrameLocation();
                    ((ElementServer)ElementServer.this).context.robot.get().mouseMove(clickX + (double)frameLocation.getX(), clickY + (double)frameLocation.getY());
                    ((ElementServer)ElementServer.this).context.robot.get().mouseClick(Robot.MouseButton.LEFT);
                    return null;
                }
            });
        }
    }

    @Override
    public void submit() {
        AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ElementServer.this.validate(false);
                ((ElementServer)ElementServer.this).context.item().httpListener.get().resetStatusCode();
                if (ElementServer.this.node instanceof HTMLInputElement) {
                    ((HTMLInputElement)((Object)ElementServer.this.node)).getForm().submit();
                } else if (ElementServer.this.node instanceof HTMLFormElement) {
                    ((HTMLFormElement)((Object)ElementServer.this.node)).submit();
                }
                return null;
            }
        });
    }

    @Override
    public void sendKeys(CharSequence ... keys) {
        boolean fileChooser;
        AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ElementServer.this.validate(true);
                ElementServer.this.node.call("scrollIntoView", new Object[0]);
                ElementServer.this.node.call("focus", new Object[0]);
                return null;
            }
        });
        boolean bl = fileChooser = this.node instanceof HTMLInputElement && "file".equalsIgnoreCase(this.getAttribute("type"));
        if (fileChooser) {
            this.click();
        }
        this.context.robot.get().keysType(keys);
        if (fileChooser) {
            this.context.robot.get().typeEnter();
        }
    }

    @Override
    public void clear() {
        AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ElementServer.this.validate(false);
                ((ElementServer)ElementServer.this).context.item().httpListener.get().resetStatusCode();
                ElementServer.this.node.call("scrollIntoView", new Object[0]);
                ElementServer.this.node.call("focus", new Object[0]);
                ElementServer.this.node.eval("this.value='';");
                return null;
            }
        });
    }

    @Override
    public String getAttribute(final String attrName) {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<String>(){

            @Override
            public String perform() {
                String str;
                ElementServer.this.validate(false);
                Object obj = ElementServer.this.node.getMember(attrName);
                if (obj != null && !StringUtils.isEmpty((String)(str = obj.toString())) && !"undefined".equals(str)) {
                    return str;
                }
                obj = ElementServer.this.executeScript("return this.getAttribute('" + attrName + "');", new Object[0]);
                if (obj != null && !StringUtils.isEmpty((String)(str = obj.toString()))) {
                    return str;
                }
                return null;
            }
        });
    }

    @Override
    public String getCssValue(final String name) {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<String>(){

            @Override
            public String perform() {
                ElementServer.this.validate(false);
                return ElementServer.cleanUpCssVal((String)ElementServer.this.node.eval("var me = this;" + "(function(){" + "  return window.getComputedStyle(me).getPropertyValue('" + name + "');" + "})();"));
            }
        });
    }

    private static String cleanUpCssVal(String rgbStr) {
        Matcher matcher;
        if (rgbStr != null && (matcher = rgb.matcher(rgbStr)).matches()) {
            return "rgba(" + matcher.group(1) + ", " + matcher.group(2) + ", " + matcher.group(3) + ", 1)";
        }
        return rgbStr == null ? "" : rgbStr;
    }

    @Override
    public Point remoteGetLocation() {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Point>(){

            @Override
            public Point perform() {
                ElementServer.this.validate(true);
                JSObject obj = (JSObject)ElementServer.this.node.call("getBoundingClientRect", new Object[0]);
                int y = (int)Math.rint(Double.parseDouble(obj.getMember("top").toString()));
                int x = (int)Math.rint(Double.parseDouble(obj.getMember("left").toString()));
                return new Point(x + 1, y + 1);
            }
        });
    }

    public org.openqa.selenium.Point getLocation() {
        return this.remoteGetLocation().toSelenium();
    }

    @Override
    public Dimension remoteGetSize() {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Dimension>(){

            @Override
            public Dimension perform() {
                ElementServer.this.validate(true);
                JSObject obj = (JSObject)ElementServer.this.node.call("getBoundingClientRect", new Object[0]);
                int y = (int)Math.rint(Double.parseDouble(obj.getMember("top").toString()));
                int y2 = (int)Math.rint(Double.parseDouble(obj.getMember("bottom").toString()));
                int x = (int)Math.rint(Double.parseDouble(obj.getMember("left").toString()));
                int x2 = (int)Math.rint(Double.parseDouble(obj.getMember("right").toString()));
                return new Dimension(x2 - x, y2 - y);
            }
        });
    }

    public org.openqa.selenium.Dimension getSize() {
        return this.remoteGetSize().toSelenium();
    }

    @Override
    public Rectangle remoteGetRect() {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Rectangle>(){

            @Override
            public Rectangle perform() {
                ElementServer.this.validate(true);
                JSObject obj = (JSObject)ElementServer.this.node.call("getBoundingClientRect", new Object[0]);
                int y = (int)Math.rint(Double.parseDouble(obj.getMember("top").toString()));
                int y2 = (int)Math.rint(Double.parseDouble(obj.getMember("bottom").toString()));
                int x = (int)Math.rint(Double.parseDouble(obj.getMember("left").toString()));
                int x2 = (int)Math.rint(Double.parseDouble(obj.getMember("right").toString()));
                return new Rectangle(x + 1, y + 1, y2 - y, x2 - x);
            }
        });
    }

    public org.openqa.selenium.Rectangle getRect() {
        return this.remoteGetRect().toSelenium();
    }

    @Override
    public String getTagName() {
        return this.getAttribute("tagName").toLowerCase();
    }

    @Override
    public String getText() {
        return AppThread.exec(this.context.statusCode, new AppThread.Sync<String>(){

            @Override
            public String perform() {
                ElementServer.this.validate(false);
                if (((Boolean)ElementServer.this.node.eval(IS_VISIBLE)).booleanValue()) {
                    Object text = ElementServer.this.node.getMember("innerText");
                    return text instanceof String ? ((String)text).trim() : "";
                }
                return "";
            }
        });
    }

    @Override
    public boolean isDisplayed() {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Boolean>(){

            @Override
            public Boolean perform() {
                ElementServer.this.validate(false);
                return (Boolean)ElementServer.this.node.eval(IS_VISIBLE);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Boolean>(){

            @Override
            public Boolean perform() {
                ElementServer.this.validate(false);
                String val = ElementServer.this.node.getMember("disabled").toString();
                return val == null || "undefined".equals(val) || val.isEmpty() || "false".equals(val);
            }
        });
    }

    @Override
    public boolean isSelected() {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Boolean>(){

            @Override
            public Boolean perform() {
                ElementServer.this.validate(false);
                String selected = ElementServer.this.node.getMember("selected").toString();
                String checked = ElementServer.this.node.getMember("checked").toString();
                return selected != null && !"undefined".equals(selected) && !"false".equals(selected) && !selected.isEmpty() || checked != null && !"undefined".equals(checked) && !"false".equals(checked) && !checked.isEmpty();
            }
        });
    }

    @Override
    public ElementServer findElement(By by) {
        return (ElementServer)by.findElement((SearchContext)this);
    }

    public List findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    @Override
    public ElementServer findElementByXPath(String expr) {
        List list = this.findElementsByXPath(expr);
        return list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    public List findElementsByXPath(final String expr) {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<List<ElementServer>>(){

            @Override
            public List<ElementServer> perform() {
                ElementServer.this.validate(false);
                return ElementServer.asList(ElementServer.this.executeScript("var iter = " + "  document.evaluate(arguments[0], arguments[1], null, XPathResult.ORDERED_NODE_ITERATOR_TYPE);" + "var items = [];" + "var cur = null;" + "while(cur = iter.iterateNext()){" + "  items.push(cur);" + "}" + "return items;", expr, ElementServer.this.node));
            }
        });
    }

    @Override
    public ElementServer findElementByTagName(String tagName) {
        List list = this.byTagName(tagName);
        return list == null || list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    public List findElementsByTagName(String tagName) {
        return this.byTagName(tagName);
    }

    private List byTagName(final String tagName) {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<List<ElementServer>>(){

            @Override
            public List<ElementServer> perform() {
                ElementServer.this.validate(false);
                if (ElementServer.this.node != null) {
                    return ElementServer.asList(ElementServer.this.parseScriptResult(ElementServer.this.node.call("getElementsByTagName", tagName)));
                }
                return new ArrayList<ElementServer>();
            }
        });
    }

    @Override
    public ElementServer findElementByCssSelector(final String expr) {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<ElementServer>(){

            @Override
            public ElementServer perform() {
                ElementServer.this.validate(false);
                JSObject result = (JSObject)ElementServer.this.node.call("querySelector", expr);
                if (result == null) {
                    return null;
                }
                try {
                    return new ElementServer(result, ElementServer.this.context);
                }
                catch (RemoteException e) {
                    Util.handleException(e);
                    return null;
                }
            }
        });
    }

    public List findElementsByCssSelector(final String expr) {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<List<ElementServer>>(){

            @Override
            public List<ElementServer> perform() {
                Object cur;
                ElementServer.this.validate(false);
                ArrayList<ElementServer> elements = new ArrayList<ElementServer>();
                JSObject result = (JSObject)ElementServer.this.node.call("querySelectorAll", expr);
                int i = 0;
                while ((cur = result.getSlot(i)) instanceof Node) {
                    try {
                        elements.add(new ElementServer((JSObject)cur, ElementServer.this.context));
                    }
                    catch (RemoteException e) {
                        Util.handleException(e);
                    }
                    ++i;
                }
                return elements;
            }
        });
    }

    @Override
    public ElementServer findElementByName(String name) {
        return this.findElementByCssSelector("*[name='" + name + "']");
    }

    public List findElementsByName(String name) {
        return this.findElementsByCssSelector("*[name='" + name + "']");
    }

    @Override
    public ElementServer findElementByLinkText(String text) {
        List list = this.byLinkText(text, false, false);
        return list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    @Override
    public ElementServer findElementByPartialLinkText(String text) {
        List list = this.byLinkText(text, false, true);
        return list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    public List findElementsByLinkText(String text) {
        return this.byLinkText(text, true, false);
    }

    public List findElementsByPartialLinkText(String text) {
        return this.byLinkText(text, true, true);
    }

    private List byLinkText(final String text, final boolean multiple, final boolean partial) {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<List<ElementServer>>(){

            @Override
            public List<ElementServer> perform() {
                ElementServer.this.validate(false);
                ArrayList<ElementServer> elements = new ArrayList<ElementServer>();
                List nodes = ElementServer.this.findElementsByTagName("a");
                for (ElementServer cur : nodes) {
                    String curText = cur.getText();
                    if (curText == null || (!partial || !curText.contains(text)) && (partial || !curText.equals(text))) continue;
                    elements.add(cur);
                    if (multiple) continue;
                    break;
                }
                return elements;
            }
        });
    }

    @Override
    public ElementServer findElementByClassName(String cssClass) {
        List list = this.byCssClass(cssClass);
        return list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    public List findElementsByClassName(String cssClass) {
        return this.byCssClass(cssClass);
    }

    private List byCssClass(String cssClass) {
        return ElementServer.asList(this.executeScript("return this.getElementsByClassName('" + cssClass + "');", new Object[0]));
    }

    @Override
    public ElementServer findElementById(String id) {
        return this.findElementByCssSelector("*[id='" + id + "']");
    }

    public List findElementsById(String id) {
        return this.findElementsByCssSelector("*[id='" + id + "']");
    }

    @Override
    public Object executeAsyncScript(String script, Object ... args) {
        Object result;
        final JavascriptNames jsNames = new JavascriptNames();
        this.script(true, script, args, jsNames);
        int sleep = 1;
        int sleepBackoff = 2;
        int sleepMax = 500;
        do {
            sleep = sleep < 500 ? sleep * 2 : sleep;
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((result = AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ElementServer.this.validate(false);
                try {
                    Object object = ElementServer.this.node.eval("(function(){return this." + jsNames.callbackVal + ";})();");
                    return object;
                }
                finally {
                    ElementServer.this.node.eval("delete " + jsNames.callbackVal + ";");
                }
            }
        })) instanceof String && "undefined".equals(result.toString()));
        Object parsed = this.parseScriptResult(result);
        if (parsed instanceof List) {
            if (((List)parsed).size() == 0) {
                return null;
            }
            if (((List)parsed).size() == 1) {
                return ((List)parsed).get(0);
            }
        }
        return parsed;
    }

    @Override
    public Object executeScript(String script, Object ... args) {
        return this.script(false, script, args, new JavascriptNames());
    }

    private static List<ElementServer> asList(Object objToCast) {
        try {
            return (List)objToCast;
        }
        catch (ClassCastException e) {
            return new ArrayList<ElementServer>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object script(final boolean callback, final String script, final Object[] args, final JavascriptNames jsNames) {
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!(args[i] instanceof ElementId)) continue;
            Map<ElementId, ElementServer> map = ElementServer.map;
            synchronized (map) {
                args[i] = ElementServer.map.remove((Object)args[i]).node;
                continue;
            }
        }
        return this.parseScriptResult(AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object perform() {
                ElementServer.this.validate(false);
                ArrayList<Object> argList = new ArrayList<Object>();
                if (args != null) {
                    argList.addAll(Arrays.asList(args));
                }
                try {
                    if (callback) {
                        argList.add(null);
                        ElementServer.this.node.eval("(function(){" + "this." + jsNames.callback + " = function(){" + jsNames.callbackVal + " = arguments && arguments.length > 0? arguments[0] : null;" + "}" + "}).apply(this);" + "this." + jsNames.exec + " = function(){" + "arguments[arguments.length-1] = this." + jsNames.callback + ";" + "return (function(){" + script + "}).apply(this, arguments);" + "};");
                    } else {
                        ElementServer.this.node.eval("this." + jsNames.exec + " = function(){" + "return (function(){" + script + "}).apply(this, arguments);" + "};");
                    }
                    Object object = ElementServer.this.node.call(jsNames.exec, argList.toArray(new Object[0]));
                    return object;
                }
                catch (Throwable t) {
                    Throwable throwable = t;
                    return throwable;
                }
                finally {
                    ElementServer.this.node.eval("delete " + "this." + jsNames.exec + ";");
                    if (callback) {
                        ElementServer.this.node.eval("delete " + "this." + jsNames.callback + ";");
                    }
                }
            }
        }));
    }

    private Object parseScriptResult(final Object obj) {
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ElementServer.this.validate(false);
                AppThread.handleExecutionException(obj);
                if (obj == null || obj instanceof String && "undefined".equals(obj.toString())) {
                    return null;
                }
                if (obj instanceof Node) {
                    try {
                        return new ElementServer((JSObject)obj, ElementServer.this.context);
                    }
                    catch (RemoteException e) {
                        Util.handleException(e);
                        return null;
                    }
                }
                if (obj instanceof JSObject) {
                    Object cur;
                    ArrayList<Object> list = new ArrayList<Object>();
                    boolean isList = false;
                    int i = 0;
                    while (!((cur = ((JSObject)obj).getSlot(i)) instanceof String) || !"undefined".equals(cur.toString())) {
                        isList = true;
                        list.add(ElementServer.this.parseScriptResult(cur));
                        ++i;
                    }
                    if (isList) {
                        return list;
                    }
                    if ("function".equals(ElementServer.this.executeScript("return typeof arguments[0];", obj))) {
                        return obj.toString();
                    }
                    if (Boolean.TRUE.equals(ElementServer.this.executeScript("return Array.isArray(arguments[0]);", obj))) {
                        return new ArrayList();
                    }
                    List mapAsList = (List)ElementServer.this.executeScript("var list = [];" + "for(var propertyName in arguments[0]){" + "list.push(propertyName);" + "var val = arguments[0][propertyName];" + "list.push(val === undefined? null : val);" + "}" + "return list.length > 0? list : undefined;", obj);
                    LinkedHashMap map = new LinkedHashMap();
                    for (int i2 = 0; mapAsList != null && i2 < mapAsList.size(); i2 += 2) {
                        map.put(mapAsList.get(i2).toString(), mapAsList.get(i2 + 1));
                    }
                    return map;
                }
                if (obj instanceof Boolean || obj instanceof Long || obj instanceof Double) {
                    return obj;
                }
                if (obj instanceof Integer) {
                    return new Long(((Integer)obj).intValue());
                }
                if (obj instanceof Float) {
                    return new Double(((Float)obj).floatValue());
                }
                return obj.toString();
            }
        });
    }

    @Override
    public Point locate() {
        AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Object>(){

            @Override
            public Point perform() {
                ElementServer.this.validate(false);
                ElementServer.this.node.call("scrollIntoView", new Object[0]);
                return null;
            }
        });
        return AppThread.exec(this.context.statusCode, this.context.timeouts.get().getScriptTimeoutMS(), new AppThread.Sync<Point>(){

            @Override
            public Point perform() {
                ElementServer.this.validate(true);
                JSObject obj = (JSObject)ElementServer.this.node.call("getBoundingClientRect", new Object[0]);
                double y = Double.parseDouble(obj.getMember("top").toString());
                double x = Double.parseDouble(obj.getMember("left").toString());
                y = y < 0.0 ? 0.0 : y;
                x = x < 0.0 ? 0.0 : x;
                org.openqa.selenium.Point frameLocation = ElementServer.this.context.item().selectedFrameLocation();
                return new Point((int)Math.rint(x) + 1 + frameLocation.getX(), (int)Math.rint(y) + 1 + frameLocation.getY());
            }
        });
    }

    public <X> X getScreenshotAs(OutputType<X> arg0) throws WebDriverException {
        LogsServer.instance().warn("Screenshot not supported on jBrowserDriver WebElements");
        return null;
    }

    @Override
    public byte[] getScreenshot() throws WebDriverException {
        LogsServer.instance().warn("Screenshot not supported on jBrowserDriver WebElements");
        return null;
    }

    @Override
    public int remoteHashCode() {
        return AppThread.exec(this.context.statusCode, new AppThread.Sync<Integer>(){

            @Override
            public Integer perform() {
                ElementServer.this.validate(false);
                return ElementServer.this.node.hashCode();
            }
        });
    }

    @Override
    public boolean remoteEquals(final ElementId id) {
        return AppThread.exec(this.context.statusCode, new AppThread.Sync<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean perform() {
                ElementServer other;
                ElementServer.this.validate(false);
                Map map = map;
                synchronized (map) {
                    other = (ElementServer)map.remove(id);
                }
                other.validate(false);
                return ElementServer.this.node.equals(other.node);
            }
        });
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("var me = this;");
        builder.append("(function(){");
        builder.append("var findEffectiveStyle = function(element) {");
        builder.append("  if (element.style == undefined) {");
        builder.append("    return undefined;");
        builder.append("  }");
        builder.append("  if (window.getComputedStyle) {");
        builder.append("    return window.getComputedStyle(element, null);");
        builder.append("  }");
        builder.append("  if (element.currentStyle) {");
        builder.append("    return element.currentStyle;");
        builder.append("  }");
        builder.append("  if (window.document.defaultView && window.document.defaultView.getComputedStyle) {");
        builder.append("    return window.document.defaultView.getComputedStyle(element, null);");
        builder.append("  }");
        builder.append("  return undefined;");
        builder.append("};");
        builder.append("var findEffectiveStyleProperty = function(element, property) {");
        builder.append("  var effectiveStyle = findEffectiveStyle(element);");
        builder.append("  var propertyValue = effectiveStyle[property];");
        builder.append("  if (propertyValue == 'inherit' && element.parentNode.style) {");
        builder.append("    return findEffectiveStyleProperty(element.parentNode, property);");
        builder.append("  }");
        builder.append("  return propertyValue;");
        builder.append("};");
        builder.append("var isDisplayed = function(element) {");
        builder.append("  var display = findEffectiveStyleProperty(element, \"display\");");
        builder.append("  if (display == \"none\") return false;");
        builder.append("  if (element.parentNode.style) {");
        builder.append("    return isDisplayed(element.parentNode);");
        builder.append("  }");
        builder.append("  return true;");
        builder.append("};");
        builder.append("var isVisible = function(element) {");
        builder.append("  if (element.tagName) {");
        builder.append("    var tagName = new String(element.tagName).toLowerCase();");
        builder.append("    if (tagName == \"input\") {");
        builder.append("      if (element.type) {");
        builder.append("        var elementType = new String(element.type).toLowerCase();");
        builder.append("        if (elementType == \"hidden\") {");
        builder.append("          return false;");
        builder.append("        }");
        builder.append("      }");
        builder.append("    }");
        builder.append("  }");
        builder.append("  var visibility = findEffectiveStyleProperty(element, \"visibility\");");
        builder.append("  return (visibility != \"hidden\" && isDisplayed(element));");
        builder.append("};");
        builder.append("return isVisible(me);");
        builder.append("})();");
        IS_VISIBLE = builder.toString();
        rgb = Pattern.compile("rgb\\(([0-9]{1,3}), ([0-9]{1,3}), ([0-9]{1,3})\\)");
        map = new HashMap<ElementId, ElementServer>();
    }

    private static class JavascriptNames {
        private final String callbackVal = Util.randomPropertyName();
        private final String callback = Util.randomPropertyName();
        private final String exec = Util.randomPropertyName();

        private JavascriptNames() {
        }
    }
}

