/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Coordinates;
import com.machinepublishers.jbrowserdriver.ElementId;
import com.machinepublishers.jbrowserdriver.ElementRemote;
import com.machinepublishers.jbrowserdriver.JBrowserDriver;
import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;

class Element
implements WebElement,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath,
Locatable,
WrapsDriver {
    private final ElementRemote remote;
    private final JBrowserDriver driver;
    private final SocketLock lock;

    private Element(ElementRemote remote, JBrowserDriver driver, SocketLock lock) {
        this.remote = remote;
        this.driver = driver;
        this.lock = lock;
    }

    static List<WebElement> constructList(List<ElementRemote> elements, JBrowserDriver driver, SocketLock lock) {
        ArrayList<WebElement> ret = new ArrayList<WebElement>();
        if (elements != null) {
            for (ElementRemote element : elements) {
                if (element == null) continue;
                ret.add(new Element(element, driver, lock));
            }
        }
        return ret;
    }

    static WebElement constructElement(ElementRemote element, JBrowserDriver driver, SocketLock lock) {
        if (element == null) {
            throw new NoSuchElementException("Element not found.");
        }
        return new Element(element, driver, lock);
    }

    static Object constructObject(Object obj, JBrowserDriver driver, SocketLock lock) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ElementRemote) {
            return new Element((ElementRemote)obj, driver, lock);
        }
        if (obj instanceof List) {
            ArrayList<Object> retList = new ArrayList<Object>();
            for (Object item : (List)obj) {
                retList.add(Element.constructObject(item, driver, lock));
            }
            return retList;
        }
        if (obj instanceof Map) {
            LinkedHashMap retMap = new LinkedHashMap();
            for (Object key : ((Map)obj).keySet()) {
                retMap.put(key, Element.constructObject(((Map)obj).get(key), driver, lock));
            }
            return retMap;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.activate();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scriptParam(ElementId id) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.scriptParam(id);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.click();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.submit();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeys(CharSequence ... keys) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.sendKeys(keys);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.clear();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttribute(String attrName) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getAttribute(attrName);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCssValue(String name) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getCssValue(name);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocation() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.remoteGetLocation().toSelenium();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getSize() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.remoteGetSize().toSelenium();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getRect() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.remoteGetRect().toSelenium();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTagName() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getTagName();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getText();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisplayed() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.isDisplayed();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.isEnabled();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.isSelected();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElement(By by) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElement(by), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElements(By by) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElements(by);
            }
            return Element.constructList(elements, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByXPath(String expr) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByXPath(expr), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByXPath(String expr) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByXPath(expr);
            }
            return Element.constructList(elements, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByTagName(String tagName) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByTagName(tagName), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByTagName(String tagName) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByTagName(tagName);
            }
            return Element.constructList(elements, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByCssSelector(String expr) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByCssSelector(expr), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByCssSelector(String expr) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByCssSelector(expr);
            }
            return Element.constructList(elements, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByName(String name) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByName(name), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByName(String name) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByName(name);
            }
            return Element.constructList(elements, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByLinkText(String text) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByLinkText(text), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByPartialLinkText(String text) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByPartialLinkText(text), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByLinkText(String text) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByLinkText(text);
            }
            return Element.constructList(elements, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByPartialLinkText(String text) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByPartialLinkText(text);
            }
            return Element.constructList(elements, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByClassName(String cssClass) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByClassName(cssClass), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByClassName(String cssClass) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByClassName(cssClass);
            }
            return Element.constructList(elements, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementById(String id) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementById(id), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsById(String id) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsById(id);
            }
            return Element.constructList(elements, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeAsyncScript(String script, Object ... args) {
        try {
            Object result;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                result = this.remote.executeAsyncScript(script, Element.scriptParams(args));
            }
            return Element.constructObject(result, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(String script, Object ... args) {
        try {
            Object result;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                result = this.remote.executeScript(script, Element.scriptParams(args));
            }
            return Element.constructObject(result, this.driver, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    static Object[] scriptParams(Object[] args) {
        if (args != null) {
            Object[] argsOut = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                while (arg instanceof WrapsElement) {
                    arg = ((WrapsElement)arg).getWrappedElement();
                }
                if (arg instanceof Element) {
                    ElementId id = new ElementId();
                    ((Element)arg).scriptParam(id);
                    argsOut[i] = id;
                    continue;
                }
                argsOut[i] = arg;
            }
            return argsOut;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coordinates getCoordinates() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return new Coordinates(this.remote, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        try {
            byte[] bytes = null;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                bytes = this.remote.getScreenshot();
            }
            if (bytes == null) {
                return null;
            }
            return (X)outputType.convertFromPngBytes(bytes);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        SocketLock socketLock = this.lock;
        synchronized (socketLock) {
            try {
                return this.remote.remoteHashCode();
            }
            catch (Throwable t) {
                Util.handleException(t);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            ElementId id = new ElementId();
            ((Element)obj).scriptParam(id);
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                try {
                    return this.remote.remoteEquals(id);
                }
                catch (Throwable t) {
                    Util.handleException(t);
                }
            }
        }
        return false;
    }
}

