/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;

class AjaxListener
implements Runnable {
    private static final long MAX_WAIT_DEFAULT = 15000L;
    private static final int IDLE_COUNT_TARGET = 3;
    private final Integer newStatusCode;
    private final AtomicInteger statusCode;
    private final Map<String, Long> resources;
    private final long timeoutMS;

    AjaxListener(int newStatusCode, AtomicInteger statusCode, Map<String, Long> resources, long timeoutMS) {
        this.newStatusCode = newStatusCode;
        this.statusCode = statusCode;
        this.resources = resources;
        this.timeoutMS = timeoutMS <= 0L ? 15000L : timeoutMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start;
        int size = 0;
        long time = start = System.currentTimeMillis();
        Settings settings = SettingsManager.settings();
        final AtomicBoolean done = new AtomicBoolean();
        Platform.runLater((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicBoolean atomicBoolean = done;
                synchronized (atomicBoolean) {
                    done.set(true);
                    done.notifyAll();
                }
            }
        });
        AtomicBoolean atomicBoolean = done;
        synchronized (atomicBoolean) {
            while (!done.get()) {
                try {
                    done.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (settings != null) {
            int idleCountTarget;
            long sleepMS = Math.max(settings.ajaxWait() / 3L, 0L);
            int idleCount = 0;
            int n = idleCountTarget = sleepMS == 0L ? 1 : 3;
            while (time - start < this.timeoutMS) {
                try {
                    Thread.sleep(sleepMS);
                }
                catch (InterruptedException e) {
                    return;
                }
                time = System.currentTimeMillis();
                AtomicInteger atomicInteger = this.statusCode;
                synchronized (atomicInteger) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    HashSet<String> remove = new HashSet<String>();
                    for (Map.Entry<String, Long> entry : this.resources.entrySet()) {
                        if (time - entry.getValue() <= settings.ajaxResourceTimeout()) continue;
                        remove.add(entry.getKey());
                    }
                    for (String key : remove) {
                        this.resources.remove(key);
                    }
                    size = this.resources.size();
                }
                idleCount = size == 0 ? ++idleCount : 0;
                if (idleCount != idleCountTarget) continue;
            }
        }
        AtomicInteger atomicInteger = this.statusCode;
        synchronized (atomicInteger) {
            if (Thread.interrupted()) {
                return;
            }
            if (this.newStatusCode == null) {
                this.resources.clear();
                this.statusCode.set(200);
                this.statusCode.notifyAll();
            } else {
                this.resources.clear();
                this.statusCode.set(this.newStatusCode);
                this.statusCode.notifyAll();
            }
        }
    }
}

