/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mabl.integration.jenkins.Converter;
import com.mabl.integration.jenkins.MablPlanExecutionFailure;
import com.mabl.integration.jenkins.MablRestApiClient;
import com.mabl.integration.jenkins.MablStepConstants;
import com.mabl.integration.jenkins.MablSystemException;
import com.mabl.integration.jenkins.domain.CreateDeploymentProperties;
import com.mabl.integration.jenkins.domain.CreateDeploymentResult;
import com.mabl.integration.jenkins.domain.ExecutionResult;
import com.mabl.integration.jenkins.test.output.Failure;
import com.mabl.integration.jenkins.test.output.Properties;
import com.mabl.integration.jenkins.test.output.Property;
import com.mabl.integration.jenkins.test.output.Skipped;
import com.mabl.integration.jenkins.test.output.TestCase;
import com.mabl.integration.jenkins.test.output.TestSuite;
import com.mabl.integration.jenkins.test.output.TestSuites;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import hudson.EnvVars;
import hudson.FilePath;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.kohsuke.stapler.DataBoundConstructor;

public class MablStepDeploymentRunner
implements Callable<Boolean> {
    private static final Set<String> COMPLETE_STATUSES = ImmutableSet.of((Object)"succeeded", (Object)"failed", (Object)"cancelled", (Object)"completed", (Object)"terminated");
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n";
    private final MablRestApiClient client;
    private final PrintStream outputStream;
    private final long pollingIntervalMilliseconds;
    private final String environmentId;
    private final String applicationId;
    private final String labels;
    private final String mablBranch;
    private final boolean continueOnPlanFailure;
    private final boolean continueOnMablError;
    private final boolean collectVars;
    private final FilePath buildPath;
    private final EnvVars environmentVars;

    @DataBoundConstructor
    public MablStepDeploymentRunner(MablRestApiClient client, PrintStream outputStream, long pollingIntervalMilliseconds, String environmentId, String applicationId, String labels, String mablBranch, boolean continueOnPlanFailure, boolean continueOnMablError, boolean collectVars, FilePath buildPath, EnvVars environmentVars) {
        this.outputStream = outputStream;
        this.client = client;
        this.pollingIntervalMilliseconds = pollingIntervalMilliseconds;
        this.environmentId = environmentId;
        this.applicationId = applicationId;
        this.labels = labels;
        this.mablBranch = mablBranch;
        this.continueOnPlanFailure = continueOnPlanFailure;
        this.continueOnMablError = continueOnMablError;
        this.collectVars = collectVars;
        this.buildPath = buildPath;
        this.environmentVars = environmentVars;
    }

    @Override
    public Boolean call() {
        try {
            this.outputStream.printf("%nmabl Jenkins plugin v%s running...%n", MablStepConstants.PLUGIN_VERSION);
            this.execute();
            Boolean bl = true;
            return bl;
        }
        catch (MablSystemException error) {
            this.printException(error);
            Boolean bl = this.continueOnMablError;
            return bl;
        }
        catch (MablPlanExecutionFailure failure) {
            this.printException(failure);
            Boolean bl = this.continueOnPlanFailure;
            return bl;
        }
        catch (Exception e) {
            this.outputStream.printf("Unexpected %s exception%n", "mabl-integration-plugin");
            e.printStackTrace();
            Boolean bl = this.continueOnMablError;
            return bl;
        }
        finally {
            this.outputStream.print("mabl test execution step complete.\n\n");
        }
    }

    private void execute() throws MablPlanExecutionFailure {
        this.outputStream.printf("mabl is creating a deployment event:%n  environment_id: [%s]%n  application_id: [%s]%n  labels: [%s]  branch: [%s]%n", this.environmentId == null ? "empty" : this.environmentId, this.applicationId == null ? "empty" : this.applicationId, this.labels == null ? "empty" : this.labels, this.mablBranch == null ? "master" : this.mablBranch);
        try {
            CreateDeploymentProperties properties = this.getDeploymentProperties();
            CreateDeploymentResult deployment = this.client.createDeploymentEvent(this.environmentId, this.applicationId, this.labels, this.mablBranch, properties);
            if (deployment == null) {
                throw new MablSystemException("Failed to create deployment event");
            }
            this.outputStream.printf("Deployment event was created in mabl at [%s/workspaces/%s/events/%s]%n", this.client.getAppBaseUrl(), deployment.workspaceId, deployment.id);
            try {
                ExecutionResult executionResult = null;
                do {
                    TimeUnit.MILLISECONDS.sleep(this.pollingIntervalMilliseconds);
                    executionResult = this.client.getExecutionResults(deployment.id);
                    if (executionResult == null) {
                        throw new MablSystemException("No deployment event found for id [%s] in mabl.", deployment.id);
                    }
                    this.printAllJourneyExecutionStatuses(executionResult);
                } while (!this.allPlansComplete(executionResult));
                this.printFinalStatuses(executionResult);
                if (!this.allPlansSuccess(executionResult)) {
                    throw new MablPlanExecutionFailure("One or more plans were unsuccessful running in mabl.");
                }
            }
            catch (InterruptedException e) {
                this.outputStream.println("[WARNING] Waiting for execution has been interrupted");
            }
        }
        catch (IOException e) {
            throw new MablSystemException("There was an API error trying to run tests in mabl.", e);
        }
        finally {
            if (this.client != null) {
                this.client.close();
            }
        }
    }

    private CreateDeploymentProperties getDeploymentProperties() {
        CreateDeploymentProperties properties = Converter.convert(new EnvVars(), this.outputStream);
        if (this.collectVars) {
            this.outputStream.println("Send build environment variables is set. Collecting the following information:");
            properties = Converter.convert(this.environmentVars, this.outputStream);
        } else {
            this.outputStream.println("Send build environment variables is unset. Not collecting any environment information:");
        }
        properties.setDeploymentOrigin(MablStepConstants.PLUGIN_USER_AGENT);
        return properties;
    }

    private boolean allPlansComplete(ExecutionResult result) {
        boolean isComplete = true;
        for (ExecutionResult.ExecutionSummary summary : result.executions) {
            isComplete &= COMPLETE_STATUSES.contains(summary.status.toLowerCase(Locale.US));
        }
        return isComplete;
    }

    private boolean allPlansSuccess(ExecutionResult result) {
        Boolean success = result.eventStatus.getSucceeded();
        return Boolean.TRUE.equals(success);
    }

    private void printFinalStatuses(ExecutionResult result) {
        ArrayList<TestSuite> suites = new ArrayList<TestSuite>();
        this.outputStream.println("The final plan states in mabl:");
        for (ExecutionResult.ExecutionSummary summary : result.executions) {
            String successState = summary.success ? "SUCCESSFUL" : "FAILED";
            this.outputStream.printf("  %sPlan [%s] is %s in state [%s]%n", summary.planExecution != null && summary.planExecution.isRetry ? "RETRY: " : "", MablStepDeploymentRunner.safePlanName(summary), successState, summary.status);
            suites.add(this.createTestSuite(summary));
        }
        this.outputTestSuiteXml(new TestSuites((ImmutableCollection<TestSuite>)ImmutableList.copyOf(suites)));
    }

    private void printAllJourneyExecutionStatuses(ExecutionResult result) {
        this.outputStream.println("Running mabl test(s) status update:");
        TreeMap<String, ExecutionResult.ExecutionSummary> summariesToPrint = new TreeMap<String, ExecutionResult.ExecutionSummary>();
        for (ExecutionResult.ExecutionSummary summary : result.executions) {
            ExecutionResult.ExecutionSummary existing = (ExecutionResult.ExecutionSummary)summariesToPrint.get(summary.plan.id);
            if (existing != null && existing.planExecution != null && existing.planExecution.isRetry) continue;
            summariesToPrint.put(summary.plan.id, summary);
        }
        for (ExecutionResult.ExecutionSummary summary : summariesToPrint.values()) {
            this.outputStream.printf("  %sPlan [%s] is [%s]%n", summary.planExecution != null && summary.planExecution.isRetry ? "RETRY: " : "", MablStepDeploymentRunner.safePlanName(summary), summary.status);
            for (ExecutionResult.JourneyExecutionResult journeyResult : summary.journeyExecutions) {
                this.outputStream.printf("    Test [%s] is %s%n", MablStepDeploymentRunner.safeJourneyName(summary, journeyResult.id), MablStepDeploymentRunner.executionResultToString(journeyResult));
            }
        }
    }

    static String executionResultToString(ExecutionResult.JourneyExecutionResult journeyResult) {
        String cleanStatus = journeyResult.status != null ? journeyResult.status : "waiting";
        String journeyFormat = String.format("[%s]", cleanStatus);
        if (cleanStatus.equalsIgnoreCase("failed")) {
            return String.format("%s at [%s]", journeyFormat, journeyResult.appHref);
        }
        return journeyFormat;
    }

    private void outputTestSuiteXml(TestSuites testSuites) {
        try {
            XStream xstream = new XStream();
            xstream.processAnnotations(Failure.class);
            xstream.processAnnotations(Properties.class);
            xstream.processAnnotations(Property.class);
            xstream.processAnnotations(Skipped.class);
            xstream.processAnnotations(TestCase.class);
            xstream.processAnnotations(TestSuite.class);
            xstream.processAnnotations(TestSuites.class);
            OutputStream outputStream = this.buildPath.write();
            outputStream.write(XML_DECLARATION.getBytes(StandardCharsets.UTF_8));
            xstream.toXML((Object)testSuites, outputStream);
        }
        catch (XStreamException e) {
            throw new MablSystemException("There was an error trying to output test results in mabl.", e);
        }
        catch (IOException e) {
            throw new MablSystemException("There was an error trying to write test results in mabl.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MablSystemException("There was an interruption trying to write test results in mabl.", e);
        }
    }

    TestSuite createTestSuite(ExecutionResult.ExecutionSummary summary) {
        Date startDate = new Date(summary.startTime);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timestamp = format.format(startDate);
        TestSuite testSuite = new TestSuite(MablStepDeploymentRunner.safePlanName(summary), MablStepDeploymentRunner.getDuration(summary), timestamp);
        HashMap<String, SortedSet> testCaseIDs = new HashMap<String, SortedSet>();
        block17: for (ExecutionResult.JourneyExecutionResult journeyExecutionResult : summary.journeyExecutions) {
            TestCase testCase = new TestCase(MablStepDeploymentRunner.safePlanName(summary), MablStepDeploymentRunner.safeJourneyName(summary, journeyExecutionResult.id), MablStepDeploymentRunner.getDuration(journeyExecutionResult), journeyExecutionResult.appHref);
            if (journeyExecutionResult.testCases != null && !journeyExecutionResult.testCases.isEmpty()) {
                switch (journeyExecutionResult.status) {
                    case "failed": 
                    case "completed": 
                    case "skipped": {
                        TreeSet<String> ids = new TreeSet<String>();
                        for (ExecutionResult.TestCaseID id : journeyExecutionResult.testCases) {
                            ids.add(id.caseID);
                        }
                        testCaseIDs.computeIfAbsent(journeyExecutionResult.status + "-test-cases", k -> new TreeSet()).addAll(ids);
                        testCase.setTestCaseIDs(ids);
                        break;
                    }
                }
            }
            testSuite.addToTestCases(testCase).incrementTests();
            if (journeyExecutionResult.success || null == journeyExecutionResult.status) continue;
            switch (journeyExecutionResult.status) {
                case "failed": 
                case "terminated": {
                    Failure failure = new Failure(journeyExecutionResult.status, journeyExecutionResult.statusCause);
                    testCase.setFailure(failure);
                    testSuite.incrementFailures();
                    continue block17;
                }
                case "skipped": {
                    testCase.setSkipped();
                    testSuite.incrementSkipped();
                    continue block17;
                }
            }
            this.outputStream.printf("WARNING: unexpected status '%s' found for test '%s' in plan '%s'%n", journeyExecutionResult.status, MablStepDeploymentRunner.safePlanName(summary), MablStepDeploymentRunner.safeJourneyName(summary, journeyExecutionResult.id));
        }
        if (!testCaseIDs.isEmpty()) {
            for (Map.Entry entry : testCaseIDs.entrySet()) {
                testSuite.addProperty((String)entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue()));
            }
        }
        return testSuite;
    }

    private static long getDuration(ExecutionResult.ExecutionSummary summary) {
        return summary.stopTime != null ? TimeUnit.SECONDS.convert(summary.stopTime - summary.startTime, TimeUnit.MILLISECONDS) : 0L;
    }

    private static long getDuration(ExecutionResult.JourneyExecutionResult summary) {
        return summary.stopTime != null ? TimeUnit.SECONDS.convert(summary.stopTime - summary.startTime, TimeUnit.MILLISECONDS) : 0L;
    }

    private void printException(Exception exception) {
        this.outputStream.print(exception.getMessage());
        if (exception.getCause() != null) {
            exception.getCause().printStackTrace(this.outputStream);
        }
    }

    private static String safePlanName(ExecutionResult.ExecutionSummary summary) {
        return summary.plan != null && summary.plan.name != null && !summary.plan.name.isEmpty() ? summary.plan.name : "<Unnamed Plan>";
    }

    private static String safeJourneyName(ExecutionResult.ExecutionSummary summary, String journeyId) {
        String journeyName = "<Unnamed Journey>";
        for (ExecutionResult.JourneySummary journeySummary : summary.journeys) {
            if (!journeySummary.id.equals(journeyId) || journeySummary.name.isEmpty()) continue;
            journeyName = journeySummary.name;
            break;
        }
        return journeyName;
    }
}

