/*
 * Decompiled with CFR 0.152.
 */
package com.mabeijianxi.smallvideorecord2;

import android.text.TextPaint;
import android.text.TextUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class StringUtils {
    public static final String EMPTY = "";
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd hh:mm:ss";
    private static final String DEFAULT_FILE_PATTERN = "yyyy-MM-dd-HH-mm-ss";
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    public static final SimpleDateFormat DATE_FORMAT_PART = new SimpleDateFormat("HH:mm");

    public static String currentTimeString() {
        return DATE_FORMAT_PART.format(Calendar.getInstance().getTime());
    }

    public static char chatAt(String pinyin, int index) {
        if (pinyin != null && pinyin.length() > 0) {
            return pinyin.charAt(index);
        }
        return ' ';
    }

    public static float GetTextWidth(String Sentence, float Size2) {
        if (StringUtils.isEmpty(Sentence)) {
            return 0.0f;
        }
        TextPaint FontPaint = new TextPaint();
        FontPaint.setTextSize(Size2);
        return FontPaint.measureText(Sentence.trim()) + (float)((int)((double)Size2 * 0.1));
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String formatDate(long date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date(date));
    }

    public static String formatDate(Date date) {
        return StringUtils.formatDate(date, DEFAULT_DATE_PATTERN);
    }

    public static String formatDate(long date) {
        return StringUtils.formatDate(new Date(date), DEFAULT_DATE_PATTERN);
    }

    public static String getDate() {
        return StringUtils.formatDate(new Date(), DEFAULT_DATE_PATTERN);
    }

    public static String createFileName() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_FILE_PATTERN);
        return format.format(date);
    }

    public static String getDateTime() {
        return StringUtils.formatDate(new Date(), DEFAULT_DATETIME_PATTERN);
    }

    public static String formatDateTime(Date date) {
        return StringUtils.formatDate(date, DEFAULT_DATETIME_PATTERN);
    }

    public static String formatDateTime(long date) {
        return StringUtils.formatDate(new Date(date), DEFAULT_DATETIME_PATTERN);
    }

    public static String formatGMTDate(String gmt) {
        TimeZone timeZoneLondon = TimeZone.getTimeZone(gmt);
        return StringUtils.formatDate(Calendar.getInstance(timeZoneLondon).getTimeInMillis());
    }

    public static String join(ArrayList<String> array, String separator) {
        StringBuffer result = new StringBuffer();
        if (array != null && array.size() > 0) {
            for (String str : array) {
                result.append(str);
                result.append(separator);
            }
            result.delete(result.length() - 1, result.length());
        }
        return result.toString();
    }

    public static String join(Iterator<String> iter, String separator) {
        StringBuffer result = new StringBuffer();
        if (iter != null) {
            while (iter.hasNext()) {
                String key = iter.next();
                result.append(key);
                result.append(separator);
            }
            if (result.length() > 0) {
                result.delete(result.length() - 1, result.length());
            }
        }
        return result.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0 || str.equalsIgnoreCase("null");
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String trim(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String generateTime(long time) {
        int totalSeconds = (int)(time / 1000L);
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        return hours > 0 ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
    }

    public static boolean isBlank(String s) {
        return TextUtils.isEmpty((CharSequence)s);
    }

    public static String gennerTime(int totalSeconds) {
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static String generateFileSize(long size) {
        String fileSize = (double)size < 1024.0 ? size + "B" : ((double)size < 1048576.0 ? String.format("%.1f", (double)size / 1024.0) + "KB" : ((double)size < 1.073741824E9 ? String.format("%.1f", (double)size / 1048576.0) + "MB" : String.format("%.1f", (double)size / 1.073741824E9) + "GB"));
        return fileSize;
    }

    public static String findString(String search, String start, String end) {
        int start_pos;
        int start_len = start.length();
        int n = start_pos = StringUtils.isEmpty(start) ? 0 : search.indexOf(start);
        if (start_pos > -1) {
            int end_pos;
            int n2 = end_pos = StringUtils.isEmpty(end) ? -1 : search.indexOf(end, start_pos + start_len);
            if (end_pos > -1) {
                return search.substring(start_pos + start.length(), end_pos);
            }
        }
        return EMPTY;
    }

    public static String substring(String search, String start, String end, String defaultValue) {
        int start_pos;
        int start_len = start.length();
        int n = start_pos = StringUtils.isEmpty(start) ? 0 : search.indexOf(start);
        if (start_pos > -1) {
            int end_pos;
            int n2 = end_pos = StringUtils.isEmpty(end) ? -1 : search.indexOf(end, start_pos + start_len);
            if (end_pos > -1) {
                return search.substring(start_pos + start.length(), end_pos);
            }
            return search.substring(start_pos + start.length());
        }
        return defaultValue;
    }

    public static String substring(String search, String start, String end) {
        return StringUtils.substring(search, start, end, EMPTY);
    }

    public static String concat(String ... strs) {
        StringBuffer result = new StringBuffer();
        if (strs != null) {
            for (String str : strs) {
                if (str == null) continue;
                result.append(str);
            }
        }
        return result.toString();
    }

    public static String makeSafe(String s) {
        return s == null ? EMPTY : s;
    }
}

