/*
 * Decompiled with CFR 0.152.
 */
package com.mabeijianxi.smallvideorecord2;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import com.mabeijianxi.smallvideorecord2.DeviceUtils;
import com.mabeijianxi.smallvideorecord2.R;
import com.mabeijianxi.smallvideorecord2.model.MediaObject;
import java.util.Iterator;

public class ProgressView
extends View {
    private Paint mProgressPaint;
    private Paint mActivePaint;
    private Paint mPausePaint;
    private Paint mRemovePaint;
    private Paint mThreePaint;
    private Paint mOverflowPaint;
    private boolean mStop;
    private boolean mProgressChanged;
    private boolean mActiveState;
    private MediaObject mMediaObject;
    private int mMaxDuration;
    private int mVLineWidth;
    private int mRecordTimeMin = 1500;
    private static final int HANDLER_INVALIDATE_ACTIVE = 0;
    private static final int HANDLER_INVALIDATE_RECORDING = 1;
    private Handler mHandler = new Handler(){

        public void dispatchMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    ProgressView.this.invalidate();
                    ProgressView.this.mActiveState = !ProgressView.this.mActiveState;
                    if (ProgressView.this.mStop) break;
                    this.sendEmptyMessageDelayed(0, 300L);
                    break;
                }
                case 1: {
                    ProgressView.this.invalidate();
                    if (!ProgressView.this.mProgressChanged) break;
                    this.sendEmptyMessageDelayed(0, 50L);
                }
            }
            super.dispatchMessage(msg);
        }
    };

    public ProgressView(Context paramContext) {
        super(paramContext);
        this.init();
    }

    public ProgressView(Context paramContext, AttributeSet paramAttributeSet) {
        super(paramContext, paramAttributeSet);
        this.init();
    }

    public ProgressView(Context paramContext, AttributeSet paramAttributeSet, int paramInt) {
        super(paramContext, paramAttributeSet, paramInt);
        this.init();
    }

    private void init() {
        this.mProgressPaint = new Paint();
        this.mActivePaint = new Paint();
        this.mPausePaint = new Paint();
        this.mRemovePaint = new Paint();
        this.mThreePaint = new Paint();
        this.mOverflowPaint = new Paint();
        this.mVLineWidth = DeviceUtils.dipToPX(this.getContext(), 1.0f);
        this.setBackgroundColor(this.getResources().getColor(R.color.camera_bg));
        this.mProgressPaint.setColor(-12206054);
        this.mProgressPaint.setStyle(Paint.Style.FILL);
        this.mActivePaint.setColor(this.getResources().getColor(17170443));
        this.mActivePaint.setStyle(Paint.Style.FILL);
        this.mPausePaint.setColor(this.getResources().getColor(R.color.camera_progress_split));
        this.mPausePaint.setStyle(Paint.Style.FILL);
        this.mRemovePaint.setColor(this.getResources().getColor(R.color.camera_progress_delete));
        this.mRemovePaint.setStyle(Paint.Style.FILL);
        this.mThreePaint.setColor(this.getResources().getColor(R.color.camera_progress_three));
        this.mThreePaint.setStyle(Paint.Style.FILL);
        this.mOverflowPaint.setColor(this.getResources().getColor(R.color.camera_progress_overflow));
        this.mOverflowPaint.setStyle(Paint.Style.FILL);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int left = 0;
        int right = 0;
        int duration = 0;
        if (this.mMediaObject != null && this.mMediaObject.getMedaParts() != null) {
            right = 0;
            left = 0;
            Iterator iterator = this.mMediaObject.getMedaParts().iterator();
            boolean hasNext = iterator.hasNext();
            int maxDuration = this.mMaxDuration;
            boolean hasOutDuration = false;
            int currentDuration = this.mMediaObject.getDuration();
            boolean bl = hasOutDuration = currentDuration > this.mMaxDuration;
            if (hasOutDuration) {
                maxDuration = currentDuration;
            }
            while (hasNext) {
                MediaObject.MediaPart vp = (MediaObject.MediaPart)iterator.next();
                int partDuration = vp.getDuration();
                left = right;
                right = left + (int)((float)partDuration * 1.0f / (float)maxDuration * (float)width);
                if (vp.remove) {
                    canvas.drawRect((float)left, 0.0f, (float)right, (float)height, this.mRemovePaint);
                } else if (hasOutDuration) {
                    right = left + (int)((float)(this.mMaxDuration - duration) * 1.0f / (float)maxDuration * (float)width);
                    canvas.drawRect((float)left, 0.0f, (float)right, (float)height, this.mProgressPaint);
                    left = right;
                    right = left + (int)((float)(partDuration - (this.mMaxDuration - duration)) * 1.0f / (float)maxDuration * (float)width);
                    canvas.drawRect((float)left, 0.0f, (float)right, (float)height, this.mOverflowPaint);
                } else {
                    canvas.drawRect((float)left, 0.0f, (float)right, (float)height, this.mProgressPaint);
                }
                hasNext = iterator.hasNext();
                if (hasNext) {
                    canvas.drawRect((float)(right - this.mVLineWidth), 0.0f, (float)right, (float)height, this.mPausePaint);
                }
                duration += partDuration;
            }
        }
        if (duration < this.mRecordTimeMin) {
            left = (int)((float)this.mRecordTimeMin * 1.0f / (float)this.mMaxDuration * (float)width);
            canvas.drawRect((float)left, 0.0f, (float)(left + this.mVLineWidth), (float)height, this.mThreePaint);
        }
        if (this.mActiveState) {
            if (right + 8 >= width) {
                right = width - 8;
            }
            canvas.drawRect((float)right, 0.0f, (float)(right + 8), (float)this.getMeasuredHeight(), this.mActivePaint);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mStop = false;
        this.mHandler.sendEmptyMessage(0);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mStop = true;
        this.mHandler.removeMessages(0);
    }

    public void setData(MediaObject mMediaObject) {
        this.mMediaObject = mMediaObject;
    }

    public void setMaxDuration(int duration) {
        this.mMaxDuration = duration;
    }

    public void start() {
        this.mProgressChanged = true;
    }

    public void stop() {
        this.mProgressChanged = false;
    }

    public void setMinTime(int recordTimeMin) {
        this.mRecordTimeMin = recordTimeMin;
    }
}

