/*
 * Decompiled with CFR 0.152.
 */
package com.mabeijianxi.smallvideorecord2;

import android.media.AudioRecord;
import com.mabeijianxi.smallvideorecord2.IMediaRecorder;

public class AudioRecorder
extends Thread {
    private AudioRecord mAudioRecord = null;
    private int mSampleRate = 44100;
    private IMediaRecorder mMediaRecorder;

    public AudioRecorder(IMediaRecorder mediaRecorder) {
        this.mMediaRecorder = mediaRecorder;
    }

    public void setSampleRate(int sampleRate) {
        this.mSampleRate = sampleRate;
    }

    @Override
    public void run() {
        if (this.mSampleRate != 8000 && this.mSampleRate != 16000 && this.mSampleRate != 22050 && this.mSampleRate != 44100) {
            this.mMediaRecorder.onAudioError(1, "sampleRate not support.");
            return;
        }
        int mMinBufferSize = AudioRecord.getMinBufferSize((int)this.mSampleRate, (int)16, (int)2);
        if (-2 == mMinBufferSize) {
            this.mMediaRecorder.onAudioError(2, "parameters are not supported by the hardware.");
            return;
        }
        this.mAudioRecord = new AudioRecord(1, this.mSampleRate, 16, 2, mMinBufferSize);
        if (null == this.mAudioRecord) {
            this.mMediaRecorder.onAudioError(3, "new AudioRecord failed.");
            return;
        }
        try {
            this.mAudioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            this.mMediaRecorder.onAudioError(0, "startRecording failed.");
            return;
        }
        byte[] sampleBuffer = new byte[mMinBufferSize];
        try {
            while (!Thread.currentThread().isInterrupted()) {
                int result = this.mAudioRecord.read(sampleBuffer, 0, mMinBufferSize);
                if (result <= 0) continue;
                this.mMediaRecorder.receiveAudioData(sampleBuffer, result);
            }
        }
        catch (Exception e) {
            String message = "";
            if (e != null) {
                message = e.getMessage();
            }
            this.mMediaRecorder.onAudioError(0, message);
        }
        this.mAudioRecord.release();
        this.mAudioRecord = null;
    }
}

