/*
 * Decompiled with CFR 0.152.
 */
package com.mabeijianxi.smallvideorecord2;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;
import com.mabeijianxi.smallvideorecord2.FileUtils;
import com.mabeijianxi.smallvideorecord2.JianXiCamera;
import com.mabeijianxi.smallvideorecord2.MediaRecorderBase;
import com.mabeijianxi.smallvideorecord2.model.LocalMediaConfig;
import com.mabeijianxi.smallvideorecord2.model.MediaObject;
import com.mabeijianxi.smallvideorecord2.model.OnlyCompressOverBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class LocalMediaCompress
extends MediaRecorderBase {
    private final String mNeedCompressVideo;
    private final OnlyCompressOverBean mOnlyCompressOverBean;

    @Override
    public MediaObject.MediaPart startRecord() {
        return null;
    }

    public LocalMediaCompress(LocalMediaConfig localMediaConfig) {
        this.compressConfig = localMediaConfig.getCompressConfig();
        CAPTURE_THUMBNAILS_TIME = localMediaConfig.getCaptureThumbnailsTime();
        if (localMediaConfig.getFrameRate() > 0) {
            this.setTranscodingFrameRate(localMediaConfig.getFrameRate());
        }
        this.mNeedCompressVideo = localMediaConfig.getVideoPath();
        this.mOnlyCompressOverBean = new OnlyCompressOverBean();
        this.mOnlyCompressOverBean.setVideoPath(this.mNeedCompressVideo);
    }

    private void correcAttribute(String videoPath, String picPath) {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(videoPath);
        String s = mediaMetadataRetriever.extractMetadata(24);
        String videoW = mediaMetadataRetriever.extractMetadata(18);
        String videoH = mediaMetadataRetriever.extractMetadata(19);
        if (s.equals("90") || s.equals("270")) {
            SMALL_VIDEO_HEIGHT = Integer.valueOf(videoW);
            SMALL_VIDEO_WIDTH = Integer.valueOf(videoH);
            String newPicPath = this.checkPicRotaing(Integer.valueOf(s), picPath);
            if (!TextUtils.isEmpty((CharSequence)newPicPath)) {
                this.mOnlyCompressOverBean.setPicPath(newPicPath);
            }
        } else if (s.equals("0") || s.equals("180") || s.equals("360")) {
            SMALL_VIDEO_WIDTH = Integer.valueOf(videoW);
            SMALL_VIDEO_HEIGHT = Integer.valueOf(videoH);
        }
    }

    private String checkPicRotaing(int angle, String picPath) {
        Bitmap bitmap = this.rotaingImageView(angle, BitmapFactory.decodeFile((String)picPath));
        return this.savePhoto(bitmap);
    }

    private Bitmap rotaingImageView(int angle, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String savePhoto(Bitmap bitmap) {
        FileOutputStream fileOutputStream = null;
        String fileName = UUID.randomUUID().toString() + ".jpg";
        File f = new File(this.mMediaObject.getOutputDirectory(), fileName);
        try {
            fileOutputStream = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return f.toString();
    }

    public OnlyCompressOverBean startCompress() {
        if (TextUtils.isEmpty((CharSequence)this.mNeedCompressVideo)) {
            return this.mOnlyCompressOverBean;
        }
        File f = new File(JianXiCamera.getVideoCachePath());
        if (!FileUtils.checkFile(f)) {
            f.mkdirs();
        }
        String key = String.valueOf(System.currentTimeMillis());
        this.mMediaObject = this.setOutputDirectory(key, JianXiCamera.getVideoCachePath() + key);
        this.mMediaObject.setOutputTempVideoPath(this.mNeedCompressVideo);
        boolean b = this.doCompress(true);
        this.mOnlyCompressOverBean.setSucceed(b);
        if (b) {
            this.mOnlyCompressOverBean.setVideoPath(this.mMediaObject.getOutputTempTranscodingVideoPath());
            this.mOnlyCompressOverBean.setPicPath(this.mMediaObject.getOutputVideoThumbPath());
            this.correcAttribute(this.mMediaObject.getOutputTempTranscodingVideoPath(), this.mMediaObject.getOutputVideoThumbPath());
        }
        return this.mOnlyCompressOverBean;
    }
}

