/*
 * Decompiled with CFR 0.152.
 */
package com.mabeijianxi.smallvideorecord2.model;

import android.os.Parcel;
import android.os.Parcelable;

public final class MediaRecorderConfig
implements Parcelable {
    private final int RECORD_TIME_MAX;
    private final int SMALL_VIDEO_HEIGHT;
    private final int SMALL_VIDEO_WIDTH;
    private final int MAX_FRAME_RATE;
    private final int MIN_FRAME_RATE;
    private final int VIDEO_BITRATE;
    private final int captureThumbnailsTime;
    private final boolean GO_HOME;
    public static final Parcelable.Creator<MediaRecorderConfig> CREATOR = new Parcelable.Creator<MediaRecorderConfig>(){

        public MediaRecorderConfig createFromParcel(Parcel in) {
            return new MediaRecorderConfig(in);
        }

        public MediaRecorderConfig[] newArray(int size) {
            return new MediaRecorderConfig[size];
        }
    };

    private MediaRecorderConfig(Buidler buidler) {
        this.RECORD_TIME_MAX = buidler.RECORD_TIME_MAX;
        this.MAX_FRAME_RATE = buidler.MAX_FRAME_RATE;
        this.captureThumbnailsTime = buidler.captureThumbnailsTime;
        this.MIN_FRAME_RATE = buidler.MIN_FRAME_RATE;
        this.SMALL_VIDEO_HEIGHT = buidler.SMALL_VIDEO_HEIGHT;
        this.SMALL_VIDEO_WIDTH = buidler.SMALL_VIDEO_WIDTH;
        this.VIDEO_BITRATE = buidler.VIDEO_BITRATE;
        this.GO_HOME = buidler.GO_HOME;
    }

    protected MediaRecorderConfig(Parcel in) {
        this.RECORD_TIME_MAX = in.readInt();
        this.SMALL_VIDEO_HEIGHT = in.readInt();
        this.SMALL_VIDEO_WIDTH = in.readInt();
        this.MAX_FRAME_RATE = in.readInt();
        this.MIN_FRAME_RATE = in.readInt();
        this.VIDEO_BITRATE = in.readInt();
        this.captureThumbnailsTime = in.readInt();
        this.GO_HOME = in.readByte() != 0;
    }

    public boolean isGO_HOME() {
        return this.GO_HOME;
    }

    public int getCaptureThumbnailsTime() {
        return this.captureThumbnailsTime;
    }

    public int getMaxFrameRate() {
        return this.MAX_FRAME_RATE;
    }

    public int getMinFrameRate() {
        return this.MIN_FRAME_RATE;
    }

    public int getRecordTimeMax() {
        return this.RECORD_TIME_MAX;
    }

    public int getSmallVideoHeight() {
        return this.SMALL_VIDEO_HEIGHT;
    }

    public int getSmallVideoWidth() {
        return this.SMALL_VIDEO_WIDTH;
    }

    public int getVideoBitrate() {
        return this.VIDEO_BITRATE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.RECORD_TIME_MAX);
        dest.writeInt(this.SMALL_VIDEO_HEIGHT);
        dest.writeInt(this.SMALL_VIDEO_WIDTH);
        dest.writeInt(this.MAX_FRAME_RATE);
        dest.writeInt(this.MIN_FRAME_RATE);
        dest.writeInt(this.VIDEO_BITRATE);
        dest.writeInt(this.captureThumbnailsTime);
        dest.writeByte((byte)(this.GO_HOME ? 1 : 0));
    }

    public static class Buidler {
        private int RECORD_TIME_MAX = 6000;
        private int SMALL_VIDEO_HEIGHT = 480;
        private int SMALL_VIDEO_WIDTH = 360;
        private int MAX_FRAME_RATE = 20;
        private int MIN_FRAME_RATE = 8;
        private int VIDEO_BITRATE;
        private int captureThumbnailsTime = 1;
        private boolean GO_HOME = false;

        public MediaRecorderConfig build() {
            return new MediaRecorderConfig(this);
        }

        public Buidler captureThumbnailsTime(int captureThumbnailsTime) {
            this.captureThumbnailsTime = captureThumbnailsTime;
            return this;
        }

        public Buidler maxFrameRate(int MAX_FRAME_RATE) {
            this.MAX_FRAME_RATE = MAX_FRAME_RATE;
            return this;
        }

        public Buidler minFrameRate(int MIN_FRAME_RATE) {
            this.MIN_FRAME_RATE = MIN_FRAME_RATE;
            return this;
        }

        public Buidler recordTimeMax(int RECORD_TIME_MAX) {
            this.RECORD_TIME_MAX = RECORD_TIME_MAX;
            return this;
        }

        public Buidler smallVideoHeight(int SMALL_VIDEO_HEIGHT) {
            this.SMALL_VIDEO_HEIGHT = SMALL_VIDEO_HEIGHT;
            return this;
        }

        public Buidler smallVideoWidth(int SMALL_VIDEO_WIDTH) {
            this.SMALL_VIDEO_WIDTH = SMALL_VIDEO_WIDTH;
            return this;
        }

        public Buidler videoBitrate(int VIDEO_BITRATE) {
            this.VIDEO_BITRATE = VIDEO_BITRATE;
            return this;
        }

        public Buidler goHome(boolean GO_HOME) {
            this.GO_HOME = GO_HOME;
            return this;
        }
    }
}

