/*
 * Decompiled with CFR 0.152.
 */
package com.mabeijianxi.smallvideorecord2.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.mabeijianxi.smallvideorecord2.model.BaseMediaBitrateConfig;

public final class LocalMediaConfig
implements Parcelable {
    private final int FRAME_RATE;
    private final int captureThumbnailsTime;
    private final boolean GO_HOME;
    private final BaseMediaBitrateConfig compressConfig;
    private final String videoAddress;
    public static final Parcelable.Creator<LocalMediaConfig> CREATOR = new Parcelable.Creator<LocalMediaConfig>(){

        public LocalMediaConfig createFromParcel(Parcel in) {
            return new LocalMediaConfig(in);
        }

        public LocalMediaConfig[] newArray(int size) {
            return new LocalMediaConfig[size];
        }
    };

    private LocalMediaConfig(Buidler buidler) {
        this.captureThumbnailsTime = buidler.captureThumbnailsTime;
        this.FRAME_RATE = buidler.FRAME_RATE;
        this.compressConfig = buidler.compressConfig;
        this.videoAddress = buidler.videoPath;
        this.GO_HOME = buidler.GO_HOME;
    }

    protected LocalMediaConfig(Parcel in) {
        this.FRAME_RATE = in.readInt();
        this.captureThumbnailsTime = in.readInt();
        this.GO_HOME = in.readByte() != 0;
        this.compressConfig = (BaseMediaBitrateConfig)in.readParcelable(BaseMediaBitrateConfig.class.getClassLoader());
        this.videoAddress = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.FRAME_RATE);
        dest.writeInt(this.captureThumbnailsTime);
        dest.writeByte((byte)(this.GO_HOME ? 1 : 0));
        dest.writeParcelable((Parcelable)this.compressConfig, flags);
        dest.writeString(this.videoAddress);
    }

    public int describeContents() {
        return 0;
    }

    public boolean isGO_HOME() {
        return this.GO_HOME;
    }

    public int getCaptureThumbnailsTime() {
        return this.captureThumbnailsTime;
    }

    public int getFrameRate() {
        return this.FRAME_RATE;
    }

    public BaseMediaBitrateConfig getCompressConfig() {
        return this.compressConfig;
    }

    public String getVideoPath() {
        return this.videoAddress;
    }

    public static class Buidler {
        private int captureThumbnailsTime = 1;
        private boolean GO_HOME = false;
        private BaseMediaBitrateConfig compressConfig;
        private int FRAME_RATE;
        private String videoPath;

        public LocalMediaConfig build() {
            return new LocalMediaConfig(this);
        }

        public Buidler captureThumbnailsTime(int captureThumbnailsTime) {
            this.captureThumbnailsTime = captureThumbnailsTime;
            return this;
        }

        public Buidler doH264Compress(BaseMediaBitrateConfig compressConfig) {
            this.compressConfig = compressConfig;
            return this;
        }

        public Buidler goHome(boolean GO_HOME) {
            this.GO_HOME = GO_HOME;
            return this;
        }

        public Buidler setFramerate(int MAX_FRAME_RATE) {
            this.FRAME_RATE = MAX_FRAME_RATE;
            return this;
        }

        public Buidler setVideoPath(String videoPath) {
            this.videoPath = videoPath;
            return this;
        }
    }
}

