/*
 * Decompiled with CFR 0.152.
 */
package com.mabeijianxi.smallvideorecord2;

import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.mabeijianxi.smallvideorecord2.AudioRecorder;
import com.mabeijianxi.smallvideorecord2.FFMpegUtils;
import com.mabeijianxi.smallvideorecord2.MediaRecorderBase;
import com.mabeijianxi.smallvideorecord2.jniinterface.FFmpegBridge;
import com.mabeijianxi.smallvideorecord2.model.MediaObject;

public class MediaRecorderNative
extends MediaRecorderBase
implements MediaRecorder.OnErrorListener,
FFmpegBridge.FFmpegStateListener {
    private static final String VIDEO_SUFFIX = ".ts";

    public MediaRecorderNative() {
        FFmpegBridge.registFFmpegStateListener(this);
    }

    @Override
    public MediaObject.MediaPart startRecord() {
        int vCustomFormat = this.mCameraId == 0 ? 1 : 3;
        FFmpegBridge.prepareJXFFmpegEncoder(this.mMediaObject.getOutputDirectory(), this.mMediaObject.getBaseName(), vCustomFormat, mSupportedPreviewWidth, SMALL_VIDEO_HEIGHT, SMALL_VIDEO_WIDTH, SMALL_VIDEO_HEIGHT, this.mFrameRate, mVideoBitrate);
        MediaObject.MediaPart result = null;
        if (this.mMediaObject != null) {
            result = this.mMediaObject.buildMediaPart(this.mCameraId, VIDEO_SUFFIX);
            String cmd = String.format("filename = \"%s\"; ", result.mediaPath);
            if (this.mAudioRecorder == null && result != null) {
                this.mAudioRecorder = new AudioRecorder(this);
                this.mAudioRecorder.start();
            }
            this.mRecording = true;
        }
        return result;
    }

    @Override
    public void stopRecord() {
        super.stopRecord();
        if (this.mOnEncodeListener != null) {
            this.mOnEncodeListener.onEncodeStart();
        }
        FFmpegBridge.recordEnd();
    }

    @Override
    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.mRecording) {
            FFmpegBridge.encodeFrame2H264(data);
            ++this.mPreviewFrameCallCount;
        }
        super.onPreviewFrame(data, camera);
    }

    @Override
    protected void onStartPreviewSuccess() {
    }

    public void onError(MediaRecorder mr, int what, int extra) {
        try {
            if (mr != null) {
                mr.reset();
            }
        }
        catch (IllegalStateException e) {
            Log.w((String)"jianxi", (String)"stopRecord", (Throwable)e);
        }
        catch (Exception e) {
            Log.w((String)"jianxi", (String)"stopRecord", (Throwable)e);
        }
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onVideoError(what, extra);
        }
    }

    @Override
    public void receiveAudioData(byte[] sampleBuffer, int len) {
        if (this.mRecording && len > 0) {
            FFmpegBridge.encodeFrame2AAC(sampleBuffer);
        }
    }

    @Override
    public void allRecordEnd() {
        final boolean captureFlag = FFMpegUtils.captureThumbnails(this.mMediaObject.getOutputTempTranscodingVideoPath(), this.mMediaObject.getOutputVideoThumbPath(), String.valueOf(CAPTURE_THUMBNAILS_TIME));
        if (this.mOnEncodeListener != null) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (captureFlag) {
                        MediaRecorderNative.this.mOnEncodeListener.onEncodeComplete();
                    } else {
                        MediaRecorderNative.this.mOnEncodeListener.onEncodeError();
                    }
                }
            }, 0L);
        }
    }

    public void activityStop() {
        FFmpegBridge.unRegistFFmpegStateListener(this);
    }
}

