/*
 * Decompiled with CFR 0.152.
 */
package com.mabeijianxi.smallvideorecord2;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.hardware.Camera;
import android.os.Build;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.Log;
import android.view.SurfaceHolder;
import com.mabeijianxi.smallvideorecord2.AudioRecorder;
import com.mabeijianxi.smallvideorecord2.DeviceUtils;
import com.mabeijianxi.smallvideorecord2.FFMpegUtils;
import com.mabeijianxi.smallvideorecord2.FileUtils;
import com.mabeijianxi.smallvideorecord2.IMediaRecorder;
import com.mabeijianxi.smallvideorecord2.StringUtils;
import com.mabeijianxi.smallvideorecord2.jniinterface.FFmpegBridge;
import com.mabeijianxi.smallvideorecord2.model.BaseMediaBitrateConfig;
import com.mabeijianxi.smallvideorecord2.model.MediaObject;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public abstract class MediaRecorderBase
implements SurfaceHolder.Callback,
Camera.PreviewCallback,
IMediaRecorder {
    public static int SMALL_VIDEO_HEIGHT = 480;
    public static int SMALL_VIDEO_WIDTH = 360;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_CAMERA_SET_PREVIEW_DISPLAY = 101;
    public static final int MEDIA_ERROR_CAMERA_PREVIEW = 102;
    public static final int MEDIA_ERROR_CAMERA_AUTO_FOCUS = 103;
    public static final int AUDIO_RECORD_ERROR_UNKNOWN = 0;
    public static final int AUDIO_RECORD_ERROR_SAMPLERATE_NOT_SUPPORT = 1;
    public static final int AUDIO_RECORD_ERROR_GET_MIN_BUFFER_SIZE_NOT_SUPPORT = 2;
    public static final int AUDIO_RECORD_ERROR_CREATE_FAILED = 3;
    public static final int VIDEO_BITRATE_NORMAL = 1024;
    public static final int VIDEO_BITRATE_MEDIUM = 1536;
    public static final int VIDEO_BITRATE_HIGH = 2048;
    protected static final int MESSAGE_ENCODE_START = 0;
    protected static final int MESSAGE_ENCODE_PROGRESS = 1;
    protected static final int MESSAGE_ENCODE_COMPLETE = 2;
    protected static final int MESSAGE_ENCODE_ERROR = 3;
    protected static int MAX_FRAME_RATE = 20;
    protected static int MIN_FRAME_RATE = 8;
    protected static int CAPTURE_THUMBNAILS_TIME = 1;
    protected BaseMediaBitrateConfig compressConfig;
    protected Camera camera;
    protected Camera.Parameters mParameters = null;
    protected List<Camera.Size> mSupportedPreviewSizes;
    protected SurfaceHolder mSurfaceHolder;
    protected AudioRecorder mAudioRecorder;
    protected MediaObject mMediaObject;
    protected OnEncodeListener mOnEncodeListener;
    protected OnErrorListener mOnErrorListener;
    protected OnPreparedListener mOnPreparedListener;
    protected int mFrameRate = MAX_FRAME_RATE;
    protected int mCameraId = 0;
    protected static int mVideoBitrate;
    public static int mSupportedPreviewWidth;
    protected boolean mPrepared;
    protected boolean mStartPreview;
    protected boolean mSurfaceCreated;
    protected volatile boolean mRecording;
    protected volatile long mPreviewFrameCallCount = 0L;
    private String mFrameRateCmd = "";

    public void setSurfaceHolder(SurfaceHolder sh) {
        if (sh != null) {
            sh.addCallback((SurfaceHolder.Callback)this);
            if (!DeviceUtils.hasHoneycomb()) {
                sh.setType(3);
            }
        }
    }

    public void setOnEncodeListener(OnEncodeListener l) {
        this.mOnEncodeListener = l;
    }

    public void setOnPreparedListener(OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnErrorListener(OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public boolean isFrontCamera() {
        return this.mCameraId == 1;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=9)
    public static boolean isSupportFrontCamera() {
        if (!DeviceUtils.hasGingerbread()) {
            return false;
        }
        int numberOfCameras = Camera.getNumberOfCameras();
        return 2 == numberOfCameras;
    }

    public void switchCamera(int cameraFacingFront) {
        switch (cameraFacingFront) {
            case 0: 
            case 1: {
                this.mCameraId = cameraFacingFront;
                this.stopPreview();
                this.startPreview();
            }
        }
    }

    public void switchCamera() {
        if (this.mCameraId == 0) {
            this.switchCamera(1);
        } else {
            this.switchCamera(0);
        }
    }

    public boolean autoFocus(Camera.AutoFocusCallback cb) {
        block5: {
            if (this.camera != null) {
                try {
                    String mode;
                    this.camera.cancelAutoFocus();
                    if (this.mParameters != null && StringUtils.isNotEmpty(mode = this.getAutoFocusMode())) {
                        this.mParameters.setFocusMode(mode);
                        this.camera.setParameters(this.mParameters);
                    }
                    this.camera.autoFocus(cb);
                    return true;
                }
                catch (Exception e) {
                    if (this.mOnErrorListener != null) {
                        this.mOnErrorListener.onVideoError(103, 0);
                    }
                    if (e == null) break block5;
                    Log.e((String)"jianxi", (String)"autoFocus", (Throwable)e);
                }
            }
        }
        return false;
    }

    private String getAutoFocusMode() {
        if (this.mParameters != null) {
            List focusModes = this.mParameters.getSupportedFocusModes();
            if ((Build.MODEL.startsWith("GT-I950") || Build.MODEL.endsWith("SCH-I959") || Build.MODEL.endsWith("MEIZU MX3")) && this.isSupported(focusModes, "continuous-picture")) {
                return "continuous-picture";
            }
            if (this.isSupported(focusModes, "continuous-video")) {
                return "continuous-video";
            }
            if (this.isSupported(focusModes, "auto")) {
                return "auto";
            }
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=14)
    public boolean manualFocus(Camera.AutoFocusCallback cb, List<Camera.Area> focusAreas) {
        block6: {
            if (this.camera != null && focusAreas != null && this.mParameters != null && DeviceUtils.hasICS()) {
                try {
                    this.camera.cancelAutoFocus();
                    if (this.mParameters.getMaxNumFocusAreas() > 0) {
                        this.mParameters.setFocusAreas(focusAreas);
                    }
                    if (this.mParameters.getMaxNumMeteringAreas() > 0) {
                        this.mParameters.setMeteringAreas(focusAreas);
                    }
                    this.mParameters.setFocusMode("macro");
                    this.camera.setParameters(this.mParameters);
                    this.camera.autoFocus(cb);
                    return true;
                }
                catch (Exception e) {
                    if (this.mOnErrorListener != null) {
                        this.mOnErrorListener.onVideoError(103, 0);
                    }
                    if (e == null) break block6;
                    Log.e((String)"jianxi", (String)"autoFocus", (Throwable)e);
                }
            }
        }
        return false;
    }

    public boolean toggleFlashMode() {
        if (this.mParameters != null) {
            try {
                String mode = this.mParameters.getFlashMode();
                if (TextUtils.isEmpty((CharSequence)mode) || "off".equals(mode)) {
                    this.setFlashMode("torch");
                } else {
                    this.setFlashMode("off");
                }
                return true;
            }
            catch (Exception e) {
                Log.e((String)"jianxi", (String)"toggleFlashMode", (Throwable)e);
            }
        }
        return false;
    }

    private boolean setFlashMode(String value) {
        if (this.mParameters != null && this.camera != null) {
            try {
                if ("torch".equals(value) || "off".equals(value)) {
                    this.mParameters.setFlashMode(value);
                    this.camera.setParameters(this.mParameters);
                }
                return true;
            }
            catch (Exception e) {
                Log.e((String)"jianxi", (String)"setFlashMode", (Throwable)e);
            }
        }
        return false;
    }

    public void setVideoBitRate(int bitRate) {
        if (bitRate > 0) {
            mVideoBitrate = bitRate;
        }
    }

    public void prepare() {
        this.mPrepared = true;
        if (this.mSurfaceCreated) {
            this.startPreview();
        }
    }

    public MediaObject setOutputDirectory(String key, String path) {
        File f;
        if (StringUtils.isNotEmpty(path) && (f = new File(path)) != null) {
            if (f.exists()) {
                if (f.isDirectory()) {
                    FileUtils.deleteDir(f);
                } else {
                    FileUtils.deleteFile(f);
                }
            }
            if (f.mkdirs()) {
                this.mMediaObject = new MediaObject(key, path, mVideoBitrate);
            }
        }
        return this.mMediaObject;
    }

    public void setMediaObject(MediaObject mediaObject) {
        this.mMediaObject = mediaObject;
    }

    @Override
    public void stopRecord() {
        MediaObject.MediaPart part;
        this.mRecording = false;
        if (this.mMediaObject != null && (part = this.mMediaObject.getCurrentPart()) != null && part.recording) {
            part.recording = false;
            part.endTime = System.currentTimeMillis();
            part.duration = (int)(part.endTime - part.startTime);
            part.cutStartTime = 0;
            part.cutEndTime = part.duration;
        }
    }

    private void stopAllRecord() {
        this.mRecording = false;
        if (this.mMediaObject != null && this.mMediaObject.getMedaParts() != null) {
            for (MediaObject.MediaPart part : this.mMediaObject.getMedaParts()) {
                if (part == null || !part.recording) continue;
                part.recording = false;
                part.endTime = System.currentTimeMillis();
                part.duration = (int)(part.endTime - part.startTime);
                part.cutStartTime = 0;
                part.cutEndTime = part.duration;
                File videoFile = new File(part.mediaPath);
                if (videoFile == null || videoFile.length() >= 1L) continue;
                this.mMediaObject.removePart(part, true);
            }
        }
    }

    private boolean isSupported(List<String> list, String key) {
        return list != null && list.contains(key);
    }

    protected void prepareCameraParaments() {
        int i;
        if (this.mParameters == null) {
            return;
        }
        List rates = this.mParameters.getSupportedPreviewFrameRates();
        if (rates != null) {
            if (rates.contains(MAX_FRAME_RATE)) {
                this.mFrameRate = MAX_FRAME_RATE;
            } else {
                boolean findFrame = false;
                Collections.sort(rates);
                for (i = rates.size() - 1; i >= 0; --i) {
                    if ((Integer)rates.get(i) > MAX_FRAME_RATE) continue;
                    this.mFrameRate = (Integer)rates.get(i);
                    findFrame = true;
                    break;
                }
                if (!findFrame) {
                    this.mFrameRate = (Integer)rates.get(0);
                }
            }
        }
        this.mParameters.setPreviewFrameRate(this.mFrameRate);
        boolean findWidth = false;
        for (i = this.mSupportedPreviewSizes.size() - 1; i >= 0; --i) {
            Camera.Size size = this.mSupportedPreviewSizes.get(i);
            if (size.height != SMALL_VIDEO_HEIGHT) continue;
            mSupportedPreviewWidth = size.width;
            findWidth = true;
            break;
        }
        if (!findWidth) {
            Log.e((String)this.getClass().getSimpleName(), (String)"\u4f20\u5165\u9ad8\u5ea6\u4e0d\u652f\u6301\u6216\u672a\u627e\u5230\u5bf9\u5e94\u5bbd\u5ea6,\u8bf7\u6309\u7167\u8981\u6c42\u91cd\u65b0\u8bbe\u7f6e\uff0c\u5426\u5219\u4f1a\u51fa\u73b0\u4e00\u4e9b\u4e25\u91cd\u95ee\u9898");
            mSupportedPreviewWidth = 640;
            SMALL_VIDEO_WIDTH = 360;
            SMALL_VIDEO_HEIGHT = 480;
        }
        this.mParameters.setPreviewSize(mSupportedPreviewWidth, SMALL_VIDEO_HEIGHT);
        this.mParameters.setPreviewFormat(842094169);
        String mode = this.getAutoFocusMode();
        if (StringUtils.isNotEmpty(mode)) {
            this.mParameters.setFocusMode(mode);
        }
        if (this.isSupported(this.mParameters.getSupportedWhiteBalance(), "auto")) {
            this.mParameters.setWhiteBalance("auto");
        }
        if ("true".equals(this.mParameters.get("video-stabilization-supported"))) {
            this.mParameters.set("video-stabilization", "true");
        }
        if (!DeviceUtils.isDevice("GT-N7100", "GT-I9308", "GT-I9300")) {
            this.mParameters.set("cam_mode", 1);
            this.mParameters.set("cam-mode", 1);
        }
    }

    public void startPreview() {
        if (this.mStartPreview || this.mSurfaceHolder == null || !this.mPrepared) {
            return;
        }
        this.mStartPreview = true;
        try {
            this.camera = this.mCameraId == 0 ? Camera.open() : Camera.open((int)this.mCameraId);
            this.camera.setDisplayOrientation(90);
            try {
                this.camera.setPreviewDisplay(this.mSurfaceHolder);
            }
            catch (IOException e) {
                if (this.mOnErrorListener != null) {
                    this.mOnErrorListener.onVideoError(101, 0);
                }
                Log.e((String)"jianxi", (String)("setPreviewDisplay fail " + e.getMessage()));
            }
            this.mParameters = this.camera.getParameters();
            this.mSupportedPreviewSizes = this.mParameters.getSupportedPreviewSizes();
            this.prepareCameraParaments();
            this.camera.setParameters(this.mParameters);
            this.setPreviewCallback();
            this.camera.startPreview();
            this.onStartPreviewSuccess();
            if (this.mOnPreparedListener != null) {
                this.mOnPreparedListener.onPrepared();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.mOnErrorListener != null) {
                this.mOnErrorListener.onVideoError(102, 0);
            }
            Log.e((String)"jianxi", (String)("startPreview fail :" + e.getMessage()));
        }
    }

    protected void onStartPreviewSuccess() {
    }

    protected void setPreviewCallback() {
        Camera.Size size = this.mParameters.getPreviewSize();
        if (size != null) {
            int buffSize = size.width * size.height * 3 / 2;
            try {
                this.camera.addCallbackBuffer(new byte[buffSize]);
                this.camera.addCallbackBuffer(new byte[buffSize]);
                this.camera.addCallbackBuffer(new byte[buffSize]);
                this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            }
            catch (OutOfMemoryError e) {
                Log.e((String)"jianxi", (String)"startPreview...setPreviewCallback...", (Throwable)e);
            }
            Log.e((String)"jianxi", (String)("startPreview...setPreviewCallbackWithBuffer...width:" + size.width + " height:" + size.height));
        } else {
            this.camera.setPreviewCallback((Camera.PreviewCallback)this);
        }
    }

    public void stopPreview() {
        if (this.camera != null) {
            try {
                this.camera.stopPreview();
                this.camera.setPreviewCallback(null);
                this.camera.release();
            }
            catch (Exception e) {
                Log.e((String)"jianxi", (String)"stopPreview...");
            }
            this.camera = null;
        }
        this.mStartPreview = false;
    }

    public void release() {
        this.stopAllRecord();
        this.stopPreview();
        if (this.mAudioRecorder != null) {
            this.mAudioRecorder.interrupt();
            this.mAudioRecorder = null;
        }
        this.mSurfaceHolder = null;
        this.mPrepared = false;
        this.mSurfaceCreated = false;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        this.mSurfaceCreated = true;
        if (this.mPrepared && !this.mStartPreview) {
            this.startPreview();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mSurfaceHolder = holder;
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mSurfaceHolder = null;
        this.mSurfaceCreated = false;
    }

    @Override
    public void onAudioError(int what, String message) {
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onAudioError(what, message);
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        camera.addCallbackBuffer(data);
    }

    public void testPreviewFrameCallCount() {
        new CountDownTimer(60000L, 1000L){

            public void onTick(long millisUntilFinished) {
                Log.e((String)"[Vitamio Recorder]", (String)("testFrameRate..." + MediaRecorderBase.this.mPreviewFrameCallCount));
                MediaRecorderBase.this.mPreviewFrameCallCount = 0L;
            }

            public void onFinish() {
            }
        }.start();
    }

    @Override
    public void receiveAudioData(byte[] sampleBuffer, int len) {
    }

    protected Boolean doCompress(boolean mergeFlag) {
        if (this.compressConfig != null) {
            String cmd_transcoding;
            String vbr = " -vbr 4 ";
            if (this.compressConfig != null && this.compressConfig.getMode() == 2) {
                vbr = "";
            }
            boolean transcodingFlag = FFmpegBridge.jxFFmpegCMDRun(cmd_transcoding = String.format("ffmpeg -threads 16 -i %s -c:v libx264 %s %s %s -c:a libfdk_aac %s %s %s", this.mMediaObject.getOutputTempVideoPath(), this.getBitrateModeCommand(this.compressConfig, "", false), this.getBitrateCrfSize(this.compressConfig, "-crf 28", false), this.getBitrateVelocity(this.compressConfig, "-preset:v ultrafast", false), vbr, this.getFrameRateCmd(), this.mMediaObject.getOutputTempTranscodingVideoPath())) == 0;
            boolean captureFlag = FFMpegUtils.captureThumbnails(this.mMediaObject.getOutputTempTranscodingVideoPath(), this.mMediaObject.getOutputVideoThumbPath(), String.valueOf(CAPTURE_THUMBNAILS_TIME));
            FileUtils.deleteCacheFile(this.mMediaObject.getOutputDirectory());
            boolean result = mergeFlag && captureFlag && transcodingFlag;
            return result;
        }
        boolean captureFlag = FFMpegUtils.captureThumbnails(this.mMediaObject.getOutputTempVideoPath(), this.mMediaObject.getOutputVideoThumbPath(), String.valueOf(CAPTURE_THUMBNAILS_TIME));
        FileUtils.deleteCacheFile2TS(this.mMediaObject.getOutputDirectory());
        boolean result = captureFlag && mergeFlag;
        return result;
    }

    protected String getFrameRateCmd() {
        return this.mFrameRateCmd;
    }

    protected void setTranscodingFrameRate(int rate) {
        this.mFrameRateCmd = String.format(" -r %d", rate);
    }

    protected String getBitrateModeCommand(BaseMediaBitrateConfig config, String defualtCmd, boolean needSymbol) {
        String add = "";
        if (TextUtils.isEmpty((CharSequence)defualtCmd)) {
            defualtCmd = "";
        }
        if (config != null) {
            if (config.getMode() == 1) {
                add = needSymbol ? String.format(" -x264opts \"bitrate=%d:vbv-maxrate=%d\" ", config.getBitrate(), config.getMaxBitrate()) : String.format(" -x264opts bitrate=%d:vbv-maxrate=%d ", config.getBitrate(), config.getMaxBitrate());
                return add;
            }
            if (config.getMode() == 2) {
                add = needSymbol ? String.format(" -x264opts \"bitrate=%d:vbv-bufsize=%d:nal_hrd=cbr\" ", config.getBitrate(), config.getBufSize()) : String.format(" -x264opts bitrate=%d:vbv-bufsize=%d:nal_hrd=cbr ", config.getBitrate(), config.getBufSize());
                return add;
            }
        }
        return defualtCmd;
    }

    protected String getBitrateCrfSize(BaseMediaBitrateConfig config, String defualtCmd, boolean nendSymbol) {
        if (TextUtils.isEmpty((CharSequence)defualtCmd)) {
            defualtCmd = "";
        }
        String add = "";
        if (config != null && config.getMode() == 3 && config.getCrfSize() > 0) {
            add = nendSymbol ? String.format("-crf \"%d\" ", config.getCrfSize()) : String.format("-crf %d ", config.getCrfSize());
        } else {
            return defualtCmd;
        }
        return add;
    }

    protected String getBitrateVelocity(BaseMediaBitrateConfig config, String defualtCmd, boolean nendSymbol) {
        if (TextUtils.isEmpty((CharSequence)defualtCmd)) {
            defualtCmd = "";
        }
        String add = "";
        if (config != null && !TextUtils.isEmpty((CharSequence)config.getVelocity())) {
            add = nendSymbol ? String.format("-preset \"%s\" ", config.getVelocity()) : String.format("-preset %s ", config.getVelocity());
        } else {
            return defualtCmd;
        }
        return add;
    }

    static {
        mSupportedPreviewWidth = 0;
    }

    public static interface OnEncodeListener {
        public void onEncodeStart();

        public void onEncodeProgress(int var1);

        public void onEncodeComplete();

        public void onEncodeError();
    }

    public static interface OnErrorListener {
        public void onVideoError(int var1, int var2);

        public void onAudioError(int var1, String var2);
    }

    public static interface OnPreparedListener {
        public void onPrepared();
    }
}

