/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera.views;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.IOException;
import mabeijianxi.camera.util.StringUtils;

public class SurfaceVideoView
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final int HANDLER_MESSAGE_PARSE = 0;
    private static final int HANDLER_MESSAGE_LOOP = 1;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnSeekCompleteListener mOnSeekCompleteListener;
    private MediaPlayer.OnInfoListener mOnInfoListener;
    private MediaPlayer.OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private OnPlayStateListener mOnPlayStateListener;
    private MediaPlayer mMediaPlayer = null;
    private SurfaceHolder mSurfaceHolder = null;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private static final int STATE_RELEASED = 5;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mDuration;
    private Uri mUri;
    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            SurfaceVideoView.this.mCurrentState = 5;
            if (SurfaceVideoView.this.mOnCompletionListener != null) {
                SurfaceVideoView.this.mOnCompletionListener.onCompletion(mp);
            }
        }
    };
    MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            if (SurfaceVideoView.this.mCurrentState == 1) {
                SurfaceVideoView.this.mCurrentState = 2;
                try {
                    SurfaceVideoView.this.mDuration = mp.getDuration();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    SurfaceVideoView.this.mVideoWidth = mp.getVideoWidth();
                    SurfaceVideoView.this.mVideoHeight = mp.getVideoHeight();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                switch (SurfaceVideoView.this.mTargetState) {
                    case 2: {
                        if (SurfaceVideoView.this.mOnPreparedListener == null) break;
                        SurfaceVideoView.this.mOnPreparedListener.onPrepared(SurfaceVideoView.this.mMediaPlayer);
                        break;
                    }
                    case 3: {
                        SurfaceVideoView.this.start();
                    }
                }
            }
        }
    };
    MediaPlayer.OnVideoSizeChangedListener mVideoSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            SurfaceVideoView.this.mVideoWidth = width;
            SurfaceVideoView.this.mVideoHeight = height;
            if (SurfaceVideoView.this.mOnVideoSizeChangedListener != null) {
                SurfaceVideoView.this.mOnVideoSizeChangedListener.onVideoSizeChanged(mp, width, height);
            }
        }
    };
    MediaPlayer.OnInfoListener mInfoListener = new MediaPlayer.OnInfoListener(){

        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            if (SurfaceVideoView.this.mOnInfoListener != null) {
                SurfaceVideoView.this.mOnInfoListener.onInfo(mp, what, extra);
            }
            return false;
        }
    };
    private MediaPlayer.OnSeekCompleteListener mSeekCompleteListener = new MediaPlayer.OnSeekCompleteListener(){

        public void onSeekComplete(MediaPlayer mp) {
            if (SurfaceVideoView.this.mOnSeekCompleteListener != null) {
                SurfaceVideoView.this.mOnSeekCompleteListener.onSeekComplete(mp);
            }
        }
    };
    private MediaPlayer.OnErrorListener mErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int framework_err, int impl_err) {
            SurfaceVideoView.this.mCurrentState = -1;
            if (SurfaceVideoView.this.mOnErrorListener != null) {
                SurfaceVideoView.this.mOnErrorListener.onError(mp, framework_err, impl_err);
            }
            return true;
        }
    };
    private Handler mVideoHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    SurfaceVideoView.this.pause();
                    break;
                }
                case 1: {
                    if (!SurfaceVideoView.this.isPlaying()) break;
                    SurfaceVideoView.this.seekTo(msg.arg1);
                    this.sendMessageDelayed(SurfaceVideoView.this.mVideoHandler.obtainMessage(1, msg.arg1, msg.arg2), msg.arg2);
                    break;
                }
            }
            super.handleMessage(msg);
        }
    };

    public SurfaceVideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initVideoView();
    }

    public SurfaceVideoView(Context context) {
        super(context);
        this.initVideoView();
    }

    public SurfaceVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initVideoView();
    }

    protected void initVideoView() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.getHolder().setFormat(1);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        if (Build.VERSION.SDK_INT < 11) {
            this.getHolder().setType(3);
        }
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    public static float getSystemVolumn(Context context) {
        if (context != null) {
            try {
                AudioManager mAudioManager = (AudioManager)context.getSystemService("audio");
                int maxVolumn = mAudioManager.getStreamMaxVolume(3);
                return (float)mAudioManager.getStreamVolume(3) * 1.0f / (float)maxVolumn;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return 0.5f;
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener l) {
        this.mOnInfoListener = l;
    }

    public void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener l) {
        this.mOnVideoSizeChangedListener = l;
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnPlayStateListener(OnPlayStateListener l) {
        this.mOnPlayStateListener = l;
    }

    public void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener l) {
        this.mOnSeekCompleteListener = l;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setVideoPath(String path) {
        if (StringUtils.isNotEmpty(path)) {
            this.mTargetState = 2;
            this.openVideo(Uri.parse((String)path));
        }
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public void reOpen() {
        this.mTargetState = 2;
        this.openVideo(this.mUri);
    }

    public int getDuration() {
        return this.mDuration;
    }

    private void tryAgain(Exception e) {
        this.mCurrentState = -1;
        this.openVideo(this.mUri);
    }

    public void start() {
        this.mTargetState = 3;
        if (this.mMediaPlayer != null && (this.mCurrentState == 2 || this.mCurrentState == 4 || this.mCurrentState == 3 || this.mCurrentState == 5)) {
            try {
                if (!this.isPlaying()) {
                    this.mMediaPlayer.start();
                }
                this.mCurrentState = 3;
                if (this.mOnPlayStateListener != null) {
                    this.mOnPlayStateListener.onStateChanged(true);
                }
            }
            catch (IllegalStateException e) {
                this.tryAgain(e);
            }
            catch (Exception e) {
                this.tryAgain(e);
            }
        }
    }

    public void pause() {
        this.mTargetState = 4;
        if (this.mMediaPlayer != null && this.mCurrentState == 3) {
            try {
                this.mMediaPlayer.pause();
                this.mCurrentState = 4;
                if (this.mOnPlayStateListener != null) {
                    this.mOnPlayStateListener.onStateChanged(false);
                }
            }
            catch (IllegalStateException e) {
                this.tryAgain(e);
            }
            catch (Exception e) {
                this.tryAgain(e);
            }
        }
    }

    public void dispatchKeyEvent(Context context, KeyEvent event) {
        switch (event.getKeyCode()) {
            case 24: 
            case 25: {
                this.setVolume(SurfaceVideoView.getSystemVolumn(context));
            }
        }
    }

    public void setVolume(float volume) {
        if (this.mMediaPlayer != null && (this.mCurrentState == 2 || this.mCurrentState == 3 || this.mCurrentState == 4 || this.mCurrentState == 5)) {
            try {
                this.mMediaPlayer.setVolume(volume, volume);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setLooping(boolean looping) {
        if (this.mMediaPlayer != null && (this.mCurrentState == 2 || this.mCurrentState == 3 || this.mCurrentState == 4 || this.mCurrentState == 5)) {
            try {
                this.mMediaPlayer.setLooping(looping);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void seekTo(int msec) {
        if (this.mMediaPlayer != null && (this.mCurrentState == 2 || this.mCurrentState == 3 || this.mCurrentState == 4 || this.mCurrentState == 5)) {
            try {
                if (msec < 0) {
                    msec = 0;
                }
                this.mMediaPlayer.seekTo(msec);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getCurrentPosition() {
        int position = 0;
        if (this.mMediaPlayer != null) {
            switch (this.mCurrentState) {
                case 5: {
                    position = this.getDuration();
                    break;
                }
                case 3: 
                case 4: {
                    try {
                        position = this.mMediaPlayer.getCurrentPosition();
                        break;
                    }
                    catch (IllegalStateException illegalStateException) {
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return position;
    }

    public boolean isPlaying() {
        if (this.mMediaPlayer != null && this.mCurrentState == 3) {
            try {
                return this.mMediaPlayer.isPlaying();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void release() {
        this.mTargetState = 5;
        this.mCurrentState = 5;
        if (this.mMediaPlayer != null) {
            try {
                this.mMediaPlayer.release();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mMediaPlayer = null;
        }
    }

    public SurfaceHolder getSurfaceHolder() {
        return this.mSurfaceHolder;
    }

    public void openVideo(Uri uri) {
        if (uri == null || this.mSurfaceHolder == null || this.getContext() == null) {
            if (this.mSurfaceHolder == null && uri != null) {
                this.mUri = uri;
            }
            return;
        }
        this.mUri = uri;
        this.mDuration = 0;
        Exception exception = null;
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
                this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
                this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
                this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
                this.mMediaPlayer.setOnVideoSizeChangedListener(this.mVideoSizeChangedListener);
                this.mMediaPlayer.setAudioStreamType(3);
                this.mMediaPlayer.setOnSeekCompleteListener(this.mSeekCompleteListener);
                this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
                this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            } else {
                this.mMediaPlayer.reset();
            }
            this.mMediaPlayer.setDataSource(this.getContext(), uri);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
        }
        catch (IOException ex) {
            exception = ex;
        }
        catch (IllegalArgumentException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        if (exception != null) {
            this.mCurrentState = -1;
            if (this.mErrorListener != null) {
                this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            }
        }
    }

    public boolean isPrepared() {
        return this.mMediaPlayer != null && this.mCurrentState == 2;
    }

    public boolean isComplate() {
        return this.mMediaPlayer != null && this.mCurrentState == 5;
    }

    public boolean isRelease() {
        return this.mMediaPlayer == null || this.mCurrentState == 0 || this.mCurrentState == -1 || this.mCurrentState == 5;
    }

    public void pauseDelayed(int delayMillis) {
        if (this.mVideoHandler.hasMessages(0)) {
            this.mVideoHandler.removeMessages(0);
        }
        this.mVideoHandler.sendEmptyMessageDelayed(0, (long)delayMillis);
    }

    public void pauseClearDelayed() {
        this.pause();
        if (this.mVideoHandler.hasMessages(0)) {
            this.mVideoHandler.removeMessages(0);
        }
        if (this.mVideoHandler.hasMessages(1)) {
            this.mVideoHandler.removeMessages(1);
        }
    }

    public void loopDelayed(int startTime, int endTime) {
        if (this.mVideoHandler.hasMessages(0)) {
            this.mVideoHandler.removeMessages(0);
        }
        if (this.mVideoHandler.hasMessages(1)) {
            this.mVideoHandler.removeMessages(1);
        }
        int delayMillis = endTime - startTime;
        this.seekTo(startTime);
        if (!this.isPlaying()) {
            this.start();
        }
        if (this.mVideoHandler.hasMessages(1)) {
            this.mVideoHandler.removeMessages(1);
        }
        this.mVideoHandler.sendMessageDelayed(this.mVideoHandler.obtainMessage(1, this.getCurrentPosition(), delayMillis), (long)delayMillis);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        boolean needReOpen = this.mSurfaceHolder == null;
        this.mSurfaceHolder = holder;
        if (needReOpen) {
            this.reOpen();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mSurfaceHolder = holder;
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mSurfaceHolder = null;
        this.release();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public static interface OnPlayStateListener {
        public void onStateChanged(boolean var1);
    }
}

