/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera.util;

import android.os.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import mabeijianxi.camera.util.DeviceUtils;
import mabeijianxi.camera.util.Log;
import mabeijianxi.camera.util.StringUtils;

public class FileUtils {
    public static String concatPath(String ... paths) {
        StringBuilder result = new StringBuilder();
        if (paths != null) {
            for (String path : paths) {
                boolean prefixSeparator;
                if (path == null || path.length() <= 0) continue;
                int len = result.length();
                boolean suffixSeparator = len > 0 && result.charAt(len - 1) == File.separatorChar;
                boolean bl = prefixSeparator = path.charAt(0) == File.separatorChar;
                if (suffixSeparator && prefixSeparator) {
                    result.append(path.substring(1));
                    continue;
                }
                if (!suffixSeparator && !prefixSeparator) {
                    result.append(File.separatorChar);
                    result.append(path);
                    continue;
                }
                result.append(path);
            }
        }
        return result.toString();
    }

    public static String calculateMD5(File updateFile) {
        FileInputStream is;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            Log.e("FileUtils", "Exception while getting digest", e);
            return null;
        }
        try {
            is = new FileInputStream(updateFile);
        }
        catch (FileNotFoundException e) {
            Log.e("FileUtils", "Exception while getting FileInputStream", e);
            return null;
        }
        byte[] buffer = new byte[8192];
        try {
            int read;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String output = bigInt.toString(16);
            String string2 = output = String.format("%32s", output).replace(' ', '0');
            return string2;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process file for MD5", e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                Log.e("FileUtils", "Exception on closing MD5 input stream", e);
            }
        }
    }

    public static String calculateMD5(File updateFile, int offset, int partSize) {
        FileInputStream is;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            Log.e("FileUtils", "Exception while getting digest", e);
            return null;
        }
        try {
            is = new FileInputStream(updateFile);
        }
        catch (FileNotFoundException e) {
            Log.e("FileUtils", "Exception while getting FileInputStream", e);
            return null;
        }
        int buffSize = 8192;
        byte[] buffer = new byte[8192];
        try {
            int read;
            if (offset > 0) {
                ((InputStream)is).skip(offset);
            }
            int byteCount = Math.min(8192, partSize);
            int byteLen = 0;
            while ((read = ((InputStream)is).read(buffer, 0, byteCount)) > 0 && byteLen < partSize) {
                digest.update(buffer, 0, read);
                if ((byteLen += read) + 8192 <= partSize) continue;
                byteCount = partSize - byteLen;
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String output = bigInt.toString(16);
            String string2 = output = String.format("%32s", output).replace(' ', '0');
            return string2;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process file for MD5", e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                Log.e("FileUtils", "Exception on closing MD5 input stream", e);
            }
        }
    }

    public static boolean checkFile(File f) {
        return f != null && f.exists() && f.canRead() && (f.isDirectory() || f.isFile() && f.length() > 0L);
    }

    public static boolean checkFile(String path) {
        File f;
        return StringUtils.isNotEmpty(path) && (f = new File(path)) != null && f.exists() && f.canRead() && (f.isDirectory() || f.isFile() && f.length() > 0L);
    }

    public static String getExternalStorageDirectory() {
        String path = Environment.getExternalStorageDirectory().getPath();
        if (DeviceUtils.isZte()) {
            path = path.replace("/sdcard", "/sdcard-ext");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileSize(String fn) {
        File f = null;
        long size = 0L;
        try {
            f = new File(fn);
            size = f.length();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            f = null;
        }
        return size < 0L ? null : Long.valueOf(size);
    }

    public static long getFileSize(File fn) {
        return fn == null ? 0L : fn.length();
    }

    public static String getFileType(String fn, String defaultType) {
        FileNameMap fNameMap = URLConnection.getFileNameMap();
        String type = fNameMap.getContentTypeFor(fn);
        return type == null ? defaultType : type;
    }

    public static String getFileType(String fn) {
        return FileUtils.getFileType(fn, "application/octet-stream");
    }

    public static String getFileExtension(String filename) {
        int dotPos;
        String extension = "";
        if (filename != null && (dotPos = filename.lastIndexOf(".")) >= 0 && dotPos < filename.length() - 1) {
            extension = filename.substring(dotPos + 1);
        }
        return extension.toLowerCase();
    }

    public static boolean deleteFile(File f) {
        if (f != null && f.exists() && !f.isDirectory()) {
            return f.delete();
        }
        return false;
    }

    public static void deleteDir(File f) {
        if (f != null && f.exists() && f.isDirectory()) {
            for (File file : f.listFiles()) {
                if (file.isDirectory()) {
                    FileUtils.deleteDir(file);
                }
                file.delete();
            }
            f.delete();
        }
    }

    public static void deleteCacheFile(String f) {
        File files;
        if (f != null && f.length() > 0 && (files = new File(f)).exists() && files.isDirectory()) {
            for (File file : files.listFiles()) {
                if (file.isDirectory() || !file.getName().contains(".ts") && !file.getName().contains("temp")) continue;
                file.delete();
            }
        }
    }

    public static void deleteCacheFile2TS(String f) {
        File files;
        if (f != null && f.length() > 0 && (files = new File(f)).exists() && files.isDirectory()) {
            for (File file : files.listFiles()) {
                if (file.isDirectory() || !file.getName().contains(".ts")) continue;
                file.delete();
            }
        }
    }

    public static void deleteDir(String f) {
        if (f != null && f.length() > 0) {
            FileUtils.deleteDir(new File(f));
        }
    }

    public static boolean deleteFile(String f) {
        if (f != null && f.length() > 0) {
            return FileUtils.deleteFile(new File(f));
        }
        return false;
    }

    public static String readFile(File file, String charsetName) {
        StringBuilder fileContent = new StringBuilder("");
        if (file == null || !file.isFile()) {
            return fileContent.toString();
        }
        BufferedReader reader = null;
        try {
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(file), charsetName);
            reader = new BufferedReader(is);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!fileContent.toString().equals("")) {
                    fileContent.append("\r\n");
                }
                fileContent.append(line);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred. ", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException occurred. ", e);
                }
            }
        }
        return fileContent.toString();
    }

    public static String readFile(String filePath, String charsetName) {
        return FileUtils.readFile(new File(filePath), charsetName);
    }

    public static String readFile(File file) {
        return FileUtils.readFile(file, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileCopy(String from, String to) {
        boolean result = false;
        int size = 1024;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            byte[] buffer = new byte[size];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            result = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
        return result;
    }
}

