/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera.util;

import android.content.Context;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import mabeijianxi.camera.util.StringUtils;

public class DeviceUtils {
    public static boolean hasFroyo() {
        return Build.VERSION.SDK_INT >= 8;
    }

    public static boolean hasGingerbread() {
        return Build.VERSION.SDK_INT >= 9;
    }

    public static boolean hasHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    public static boolean hasHoneycombMR1() {
        return Build.VERSION.SDK_INT >= 12;
    }

    public static boolean hasICS() {
        return Build.VERSION.SDK_INT >= 14;
    }

    public static boolean hasJellyBean() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean hasJellyBeanMr1() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static boolean hasJellyBeanMr2() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public static boolean hasKitkat() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static int getSDKVersionInt() {
        return Build.VERSION.SDK_INT;
    }

    public static String getSDKVersion() {
        return Build.VERSION.SDK;
    }

    public static String getReleaseVersion() {
        return StringUtils.makeSafe(Build.VERSION.RELEASE);
    }

    public static boolean isZte() {
        return DeviceUtils.getDeviceModel().toLowerCase().indexOf("zte") != -1;
    }

    public static boolean isSamsung() {
        return DeviceUtils.getManufacturer().toLowerCase().indexOf("samsung") != -1;
    }

    public static boolean isHTC() {
        return DeviceUtils.getManufacturer().toLowerCase().indexOf("htc") != -1;
    }

    public static boolean isDevice(String ... devices) {
        String model = DeviceUtils.getDeviceModel();
        if (devices != null && model != null) {
            for (String device : devices) {
                if (model.indexOf(device) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static String getDeviceModel() {
        return StringUtils.trim(Build.MODEL);
    }

    public static String getManufacturer() {
        return StringUtils.trim(Build.MANUFACTURER);
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean isHoneycombTablet(Context context) {
        return DeviceUtils.hasHoneycomb() && DeviceUtils.isTablet(context);
    }

    public static int dipToPX(Context ctx, float dip) {
        return (int)TypedValue.applyDimension((int)1, (float)dip, (DisplayMetrics)ctx.getResources().getDisplayMetrics());
    }

    public static String getCpuInfo() {
        String cpuInfo = "";
        try {
            if (new File("/proc/cpuinfo").exists()) {
                FileReader fr = new FileReader("/proc/cpuinfo");
                BufferedReader localBufferedReader = new BufferedReader(fr, 8192);
                cpuInfo = localBufferedReader.readLine();
                localBufferedReader.close();
                if (cpuInfo != null) {
                    cpuInfo = cpuInfo.split(":")[1].trim().split(" ")[0];
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cpuInfo;
    }

    public static boolean isSupportCameraLedFlash(PackageManager pm) {
        FeatureInfo[] features;
        if (pm != null && (features = pm.getSystemAvailableFeatures()) != null) {
            for (FeatureInfo f : features) {
                if (f == null || !"android.hardware.camera.flash".equals(f.name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSupportCameraHardware(Context context) {
        return context != null && context.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public static int getScreenWidth(Context context) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        return display.getWidth();
    }

    public static int getScreenHeight(Context context) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        return display.getHeight();
    }
}

