/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera.model;

import android.os.Parcel;
import android.os.Parcelable;
import mabeijianxi.camera.model.AutoVBRMode;
import mabeijianxi.camera.model.BaseMediaBitrateConfig;

public final class MediaRecorderConfig
implements Parcelable {
    private final int RECORD_TIME_MAX;
    private final int RECORD_TIME_MIN;
    private final int SMALL_VIDEO_HEIGHT;
    private final int SMALL_VIDEO_WIDTH;
    private final int MAX_FRAME_RATE;
    private final int MIN_FRAME_RATE;
    private final int VIDEO_BITRATE;
    private final boolean doH264Compress;
    private final int captureThumbnailsTime;
    private final boolean GO_HOME;
    private final BaseMediaBitrateConfig mediaBitrateConfig;
    private final BaseMediaBitrateConfig compressConfig;
    public static final Parcelable.Creator<MediaRecorderConfig> CREATOR = new Parcelable.Creator<MediaRecorderConfig>(){

        public MediaRecorderConfig createFromParcel(Parcel in) {
            return new MediaRecorderConfig(in);
        }

        public MediaRecorderConfig[] newArray(int size) {
            return new MediaRecorderConfig[size];
        }
    };

    private MediaRecorderConfig(Buidler buidler) {
        this.RECORD_TIME_MAX = buidler.RECORD_TIME_MAX;
        this.RECORD_TIME_MIN = buidler.RECORD_TIME_MIN;
        this.MAX_FRAME_RATE = buidler.MAX_FRAME_RATE;
        this.captureThumbnailsTime = buidler.captureThumbnailsTime;
        this.MIN_FRAME_RATE = buidler.MIN_FRAME_RATE;
        this.SMALL_VIDEO_HEIGHT = buidler.SMALL_VIDEO_HEIGHT;
        this.SMALL_VIDEO_WIDTH = buidler.SMALL_VIDEO_WIDTH;
        this.VIDEO_BITRATE = buidler.VIDEO_BITRATE;
        this.doH264Compress = buidler.doH264Compress;
        this.mediaBitrateConfig = buidler.mediaBitrateConfig;
        this.compressConfig = buidler.compressConfig;
        this.GO_HOME = buidler.GO_HOME;
    }

    protected MediaRecorderConfig(Parcel in) {
        this.RECORD_TIME_MAX = in.readInt();
        this.RECORD_TIME_MIN = in.readInt();
        this.SMALL_VIDEO_HEIGHT = in.readInt();
        this.SMALL_VIDEO_WIDTH = in.readInt();
        this.MAX_FRAME_RATE = in.readInt();
        this.MIN_FRAME_RATE = in.readInt();
        this.VIDEO_BITRATE = in.readInt();
        this.doH264Compress = in.readByte() != 0;
        this.captureThumbnailsTime = in.readInt();
        this.GO_HOME = in.readByte() != 0;
        this.mediaBitrateConfig = (BaseMediaBitrateConfig)in.readParcelable(BaseMediaBitrateConfig.class.getClassLoader());
        this.compressConfig = (BaseMediaBitrateConfig)in.readParcelable(BaseMediaBitrateConfig.class.getClassLoader());
    }

    public boolean isGO_HOME() {
        return this.GO_HOME;
    }

    public int getCaptureThumbnailsTime() {
        return this.captureThumbnailsTime;
    }

    public boolean isDoH264Compress() {
        return this.doH264Compress;
    }

    public int getMaxFrameRate() {
        return this.MAX_FRAME_RATE;
    }

    public int getMinFrameRate() {
        return this.MIN_FRAME_RATE;
    }

    public int getRecordTimeMax() {
        return this.RECORD_TIME_MAX;
    }

    public int getRecordTimeMin() {
        return this.RECORD_TIME_MIN;
    }

    public int getSmallVideoHeight() {
        return this.SMALL_VIDEO_HEIGHT;
    }

    public int getSmallVideoWidth() {
        return this.SMALL_VIDEO_WIDTH;
    }

    public BaseMediaBitrateConfig getMediaBitrateConfig() {
        return this.mediaBitrateConfig;
    }

    public BaseMediaBitrateConfig getCompressConfig() {
        return this.compressConfig;
    }

    public int getVideoBitrate() {
        return this.VIDEO_BITRATE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.RECORD_TIME_MAX);
        dest.writeInt(this.RECORD_TIME_MIN);
        dest.writeInt(this.SMALL_VIDEO_HEIGHT);
        dest.writeInt(this.SMALL_VIDEO_WIDTH);
        dest.writeInt(this.MAX_FRAME_RATE);
        dest.writeInt(this.MIN_FRAME_RATE);
        dest.writeInt(this.VIDEO_BITRATE);
        dest.writeByte((byte)(this.doH264Compress ? 1 : 0));
        dest.writeInt(this.captureThumbnailsTime);
        dest.writeByte((byte)(this.GO_HOME ? 1 : 0));
        dest.writeParcelable((Parcelable)this.mediaBitrateConfig, flags);
        dest.writeParcelable((Parcelable)this.compressConfig, flags);
    }

    public static class Buidler {
        private int RECORD_TIME_MAX = 6000;
        private int RECORD_TIME_MIN = 1500;
        private int SMALL_VIDEO_HEIGHT = 360;
        private int SMALL_VIDEO_WIDTH = 480;
        private int MAX_FRAME_RATE = 20;
        private int MIN_FRAME_RATE = 8;
        private int VIDEO_BITRATE;
        private boolean doH264Compress = true;
        private int captureThumbnailsTime = 1;
        private BaseMediaBitrateConfig mediaBitrateConfig;
        private boolean GO_HOME = false;
        private BaseMediaBitrateConfig compressConfig;

        public MediaRecorderConfig build() {
            return new MediaRecorderConfig(this);
        }

        public Buidler captureThumbnailsTime(int captureThumbnailsTime) {
            this.captureThumbnailsTime = captureThumbnailsTime;
            return this;
        }

        @Deprecated
        public Buidler doH264Compress(boolean doH264Compress) {
            this.doH264Compress = doH264Compress;
            if (doH264Compress) {
                this.doH264Compress(new AutoVBRMode());
            }
            return this;
        }

        public Buidler doH264Compress(BaseMediaBitrateConfig compressConfig) {
            this.compressConfig = compressConfig;
            return this;
        }

        public Buidler maxFrameRate(int MAX_FRAME_RATE) {
            this.MAX_FRAME_RATE = MAX_FRAME_RATE;
            return this;
        }

        public Buidler minFrameRate(int MIN_FRAME_RATE) {
            this.MIN_FRAME_RATE = MIN_FRAME_RATE;
            return this;
        }

        public Buidler recordTimeMax(int RECORD_TIME_MAX) {
            this.RECORD_TIME_MAX = RECORD_TIME_MAX;
            return this;
        }

        public Buidler recordTimeMin(int RECORD_TIME_MIN) {
            this.RECORD_TIME_MIN = RECORD_TIME_MIN;
            return this;
        }

        public Buidler smallVideoHeight(int SMALL_VIDEO_HEIGHT) {
            this.SMALL_VIDEO_HEIGHT = SMALL_VIDEO_HEIGHT;
            return this;
        }

        public Buidler smallVideoWidth(int SMALL_VIDEO_WIDTH) {
            this.SMALL_VIDEO_WIDTH = SMALL_VIDEO_WIDTH;
            return this;
        }

        @Deprecated
        public Buidler videoBitrate(int VIDEO_BITRATE) {
            this.VIDEO_BITRATE = VIDEO_BITRATE;
            return this;
        }

        public Buidler goHome(boolean GO_HOME) {
            this.GO_HOME = GO_HOME;
            return this;
        }

        public Buidler setMediaBitrateConfig(BaseMediaBitrateConfig mediaBitrateConfig) {
            this.mediaBitrateConfig = mediaBitrateConfig;
            return this;
        }
    }
}

