/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import mabeijianxi.camera.model.MediaThemeObject;
import mabeijianxi.camera.util.FileUtils;
import mabeijianxi.camera.util.StringUtils;

public class MediaObject
implements Serializable {
    public static final int MEDIA_PART_TYPE_RECORD = 0;
    public static final int MEDIA_PART_TYPE_IMPORT_VIDEO = 1;
    public static final int MEDIA_PART_TYPE_IMPORT_IMAGE = 2;
    public static final int MEDIA_PART_TYPE_RECORD_MP4 = 3;
    public static final int DEFAULT_MAX_DURATION = 10000;
    public static final int DEFAULT_VIDEO_BITRATE = 800;
    private int mMaxDuration;
    private String mOutputDirectory;
    private String mOutputObjectPath;
    private int mVideoBitrate;
    private String mOutputVideoPath;
    private String mOutputVideoThumbPath;
    private String mKey;
    private volatile transient MediaPart mCurrentPart;
    private LinkedList<MediaPart> mMediaList = new LinkedList();
    public MediaThemeObject mThemeObject;
    private String outputTempVideoPath;

    public MediaObject(String key, String path) {
        this(key, path, 800);
    }

    public MediaObject(String key, String path, int videoBitrate) {
        this.mKey = key;
        this.mOutputDirectory = path;
        this.mVideoBitrate = videoBitrate;
        this.mOutputObjectPath = this.mOutputDirectory + File.separator + this.mKey + ".obj";
        this.mOutputVideoPath = this.mOutputDirectory + ".mp4";
        this.mOutputVideoThumbPath = this.mOutputDirectory + File.separator + this.mKey + ".jpg";
        this.mMaxDuration = 10000;
        this.outputTempVideoPath = this.mOutputDirectory + File.separator + this.mKey + "_temp.mp4";
    }

    public int getVideoBitrate() {
        return this.mVideoBitrate;
    }

    public int getMaxDuration() {
        return this.mMaxDuration;
    }

    public void setMaxDuration(int duration) {
        if (duration >= 1000) {
            this.mMaxDuration = duration;
        }
    }

    public String getOutputDirectory() {
        return this.mOutputDirectory;
    }

    public String getOutputTempVideoPath() {
        return this.outputTempVideoPath;
    }

    public void setOutputTempVideoPath(String path) {
        this.outputTempVideoPath = path;
    }

    public String getOutputTempTranscodingVideoPath() {
        return this.mOutputDirectory + File.separator + this.mKey + ".mp4";
    }

    public void cleanTheme() {
        this.mThemeObject = null;
        if (this.mMediaList != null) {
            for (MediaPart part : this.mMediaList) {
                part.cutStartTime = 0;
                part.cutEndTime = part.duration;
            }
        }
    }

    public String getObjectFilePath() {
        if (StringUtils.isEmpty(this.mOutputObjectPath)) {
            String obj;
            File f = new File(this.mOutputVideoPath);
            this.mOutputObjectPath = obj = this.mOutputDirectory + File.separator + f.getName() + ".obj";
        }
        return this.mOutputObjectPath;
    }

    public String getOutputVideoPath() {
        return this.mOutputVideoPath;
    }

    public String getOutputVideoThumbPath() {
        return this.mOutputVideoThumbPath;
    }

    public int getDuration() {
        int duration = 0;
        if (this.mMediaList != null) {
            for (MediaPart part : this.mMediaList) {
                duration += part.getDuration();
            }
        }
        return duration;
    }

    public int getCutDuration() {
        int duration = 0;
        if (this.mMediaList != null) {
            for (MediaPart part : this.mMediaList) {
                int cut = part.cutEndTime - part.cutStartTime;
                if (part.speed != 10) {
                    cut = (int)((float)cut * (10.0f / (float)part.speed));
                }
                duration += cut;
            }
        }
        return duration;
    }

    public void removePart(MediaPart part, boolean deleteFile) {
        if (this.mMediaList != null) {
            this.mMediaList.remove(part);
        }
        if (part != null) {
            part.stop();
            if (deleteFile) {
                part.delete();
            }
            this.mMediaList.remove(part);
            if (this.mCurrentPart != null && part.equals(this.mCurrentPart)) {
                this.mCurrentPart = null;
            }
        }
    }

    public MediaPart buildMediaPart(int cameraId) {
        this.mCurrentPart = new MediaPart();
        this.mCurrentPart.position = this.getDuration();
        this.mCurrentPart.index = this.mMediaList.size();
        this.mCurrentPart.mediaPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".v";
        this.mCurrentPart.audioPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".a";
        this.mCurrentPart.thumbPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".jpg";
        this.mCurrentPart.cameraId = cameraId;
        this.mCurrentPart.prepare();
        this.mCurrentPart.recording = true;
        this.mCurrentPart.startTime = System.currentTimeMillis();
        this.mCurrentPart.type = 1;
        this.mMediaList.add(this.mCurrentPart);
        return this.mCurrentPart;
    }

    public MediaPart buildMediaPart(int cameraId, String videoSuffix) {
        this.mCurrentPart = new MediaPart();
        this.mCurrentPart.position = this.getDuration();
        this.mCurrentPart.index = this.mMediaList.size();
        this.mCurrentPart.mediaPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + videoSuffix;
        this.mCurrentPart.audioPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".a";
        this.mCurrentPart.thumbPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".jpg";
        this.mCurrentPart.recording = true;
        this.mCurrentPart.cameraId = cameraId;
        this.mCurrentPart.startTime = System.currentTimeMillis();
        this.mCurrentPart.type = 1;
        this.mMediaList.add(this.mCurrentPart);
        return this.mCurrentPart;
    }

    public MediaPart buildMediaPart(String path, int duration, int type) {
        this.mCurrentPart = new MediaPart();
        this.mCurrentPart.position = this.getDuration();
        this.mCurrentPart.index = this.mMediaList.size();
        this.mCurrentPart.mediaPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".v";
        this.mCurrentPart.audioPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".a";
        this.mCurrentPart.thumbPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".jpg";
        this.mCurrentPart.duration = duration;
        this.mCurrentPart.startTime = 0L;
        this.mCurrentPart.endTime = duration;
        this.mCurrentPart.cutStartTime = 0;
        this.mCurrentPart.cutEndTime = duration;
        this.mCurrentPart.tempPath = path;
        this.mCurrentPart.type = type;
        this.mMediaList.add(this.mCurrentPart);
        return this.mCurrentPart;
    }

    public String getConcatYUV() {
        StringBuilder yuv = new StringBuilder();
        if (this.mMediaList != null && this.mMediaList.size() > 0) {
            if (this.mMediaList.size() == 1) {
                if (StringUtils.isEmpty(this.mMediaList.get((int)0).tempMediaPath)) {
                    yuv.append(this.mMediaList.get((int)0).mediaPath);
                } else {
                    yuv.append(this.mMediaList.get((int)0).tempMediaPath);
                }
            } else {
                yuv.append("concat:");
                int j = this.mMediaList.size();
                for (int i = 0; i < j; ++i) {
                    MediaPart part = this.mMediaList.get(i);
                    if (StringUtils.isEmpty(part.tempMediaPath)) {
                        yuv.append(part.mediaPath);
                    } else {
                        yuv.append(part.tempMediaPath);
                    }
                    if (i + 1 >= j) continue;
                    yuv.append("|");
                }
            }
        }
        return yuv.toString();
    }

    public String getConcatPCM() {
        StringBuilder yuv = new StringBuilder();
        if (this.mMediaList != null && this.mMediaList.size() > 0) {
            if (this.mMediaList.size() == 1) {
                if (StringUtils.isEmpty(this.mMediaList.get((int)0).tempAudioPath)) {
                    yuv.append(this.mMediaList.get((int)0).audioPath);
                } else {
                    yuv.append(this.mMediaList.get((int)0).tempAudioPath);
                }
            } else {
                yuv.append("concat:");
                int j = this.mMediaList.size();
                for (int i = 0; i < j; ++i) {
                    MediaPart part = this.mMediaList.get(i);
                    if (StringUtils.isEmpty(part.tempAudioPath)) {
                        yuv.append(part.audioPath);
                    } else {
                        yuv.append(part.tempAudioPath);
                    }
                    if (i + 1 >= j) continue;
                    yuv.append("|");
                }
            }
        }
        return yuv.toString();
    }

    public MediaPart getCurrentPart() {
        if (this.mCurrentPart != null) {
            return this.mCurrentPart;
        }
        if (this.mMediaList != null && this.mMediaList.size() > 0) {
            this.mCurrentPart = this.mMediaList.get(this.mMediaList.size() - 1);
        }
        return this.mCurrentPart;
    }

    public int getCurrentIndex() {
        MediaPart part = this.getCurrentPart();
        if (part != null) {
            return part.index;
        }
        return 0;
    }

    public MediaPart getPart(int index) {
        if (this.mCurrentPart != null && index < this.mMediaList.size()) {
            return this.mMediaList.get(index);
        }
        return null;
    }

    public void delete() {
        if (this.mMediaList != null) {
            for (MediaPart part : this.mMediaList) {
                part.stop();
            }
        }
        FileUtils.deleteDir(this.mOutputDirectory);
    }

    public LinkedList<MediaPart> getMedaParts() {
        return this.mMediaList;
    }

    public static void preparedMediaObject(MediaObject mMediaObject) {
        if (mMediaObject != null && mMediaObject.mMediaList != null) {
            int duration = 0;
            for (MediaPart part : mMediaObject.mMediaList) {
                part.startTime = duration;
                part.endTime = part.startTime + (long)part.duration;
                duration += part.duration;
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.mMediaList != null) {
            result.append("[" + this.mMediaList.size() + "]");
            for (MediaPart part : this.mMediaList) {
                result.append(part.mediaPath + ":" + part.duration + "\n");
            }
        }
        return result.toString();
    }

    public static class MediaPart
    implements Serializable {
        public int index;
        public String mediaPath;
        public String audioPath;
        public String tempMediaPath;
        public String tempAudioPath;
        public String thumbPath;
        public String tempPath;
        public int type = 0;
        public int cutStartTime;
        public int cutEndTime;
        public int duration;
        public int position;
        public int speed = 10;
        public int cameraId;
        public int yuvWidth;
        public int yuvHeight;
        public transient boolean remove;
        public transient long startTime;
        public transient long endTime;
        public transient FileOutputStream mCurrentOutputVideo;
        public transient FileOutputStream mCurrentOutputAudio;
        public volatile transient boolean recording;

        public void delete() {
            FileUtils.deleteFile(this.mediaPath);
            FileUtils.deleteFile(this.audioPath);
            FileUtils.deleteFile(this.thumbPath);
            FileUtils.deleteFile(this.tempMediaPath);
            FileUtils.deleteFile(this.tempAudioPath);
        }

        public void writeAudioData(byte[] buffer) throws IOException {
            if (this.mCurrentOutputAudio != null) {
                this.mCurrentOutputAudio.write(buffer);
            }
        }

        public void writeVideoData(byte[] buffer) throws IOException {
            if (this.mCurrentOutputVideo != null) {
                this.mCurrentOutputVideo.write(buffer);
            }
        }

        public void prepare() {
            try {
                this.mCurrentOutputVideo = new FileOutputStream(this.mediaPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.prepareAudio();
        }

        public void prepareAudio() {
            try {
                this.mCurrentOutputAudio = new FileOutputStream(this.audioPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public int getDuration() {
            return this.duration > 0 ? this.duration : (int)(System.currentTimeMillis() - this.startTime);
        }

        public void stop() {
            if (this.mCurrentOutputVideo != null) {
                try {
                    this.mCurrentOutputVideo.flush();
                    this.mCurrentOutputVideo.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.mCurrentOutputVideo = null;
            }
            if (this.mCurrentOutputAudio != null) {
                try {
                    this.mCurrentOutputAudio.flush();
                    this.mCurrentOutputAudio.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.mCurrentOutputAudio = null;
            }
        }
    }
}

