/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera;

import android.content.Context;
import android.content.pm.PackageManager;
import com.yixia.videoeditor.adapter.UtilityAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import mabeijianxi.camera.util.DeviceUtils;
import mabeijianxi.camera.util.Log;

public class VCamera {
    private static String mPackageName;
    private static String mAppVersionName;
    private static int mAppVersionCode;
    private static String mVideoCachePath;
    public static final String VCAMERA_SDK_VERSION = "1.2.0";
    public static final String FFMPEG_LOG_FILENAME = "ffmpeg.log";
    public static final String FFMPEG_LOG_FILENAME_TEMP = "temp_ffmpeg.log";

    public static void initialize(Context context) {
        mPackageName = context.getPackageName();
        mAppVersionName = VCamera.getVerName(context);
        mAppVersionCode = VCamera.getVerCode(context);
        UtilityAdapter.FFmpegInit(context, String.format("versionName=%s&versionCode=%d&sdkVersion=%s&android=%s&device=%s", mAppVersionName, mAppVersionCode, VCAMERA_SDK_VERSION, DeviceUtils.getReleaseVersion(), DeviceUtils.getDeviceModel()));
    }

    public static int getVerCode(Context context) {
        int verCode = -1;
        try {
            verCode = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return verCode;
    }

    public static String getVerName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "";
        }
    }

    public static boolean isLog() {
        return Log.getIsLog();
    }

    public static String getPackageName() {
        return mPackageName;
    }

    public static void setDebugMode(boolean enable) {
        Log.setLog(enable);
    }

    public static String getVideoCachePath() {
        return mVideoCachePath;
    }

    public static void setVideoCachePath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        mVideoCachePath = path;
        File temp = new File(VCamera.getVideoCachePath(), FFMPEG_LOG_FILENAME_TEMP);
        if (!temp.exists()) {
            try {
                temp.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean copyFFmpegLog(String cmd) {
        boolean result = false;
        int size = 1024;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            File temp = new File(VCamera.getVideoCachePath(), FFMPEG_LOG_FILENAME_TEMP);
            if (!temp.exists()) {
                temp.createNewFile();
                boolean bl = false;
                return bl;
            }
            in = new FileInputStream(temp);
            out = new FileOutputStream(new File(VCamera.getVideoCachePath(), FFMPEG_LOG_FILENAME), true);
            out.write("--------------------------------------------------\r\n".getBytes());
            out.write(cmd.getBytes());
            out.write("\r\n\r\n".getBytes());
            byte[] buffer = new byte[size];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            result = true;
        }
        catch (FileNotFoundException e) {
            Log.e("upload", e);
        }
        catch (IOException e) {
            Log.e("upload", e);
        }
        catch (Exception e) {
            Log.e("upload", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
        return result;
    }
}

