/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera;

import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.AsyncTask;
import android.util.Log;
import com.yixia.videoeditor.adapter.UtilityAdapter;
import java.io.IOException;
import mabeijianxi.camera.FFMpegUtils;
import mabeijianxi.camera.MediaRecorderBase;
import mabeijianxi.camera.model.MediaObject;
import mabeijianxi.camera.util.FileUtils;

public class MediaRecorderSystem
extends MediaRecorderBase
implements MediaRecorder.OnErrorListener {
    private MediaRecorder mMediaRecorder;

    @Override
    public MediaObject.MediaPart startRecord() {
        if (this.mMediaObject != null && this.mSurfaceHolder != null && !this.mRecording) {
            MediaObject.MediaPart result = this.mMediaObject.buildMediaPart(this.mCameraId, ".mp4");
            try {
                if (this.mMediaRecorder == null) {
                    this.mMediaRecorder = new MediaRecorder();
                    this.mMediaRecorder.setOnErrorListener((MediaRecorder.OnErrorListener)this);
                } else {
                    this.mMediaRecorder.reset();
                }
                this.camera.unlock();
                this.mMediaRecorder.setCamera(this.camera);
                this.mMediaRecorder.setPreviewDisplay(this.mSurfaceHolder.getSurface());
                this.mMediaRecorder.setVideoSource(1);
                this.mMediaRecorder.setAudioSource(1);
                this.mMediaRecorder.setOutputFormat(2);
                CamcorderProfile mProfile = CamcorderProfile.get((int)4);
                this.mMediaRecorder.setVideoSize(640, 480);
                this.mMediaRecorder.setAudioEncodingBitRate(44100);
                if (mProfile.videoBitRate > 0x200000) {
                    this.mMediaRecorder.setVideoEncodingBitRate(0x200000);
                } else {
                    this.mMediaRecorder.setVideoEncodingBitRate(mProfile.videoBitRate);
                }
                this.mMediaRecorder.setVideoFrameRate(mProfile.videoFrameRate);
                this.mMediaRecorder.setAudioEncoder(3);
                this.mMediaRecorder.setVideoEncoder(2);
                this.mMediaRecorder.setOutputFile(result.mediaPath);
                Log.e((String)"Yixia", (String)("OutputFile:" + result.mediaPath));
                this.mMediaRecorder.prepare();
                this.mMediaRecorder.start();
                this.mRecording = true;
                return result;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                Log.e((String)"Yixia", (String)"startRecord", (Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.e((String)"Yixia", (String)"startRecord", (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)"Yixia", (String)"startRecord", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void stopRecord() {
        MediaObject.MediaPart part;
        long endTime = System.currentTimeMillis();
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.setOnErrorListener(null);
            this.mMediaRecorder.setPreviewDisplay(null);
            try {
                this.mMediaRecorder.stop();
            }
            catch (IllegalStateException e) {
                Log.w((String)"Yixia", (String)"stopRecord", (Throwable)e);
            }
            catch (RuntimeException e) {
                Log.w((String)"Yixia", (String)"stopRecord", (Throwable)e);
            }
            catch (Exception e) {
                Log.w((String)"Yixia", (String)"stopRecord", (Throwable)e);
            }
        }
        if (this.camera != null) {
            try {
                this.camera.lock();
            }
            catch (RuntimeException e) {
                Log.e((String)"Yixia", (String)"stopRecord", (Throwable)e);
            }
        }
        if (this.mMediaObject != null && (part = this.mMediaObject.getCurrentPart()) != null && part.recording) {
            part.recording = false;
            part.endTime = endTime;
            part.duration = (int)(part.endTime - part.startTime);
            part.cutStartTime = 0;
            part.cutEndTime = part.duration;
        }
        this.mRecording = false;
    }

    @Override
    public void release() {
        super.release();
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.setOnErrorListener(null);
            try {
                this.mMediaRecorder.release();
            }
            catch (IllegalStateException e) {
                Log.w((String)"Yixia", (String)"stopRecord", (Throwable)e);
            }
            catch (Exception e) {
                Log.w((String)"Yixia", (String)"stopRecord", (Throwable)e);
            }
        }
        this.mMediaRecorder = null;
    }

    public void onError(MediaRecorder mr, int what, int extra) {
        try {
            if (mr != null) {
                mr.reset();
            }
        }
        catch (IllegalStateException e) {
            Log.w((String)"Yixia", (String)"stopRecord", (Throwable)e);
        }
        catch (Exception e) {
            Log.w((String)"Yixia", (String)"stopRecord", (Throwable)e);
        }
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onVideoError(what, extra);
        }
    }

    @Override
    protected void setPreviewCallback() {
    }

    @Override
    protected void concatVideoParts() {
        new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... params) {
                String cmd = "";
                int cameraId = 0;
                int j = MediaRecorderSystem.this.mMediaObject.getMedaParts().size();
                for (int i = 0; i < j; ++i) {
                    MediaObject.MediaPart part = MediaRecorderSystem.this.mMediaObject.getMedaParts().get(i);
                    if (FileUtils.checkFile(part.mediaPath)) {
                        String ts = part.mediaPath.replace(".mp4", ".ts");
                        FileUtils.deleteFile(ts);
                        cameraId = part.cameraId;
                        cmd = String.format("ffmpeg %s -i \"%s\" -r 25 -vcodec copy -acodec copy -vbsf h264_mp4toannexb \"%s\"", FFMpegUtils.getLogCommand(), part.mediaPath, ts);
                        if (UtilityAdapter.FFmpegRun("", cmd) == 0) {
                            part.mediaPath = ts;
                            continue;
                        }
                    }
                    part.mediaPath = "";
                }
                String vf = cameraId == 0 ? "transpose=1" : "transpose=2,hflip";
                cmd = String.format("ffmpeg %s -i \"%s\" -vf \"%s\" %s -acodec copy -absf aac_adtstoasc -f mp4 -movflags faststart \"%s\"", FFMpegUtils.getLogCommand(), MediaRecorderSystem.this.mMediaObject.getConcatYUV(), vf, FFMpegUtils.getVCodecCommand(), MediaRecorderSystem.this.mMediaObject.getOutputTempVideoPath());
                Log.e((String)"MediaRecorderSystem", (String)cmd);
                return UtilityAdapter.FFmpegRun("", cmd) == 0;
            }

            protected void onPostExecute(Boolean result) {
                if (result.booleanValue()) {
                    MediaRecorderSystem.this.mEncodeHanlder.sendEmptyMessage(2);
                } else {
                    MediaRecorderSystem.this.mEncodeHanlder.sendEmptyMessage(3);
                }
            }
        }.execute((Object[])new Void[0]);
    }
}

