/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera;

import android.hardware.Camera;
import android.media.MediaRecorder;
import android.util.Log;
import com.yixia.videoeditor.adapter.UtilityAdapter;
import mabeijianxi.camera.AudioRecorder;
import mabeijianxi.camera.MediaRecorderBase;
import mabeijianxi.camera.model.MediaObject;

public class MediaRecorderNative
extends MediaRecorderBase
implements MediaRecorder.OnErrorListener {
    private static final String VIDEO_SUFFIX = ".ts";

    @Override
    public MediaObject.MediaPart startRecord() {
        if (!UtilityAdapter.isInitialized()) {
            UtilityAdapter.initFilterParser();
        }
        MediaObject.MediaPart result = null;
        if (this.mMediaObject != null) {
            this.mRecording = true;
            result = this.mMediaObject.buildMediaPart(this.mCameraId, VIDEO_SUFFIX);
            String cmd = String.format("filename = \"%s\"; ", result.mediaPath);
            cmd = this.mCameraId == 0 ? cmd + String.format("addcmd = %s; ", " -vf \"transpose=1,crop=" + SMALL_VIDEO_WIDTH + ":" + SMALL_VIDEO_HEIGHT + ":0:0\" " + this.getBitrateCrfSize(mediaRecorderConfig, "", true) + this.getBitrateVelocity(mediaRecorderConfig, "", true) + this.getBitrateModeCommand(mediaRecorderConfig, "", true)) : cmd + String.format("addcmd = %s; ", " -vf \"transpose=2,crop=" + SMALL_VIDEO_WIDTH + ":" + SMALL_VIDEO_HEIGHT + ":0:0\" " + this.getBitrateCrfSize(mediaRecorderConfig, "", true) + this.getBitrateVelocity(mediaRecorderConfig, "", true) + this.getBitrateModeCommand(mediaRecorderConfig, "", true));
            UtilityAdapter.FilterParserAction(cmd, 2);
            if (this.mAudioRecorder == null && result != null) {
                this.mAudioRecorder = new AudioRecorder(this);
                this.mAudioRecorder.start();
            }
        }
        return result;
    }

    @Override
    public void stopRecord() {
        UtilityAdapter.FilterParserAction("", 3);
        super.stopRecord();
    }

    @Override
    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.mRecording) {
            UtilityAdapter.RenderDataYuv(data);
        }
        super.onPreviewFrame(data, camera);
    }

    @Override
    protected void onStartPreviewSuccess() {
        if (this.mCameraId == 0) {
            UtilityAdapter.RenderInputSettings(mSupportedPreviewWidth, SMALL_VIDEO_WIDTH, 0, 0);
        } else {
            UtilityAdapter.RenderInputSettings(mSupportedPreviewWidth, SMALL_VIDEO_WIDTH, 180, 1);
        }
        UtilityAdapter.RenderOutputSettings(SMALL_VIDEO_WIDTH, SMALL_VIDEO_HEIGHT, this.mFrameRate, 33);
    }

    public void onError(MediaRecorder mr, int what, int extra) {
        try {
            if (mr != null) {
                mr.reset();
            }
        }
        catch (IllegalStateException e) {
            Log.w((String)"Yixia", (String)"stopRecord", (Throwable)e);
        }
        catch (Exception e) {
            Log.w((String)"Yixia", (String)"stopRecord", (Throwable)e);
        }
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onVideoError(what, extra);
        }
    }

    @Override
    public void receiveAudioData(byte[] sampleBuffer, int len) {
        if (this.mRecording && len > 0) {
            UtilityAdapter.RenderDataPcm(sampleBuffer);
        }
    }
}

