/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import java.io.IOException;
import mabeijianxi.camera.AudioRecorder;
import mabeijianxi.camera.MediaRecorderBase;
import mabeijianxi.camera.model.MediaObject;
import mabeijianxi.camera.util.Log;

@Deprecated
public class MediaRecorderCustom
extends MediaRecorderBase {
    private static final int HANDLE_SAVE_YUV = 1;
    private static final int HANDLE_SAVE_PCM = 2;
    private static final int HANDLE_PART_STOP = 3;
    private HandlerThread mHandlerThread;
    private YuvHandler mHandler;
    private int g_audioframe = 0;
    private int g_videoframe = 0;

    @Override
    public void prepare() {
        if (!this.mPrepared) {
            this.mHandlerThread = new HandlerThread("handler_thread", 10);
            this.mHandlerThread.start();
            this.mHandler = new YuvHandler(this.mHandlerThread.getLooper());
            this.mPrepared = true;
        }
        if (this.mSurfaceCreated) {
            this.startPreview();
        }
    }

    @Override
    public MediaObject.MediaPart startRecord() {
        MediaObject.MediaPart result = null;
        if (this.mMediaObject != null) {
            result = this.mMediaObject.buildMediaPart(this.mCameraId);
            this.resetAVSync();
            if (this.mAudioRecorder == null) {
                this.mAudioRecorder = new AudioRecorder(this);
                this.mAudioRecorder.start();
            }
            this.mRecording = true;
        }
        return result;
    }

    @Override
    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.mRecording && this.mMediaObject != null && this.mHandler != null) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, this.mMediaObject.getCurrentIndex(), this.appendVideoData(data.length), data));
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
            this.mHandlerThread = null;
        }
    }

    @Override
    public void startEncoding() {
    }

    public void resetAVSync() {
        this.g_audioframe = 0;
        this.g_videoframe = 0;
    }

    @Override
    public void receiveAudioData(byte[] sampleBuffer, int len) {
        if (this.mRecording && this.mMediaObject != null) {
            this.g_audioframe += len;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, this.mMediaObject.getCurrentIndex(), 0, sampleBuffer));
        }
    }

    public int appendVideoData(int len) {
        int allocframe = this.g_audioframe * 17 / 100000;
        if (this.g_videoframe > allocframe) {
            return 0;
        }
        this.g_videoframe += (allocframe -= this.g_videoframe);
        return allocframe;
    }

    private class YuvHandler
    extends Handler {
        public YuvHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            int position = msg.arg1;
            switch (msg.what) {
                case 1: {
                    MediaObject.MediaPart part;
                    int allocframe = msg.arg2;
                    byte[] yuv = (byte[])msg.obj;
                    if (MediaRecorderCustom.this.mMediaObject == null || (part = MediaRecorderCustom.this.mMediaObject.getPart(position)) == null || part.mCurrentOutputVideo == null) break;
                    try {
                        for (int j = 0; j < allocframe; ++j) {
                            part.writeVideoData(yuv);
                        }
                    }
                    catch (IOException e) {
                        Log.e("MediaRecorder", "save_yuv", e);
                    }
                    if (part.recording || !this.hasMessages(3)) break;
                    this.removeMessages(3);
                    this.sendMessageDelayed(this.obtainMessage(3, position, 0), 1000L);
                    break;
                }
                case 2: {
                    MediaObject.MediaPart part;
                    if (MediaRecorderCustom.this.mMediaObject == null || (part = MediaRecorderCustom.this.mMediaObject.getPart(position)) == null) break;
                    try {
                        part.writeAudioData((byte[])msg.obj);
                    }
                    catch (IOException e) {
                        Log.e("MediaRecorder", "save_yuv", e);
                    }
                    break;
                }
                case 3: {
                    MediaObject.MediaPart part;
                    if (MediaRecorderCustom.this.mMediaObject == null || (part = MediaRecorderCustom.this.mMediaObject.getPart(position)) == null) break;
                    part.stop();
                }
            }
            super.handleMessage(msg);
        }
    }
}

