/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.yixia.videoeditor.adapter.UtilityAdapter;
import java.io.File;
import mabeijianxi.camera.MediaRecorderBase;
import mabeijianxi.camera.MediaRecorderNative;
import mabeijianxi.camera.MediaRecorderSystem;
import mabeijianxi.camera.R;
import mabeijianxi.camera.VCamera;
import mabeijianxi.camera.model.MediaObject;
import mabeijianxi.camera.model.MediaRecorderConfig;
import mabeijianxi.camera.util.DeviceUtils;
import mabeijianxi.camera.util.FileUtils;
import mabeijianxi.camera.util.StringUtils;
import mabeijianxi.camera.views.ProgressView;

public class MediaRecorderActivity
extends Activity
implements MediaRecorderBase.OnErrorListener,
View.OnClickListener,
MediaRecorderBase.OnPreparedListener,
MediaRecorderBase.OnEncodeListener {
    private static int RECORD_TIME_MAX = 6000;
    private static int RECORD_TIME_MIN = 1500;
    private static final int HANDLE_INVALIDATE_PROGRESS = 0;
    private static final int HANDLE_STOP_RECORD = 1;
    private ImageView mTitleNext;
    private CheckBox mCameraSwitch;
    private CheckedTextView mRecordDelete;
    private CheckBox mRecordLed;
    private TextView mRecordController;
    private RelativeLayout mBottomLayout;
    private SurfaceView mSurfaceView;
    private ProgressView mProgressView;
    private MediaRecorderBase mMediaRecorder;
    private MediaObject mMediaObject;
    private volatile boolean mPressedStatus;
    private volatile boolean mReleased;
    public static final String VIDEO_URI = "video_uri";
    public static final String OUTPUT_DIRECTORY = "output_directory";
    public static final String VIDEO_SCREENSHOT = "video_screenshot";
    public static final String OVER_ACTIVITY_NAME = "over_activity_name";
    public static final String MEDIA_RECORDER_MAX_TIME_KEY = "media_recorder_max_time_key";
    public static final String MEDIA_RECORDER_MIN_TIME_KEY = "media_recorder_min_time_key";
    public static final String MEDIA_RECORDER_CONFIG_KEY = "media_recorder_config_key";
    private boolean GO_HOME;
    private View.OnTouchListener mOnVideoControllerTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (MediaRecorderActivity.this.mMediaRecorder == null) {
                return false;
            }
            switch (event.getAction()) {
                case 0: {
                    if (MediaRecorderActivity.this.mMediaObject.getDuration() >= RECORD_TIME_MAX) {
                        return true;
                    }
                    if (MediaRecorderActivity.this.cancelDelete()) {
                        return true;
                    }
                    MediaRecorderActivity.this.startRecord();
                    break;
                }
                case 1: {
                    if (!MediaRecorderActivity.this.mPressedStatus) break;
                    MediaRecorderActivity.this.stopRecord();
                    if (MediaRecorderActivity.this.mMediaObject.getDuration() < RECORD_TIME_MAX) break;
                    MediaRecorderActivity.this.mTitleNext.performClick();
                }
            }
            return true;
        }
    };
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (MediaRecorderActivity.this.mMediaRecorder == null || MediaRecorderActivity.this.isFinishing()) break;
                    if (MediaRecorderActivity.this.mMediaObject != null && MediaRecorderActivity.this.mMediaObject.getMedaParts() != null && MediaRecorderActivity.this.mMediaObject.getDuration() >= RECORD_TIME_MAX) {
                        MediaRecorderActivity.this.stopRecord();
                        MediaRecorderActivity.this.mTitleNext.performClick();
                        return;
                    }
                    if (MediaRecorderActivity.this.mProgressView != null) {
                        MediaRecorderActivity.this.mProgressView.invalidate();
                    }
                    if (!MediaRecorderActivity.this.mPressedStatus) break;
                    this.sendEmptyMessageDelayed(0, 30L);
                }
            }
        }
    };
    protected ProgressDialog mProgressDialog;

    public static void goSmallVideoRecorder(Activity context, String overGOActivityName, MediaRecorderConfig mediaRecorderConfig) {
        context.startActivity(new Intent((Context)context, MediaRecorderActivity.class).putExtra(OVER_ACTIVITY_NAME, overGOActivityName).putExtra(MEDIA_RECORDER_CONFIG_KEY, (Parcelable)mediaRecorderConfig));
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(128);
        this.initData();
        this.loadViews();
    }

    private void initData() {
        Intent intent = this.getIntent();
        MediaRecorderConfig mediaRecorderConfig = (MediaRecorderConfig)intent.getParcelableExtra(MEDIA_RECORDER_CONFIG_KEY);
        if (mediaRecorderConfig == null) {
            return;
        }
        RECORD_TIME_MAX = mediaRecorderConfig.getRecordTimeMax();
        RECORD_TIME_MIN = mediaRecorderConfig.getRecordTimeMin();
        MediaRecorderBase.MAX_FRAME_RATE = mediaRecorderConfig.getMaxFrameRate();
        MediaRecorderBase.MIN_FRAME_RATE = mediaRecorderConfig.getMinFrameRate();
        MediaRecorderBase.SMALL_VIDEO_HEIGHT = mediaRecorderConfig.getSmallVideoHeight();
        MediaRecorderBase.SMALL_VIDEO_WIDTH = mediaRecorderConfig.getSmallVideoWidth();
        MediaRecorderBase.mVideoBitrate = mediaRecorderConfig.getVideoBitrate();
        MediaRecorderBase.mediaRecorderConfig = mediaRecorderConfig.getMediaBitrateConfig();
        MediaRecorderBase.compressConfig = mediaRecorderConfig.getCompressConfig();
        MediaRecorderBase.CAPTURE_THUMBNAILS_TIME = mediaRecorderConfig.getCaptureThumbnailsTime();
        MediaRecorderBase.doH264Compress = mediaRecorderConfig.isDoH264Compress();
        this.GO_HOME = mediaRecorderConfig.isGO_HOME();
    }

    private void loadViews() {
        this.setContentView(R.layout.activity_media_recorder);
        this.mSurfaceView = (SurfaceView)this.findViewById(R.id.record_preview);
        this.mCameraSwitch = (CheckBox)this.findViewById(R.id.record_camera_switcher);
        this.mTitleNext = (ImageView)this.findViewById(R.id.title_next);
        this.mProgressView = (ProgressView)this.findViewById(R.id.record_progress);
        this.mRecordDelete = (CheckedTextView)this.findViewById(R.id.record_delete);
        this.mRecordController = (TextView)this.findViewById(R.id.record_controller);
        this.mBottomLayout = (RelativeLayout)this.findViewById(R.id.bottom_layout);
        this.mRecordLed = (CheckBox)this.findViewById(R.id.record_camera_led);
        this.mTitleNext.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.title_back).setOnClickListener((View.OnClickListener)this);
        this.mRecordDelete.setOnClickListener((View.OnClickListener)this);
        this.mRecordController.setOnTouchListener(this.mOnVideoControllerTouchListener);
        if (MediaRecorderBase.isSupportFrontCamera()) {
            this.mCameraSwitch.setOnClickListener((View.OnClickListener)this);
        } else {
            this.mCameraSwitch.setVisibility(8);
        }
        if (DeviceUtils.isSupportCameraLedFlash(this.getPackageManager())) {
            this.mRecordLed.setOnClickListener((View.OnClickListener)this);
        } else {
            this.mRecordLed.setVisibility(8);
        }
        this.mProgressView.setMaxDuration(RECORD_TIME_MAX);
        this.mProgressView.setMinTime(RECORD_TIME_MIN);
    }

    private void initSurfaceView() {
        int w = DeviceUtils.getScreenWidth((Context)this);
        ((RelativeLayout.LayoutParams)this.mBottomLayout.getLayoutParams()).topMargin = (int)((float)w / ((float)MediaRecorderBase.SMALL_VIDEO_WIDTH / ((float)MediaRecorderBase.SMALL_VIDEO_HEIGHT * 1.0f)));
        int width = w;
        int height = (int)((float)w * ((float)MediaRecorderBase.mSupportedPreviewWidth * 1.0f / (float)MediaRecorderBase.SMALL_VIDEO_WIDTH));
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mSurfaceView.getLayoutParams();
        lp.width = width;
        lp.height = height;
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void initMediaRecorder() {
        this.mMediaRecorder = new MediaRecorderNative();
        this.mMediaRecorder.setOnErrorListener(this);
        this.mMediaRecorder.setOnEncodeListener(this);
        this.mMediaRecorder.setOnPreparedListener(this);
        File f = new File(VCamera.getVideoCachePath());
        if (!FileUtils.checkFile(f)) {
            f.mkdirs();
        }
        String key = String.valueOf(System.currentTimeMillis());
        this.mMediaObject = this.mMediaRecorder.setOutputDirectory(key, VCamera.getVideoCachePath() + key);
        this.mMediaRecorder.setSurfaceHolder(this.mSurfaceView.getHolder());
        this.mMediaRecorder.prepare();
    }

    public void onResume() {
        super.onResume();
        UtilityAdapter.freeFilterParser();
        UtilityAdapter.initFilterParser();
        if (this.mMediaRecorder == null) {
            this.initMediaRecorder();
        } else {
            this.mRecordLed.setChecked(false);
            this.mMediaRecorder.prepare();
            this.mProgressView.setData(this.mMediaObject);
        }
    }

    public void onPause() {
        super.onPause();
        this.stopRecord();
        UtilityAdapter.freeFilterParser();
        if (!this.mReleased && this.mMediaRecorder != null) {
            this.mMediaRecorder.release();
        }
        this.mReleased = false;
    }

    private void startRecord() {
        if (this.mMediaRecorder != null) {
            MediaObject.MediaPart part = this.mMediaRecorder.startRecord();
            if (part == null) {
                return;
            }
            if (this.mMediaRecorder instanceof MediaRecorderSystem) {
                this.mCameraSwitch.setVisibility(8);
            }
            this.mProgressView.setData(this.mMediaObject);
        }
        this.mPressedStatus = true;
        this.mRecordController.animate().scaleX(0.8f).scaleY(0.8f).setDuration(500L).start();
        if (this.mHandler != null) {
            this.mHandler.removeMessages(0);
            this.mHandler.sendEmptyMessage(0);
            this.mHandler.removeMessages(1);
            this.mHandler.sendEmptyMessageDelayed(1, (long)(RECORD_TIME_MAX - this.mMediaObject.getDuration()));
        }
        this.mRecordDelete.setVisibility(8);
        this.mCameraSwitch.setEnabled(false);
        this.mRecordLed.setEnabled(false);
    }

    public void onBackPressed() {
        if (this.mRecordDelete != null && this.mRecordDelete.isChecked()) {
            this.cancelDelete();
            return;
        }
        if (this.mMediaObject != null && this.mMediaObject.getDuration() > 1) {
            new AlertDialog.Builder((Context)this).setTitle(R.string.hint).setMessage(R.string.record_camera_exit_dialog_message).setNegativeButton(R.string.record_camera_cancel_dialog_yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MediaRecorderActivity.this.mMediaObject.delete();
                    MediaRecorderActivity.this.finish();
                }
            }).setPositiveButton(R.string.record_camera_cancel_dialog_no, null).setCancelable(false).show();
            return;
        }
        if (this.mMediaObject != null) {
            this.mMediaObject.delete();
        }
        this.finish();
    }

    private void stopRecord() {
        this.mPressedStatus = false;
        this.mRecordController.animate().scaleX(1.0f).scaleY(1.0f).setDuration(500L).start();
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.stopRecord();
        }
        this.mRecordDelete.setVisibility(0);
        this.mCameraSwitch.setEnabled(true);
        this.mRecordLed.setEnabled(true);
        this.mHandler.removeMessages(1);
        this.checkStatus();
    }

    public void onClick(View v) {
        MediaObject.MediaPart part;
        int id2 = v.getId();
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
        if (id2 != R.id.record_delete && this.mMediaObject != null && (part = this.mMediaObject.getCurrentPart()) != null && part.remove) {
            part.remove = false;
            this.mRecordDelete.setChecked(false);
            if (this.mProgressView != null) {
                this.mProgressView.invalidate();
            }
        }
        if (id2 == R.id.title_back) {
            this.onBackPressed();
        } else if (id2 == R.id.record_camera_switcher) {
            if (this.mRecordLed.isChecked()) {
                if (this.mMediaRecorder != null) {
                    this.mMediaRecorder.toggleFlashMode();
                }
                this.mRecordLed.setChecked(false);
            }
            if (this.mMediaRecorder != null) {
                this.mMediaRecorder.switchCamera();
            }
            if (this.mMediaRecorder.isFrontCamera()) {
                this.mRecordLed.setEnabled(false);
            } else {
                this.mRecordLed.setEnabled(true);
            }
        } else if (id2 == R.id.record_camera_led) {
            if (this.mMediaRecorder != null && this.mMediaRecorder.isFrontCamera()) {
                return;
            }
            if (this.mMediaRecorder != null) {
                this.mMediaRecorder.toggleFlashMode();
            }
        } else if (id2 == R.id.title_next) {
            this.mMediaRecorder.startEncoding();
        } else if (id2 == R.id.record_delete && this.mMediaObject != null) {
            part = this.mMediaObject.getCurrentPart();
            if (part != null) {
                if (part.remove) {
                    part.remove = false;
                    this.mMediaObject.removePart(part, true);
                    this.mRecordDelete.setChecked(false);
                } else {
                    part.remove = true;
                    this.mRecordDelete.setChecked(true);
                }
            }
            if (this.mProgressView != null) {
                this.mProgressView.invalidate();
            }
            this.checkStatus();
        }
    }

    private boolean cancelDelete() {
        MediaObject.MediaPart part;
        if (this.mMediaObject != null && (part = this.mMediaObject.getCurrentPart()) != null && part.remove) {
            part.remove = false;
            this.mRecordDelete.setChecked(false);
            if (this.mProgressView != null) {
                this.mProgressView.invalidate();
            }
            return true;
        }
        return false;
    }

    private int checkStatus() {
        int duration = 0;
        if (!this.isFinishing() && this.mMediaObject != null) {
            duration = this.mMediaObject.getDuration();
            if (duration < RECORD_TIME_MIN) {
                if (duration == 0) {
                    this.mCameraSwitch.setVisibility(0);
                    this.mRecordDelete.setVisibility(8);
                }
                if (this.mTitleNext.getVisibility() != 4) {
                    this.mTitleNext.setVisibility(4);
                }
            } else if (this.mTitleNext.getVisibility() != 0) {
                this.mTitleNext.setVisibility(0);
            }
        }
        return duration;
    }

    @Override
    public void onEncodeStart() {
        this.showProgress("", this.getString(R.string.record_camera_progress_message));
    }

    @Override
    public void onEncodeProgress(int progress) {
    }

    @Override
    public void onEncodeComplete() {
        this.hideProgress();
        Intent intent = null;
        try {
            intent = new Intent((Context)this, Class.forName(this.getIntent().getStringExtra(OVER_ACTIVITY_NAME)));
            intent.putExtra(OUTPUT_DIRECTORY, this.mMediaObject.getOutputDirectory());
            if (MediaRecorderBase.compressConfig != null) {
                intent.putExtra(VIDEO_URI, this.mMediaObject.getOutputTempTranscodingVideoPath());
            } else {
                intent.putExtra(VIDEO_URI, this.mMediaObject.getOutputTempVideoPath());
            }
            intent.putExtra(VIDEO_SCREENSHOT, this.mMediaObject.getOutputVideoThumbPath());
            intent.putExtra("go_home", this.GO_HOME);
            this.startActivity(intent);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("\u9700\u8981\u4f20\u5165\u5f55\u5236\u5b8c\u6210\u540e\u8df3\u8f6c\u7684Activity\u7684\u5168\u7c7b\u540d");
        }
        this.finish();
    }

    @Override
    public void onEncodeError() {
        this.hideProgress();
        Toast.makeText((Context)this, (int)R.string.record_video_transcoding_faild, (int)0).show();
        this.finish();
    }

    @Override
    public void onVideoError(int what, int extra) {
    }

    @Override
    public void onAudioError(int what, String message) {
    }

    @Override
    public void onPrepared() {
        this.initSurfaceView();
    }

    public void onFinished() {
        this.finish();
    }

    public ProgressDialog showProgress(String title, String message) {
        return this.showProgress(title, message, -1);
    }

    public ProgressDialog showProgress(String title, String message, int theme) {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = theme > 0 ? new ProgressDialog((Context)this, theme) : new ProgressDialog((Context)this);
            this.mProgressDialog.setProgressStyle(0);
            this.mProgressDialog.requestWindowFeature(1);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
            this.mProgressDialog.setCancelable(false);
            this.mProgressDialog.setIndeterminate(true);
        }
        if (!StringUtils.isEmpty(title)) {
            this.mProgressDialog.setTitle((CharSequence)title);
        }
        this.mProgressDialog.setMessage((CharSequence)message);
        this.mProgressDialog.show();
        return this.mProgressDialog;
    }

    public void hideProgress() {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
    }

    protected void onStop() {
        super.onStop();
        this.hideProgress();
        this.mProgressDialog = null;
    }
}

