/*
 * Decompiled with CFR 0.152.
 */
package mabeijianxi.camera;

import android.media.ExifInterface;
import android.media.MediaMetadataRetriever;
import com.yixia.videoeditor.adapter.UtilityAdapter;
import java.io.File;
import java.io.IOException;
import mabeijianxi.camera.VCamera;
import mabeijianxi.camera.model.MediaObject;
import mabeijianxi.camera.util.DeviceUtils;
import mabeijianxi.camera.util.FileUtils;
import mabeijianxi.camera.util.Log;
import mabeijianxi.camera.util.StringUtils;

public class FFMpegUtils {
    public static final float AUDIO_VOLUME_HIGH = 1.0f;
    public static final float AUDIO_VOLUME_MEDIUM = 0.66f;
    public static final float AUDIO_VOLUME_LOW = 0.33f;
    public static final int AUDIO_VOLUME_CLOSE = 0;
    private static final String FFMPEG_COMMAND_LOG_LOGCATE = " -d stdout -loglevel verbose";
    private static final String FFMPEG_COMMAND_VCODEC = " -pix_fmt yuv420p -vcodec libx264 -profile:v baseline -preset ultrafast";

    public static String getLogCommand() {
        if (VCamera.isLog()) {
            return FFMPEG_COMMAND_LOG_LOGCATE;
        }
        return " -d \"" + VCamera.getVideoCachePath() + "temp_ffmpeg.log" + "\" -loglevel verbose";
    }

    public static String getVCodecCommand() {
        return FFMPEG_COMMAND_VCODEC;
    }

    public static boolean importVideo(MediaObject.MediaPart part, int mWindowWidth, int videoWidth, int videoHeight, int cropX, int cropY, boolean hasAudio) {
        File f;
        if (part != null && !StringUtils.isEmpty(part.tempPath) && (f = new File(part.tempPath)) != null && f.exists() && !f.isDirectory()) {
            boolean result;
            StringBuffer buffer = new StringBuffer("ffmpeg");
            buffer.append(FFMpegUtils.getLogCommand());
            buffer.append(" -i \"");
            buffer.append(part.tempPath);
            buffer.append("\"");
            int rotation = -1;
            int width = videoWidth;
            int height = videoHeight;
            int cX = cropX;
            int cY = cropY;
            float videoAspectRatio = (float)videoWidth * 1.0f / (float)videoHeight;
            if (DeviceUtils.hasJellyBeanMr1()) {
                MediaMetadataRetriever metadata = new MediaMetadataRetriever();
                metadata.setDataSource(part.tempPath);
                try {
                    rotation = Integer.parseInt(metadata.extractMetadata(24));
                }
                catch (NumberFormatException e) {
                    rotation = -1;
                }
            } else {
                rotation = UtilityAdapter.VideoGetMetadataRotate(part.tempPath);
            }
            if (rotation == 90 || rotation == 270) {
                int w = videoWidth;
                width = videoHeight;
                height = w;
            }
            buffer.append(" -vf \"scale=");
            if (width >= height) {
                buffer.append("-1:480");
                float scaleWidth = 480.0f * videoAspectRatio;
                int viewWidth = (int)((float)mWindowWidth * videoAspectRatio);
                cX = (int)(scaleWidth * ((float)cropX * 1.0f / (float)viewWidth));
            } else {
                buffer.append("480:-1");
                float scaleHeight = 480.0f / videoAspectRatio;
                int viewHeight = (int)((float)mWindowWidth / videoAspectRatio);
                cY = (int)(scaleHeight * ((float)cropY * 1.0f / (float)viewHeight));
            }
            buffer.append("[tmp];[tmp]");
            boolean hasRotation = true;
            switch (rotation) {
                case 90: {
                    buffer.append("transpose=1[transpose];[transpose]");
                    break;
                }
                case 270: {
                    buffer.append("transpose=2[transpose];[transpose]");
                    break;
                }
                case 180: {
                    buffer.append("vflip[vflip];[vflip]hflip[transpose];[transpose]");
                    break;
                }
                default: {
                    hasRotation = false;
                }
            }
            buffer.append(" crop=480:480:");
            buffer.append(cX);
            buffer.append(":");
            buffer.append(cY);
            buffer.append("\"");
            if (hasRotation) {
                buffer.append(" -metadata:s:v rotate=\"\"");
            }
            buffer.append(" -ss ");
            buffer.append(String.format("%.1f", Float.valueOf((float)part.startTime / 1000.0f)));
            buffer.append(" -t ");
            buffer.append(String.format("%.1f", Float.valueOf((float)(part.endTime - part.startTime) / 1000.0f)));
            buffer.append(" -an -vcodec rawvideo -f rawvideo -s 480x480 -pix_fmt yuv420p -r 15 \"");
            buffer.append(part.mediaPath);
            buffer.append("\"");
            if (!hasAudio) {
                byte[] hz = new byte[88200];
                part.prepareAudio();
                try {
                    int duration = (int)(part.endTime - part.startTime);
                    int forCount = duration / 1000;
                    if (forCount > 0) {
                        for (int i = 0; i < forCount; ++i) {
                            part.mCurrentOutputAudio.write(hz);
                        }
                    }
                    if (duration % 1000 != 0) {
                        int lastSize = (int)((float)(88200 * (duration - forCount * 1000)) / 1000.0f);
                        if (lastSize % 2 != 0) {
                            ++lastSize;
                        }
                        part.mCurrentOutputAudio.write(new byte[lastSize]);
                    }
                }
                catch (IOException e) {
                    Log.e("Yixia", "convertImage2Video", e);
                }
                catch (Exception e) {
                    Log.e("Yixia", "convertImage2Video", e);
                }
                part.stop();
            } else {
                buffer.append(" -ss ");
                buffer.append(String.format("%.1f", Float.valueOf((float)part.startTime / 1000.0f)));
                buffer.append(" -t ");
                buffer.append(String.format("%.1f", Float.valueOf((float)(part.endTime - part.startTime) / 1000.0f)));
                buffer.append(" -vn -acodec pcm_s16le -f s16le -ar 44100 -ac 1 \"");
                buffer.append(part.audioPath);
                buffer.append("\"");
            }
            boolean bl = result = UtilityAdapter.FFmpegRun("", buffer.toString()) == 0;
            if (!result) {
                VCamera.copyFFmpegLog(buffer.toString());
            }
            return result;
        }
        return false;
    }

    public static boolean convertImage2Video(MediaObject.MediaPart part) {
        File f;
        if (part != null && !StringUtils.isEmpty(part.tempPath) && (f = new File(part.tempPath)) != null && f.exists() && !f.isDirectory()) {
            int width = 0;
            int height = 0;
            int rotation = -1;
            int cropX = 0;
            int cropY = 0;
            try {
                ExifInterface exif = new ExifInterface(part.tempPath);
                width = exif.getAttributeInt("ImageWidth", 0);
                height = exif.getAttributeInt("ImageLength", 0);
                rotation = exif.getAttributeInt("Orientation", -1);
            }
            catch (IOException e) {
                Log.e("Yixia", "convertImage2Video", e);
            }
            StringBuffer scaleBuffer = new StringBuffer();
            if (width > 0 && height > 0) {
                float videoAspectRatio = (float)width * 1.0f / (float)height;
                scaleBuffer.append(" -vf \"scale=");
                if (width > height) {
                    scaleBuffer.append("-1:480");
                    float scaleWidth = 480.0f * videoAspectRatio;
                    cropX = (int)((scaleWidth - 480.0f) / 2.0f);
                } else {
                    scaleBuffer.append("480:-1");
                    float scaleHeight = 480.0f / videoAspectRatio;
                    cropY = (int)((scaleHeight - 480.0f) / 2.0f);
                }
                scaleBuffer.append("[tmp];[tmp]");
                switch (rotation) {
                    case 6: {
                        scaleBuffer.append("transpose=1[transpose];[transpose]");
                        break;
                    }
                    case 3: {
                        scaleBuffer.append("transpose=2[transpose];[transpose]");
                        break;
                    }
                    case 8: {
                        scaleBuffer.append("vflip[vflip];[vflip]hflip[transpose];[transpose]");
                    }
                }
                scaleBuffer.append(" crop=480:480:");
                scaleBuffer.append(cropX);
                scaleBuffer.append(":");
                scaleBuffer.append(cropY);
                scaleBuffer.append("\"");
            }
            scaleBuffer.append(" -s 480x480");
            String cmd = String.format("ffmpeg %s -y -loop 1 -f image2 -i \"%s\" -vcodec rawvideo -r 15 -t %.1f -f rawvideo %s -pix_fmt yuv420p \"%s\"", FFMpegUtils.getLogCommand(), part.tempPath, Float.valueOf((float)part.duration / 1000.0f), scaleBuffer.toString(), part.mediaPath);
            if (UtilityAdapter.FFmpegRun("", cmd) == 0) {
                byte[] hz = new byte[88200 * (int)((float)part.duration / 1000.0f)];
                part.prepareAudio();
                try {
                    part.mCurrentOutputAudio.write(hz);
                    part.stop();
                    return true;
                }
                catch (IOException e) {
                    Log.e("Yixia", "convertImage2Video", e);
                }
                catch (Exception e) {
                    Log.e("Yixia", "convertImage2Video", e);
                }
            } else {
                VCamera.copyFFmpegLog(cmd);
            }
            return true;
        }
        return false;
    }

    public static boolean captureThumbnails(String videoPath, String outputPath, String ss) {
        FileUtils.deleteFile(outputPath);
        ss = ss == null ? "" : " -ss " + ss;
        String cmd = String.format("ffmpeg -d stdout -loglevel verbose -i \"%s\"%s  -vframes 1 \"%s\"", videoPath, ss, outputPath);
        return UtilityAdapter.FFmpegRun("", cmd) == 0;
    }

    public static boolean captureThumbnails(String videoPath, String outputPath, String wh, String ss) {
        FileUtils.deleteFile(outputPath);
        ss = ss == null ? "" : " -ss " + ss;
        String cmd = String.format("ffmpeg -d stdout -loglevel verbose -i \"%s\"%s -s %s -vframes 1 \"%s\"", videoPath, ss, wh, outputPath);
        return UtilityAdapter.FFmpegRun("", cmd) == 0;
    }
}

