/*
 * Decompiled with CFR 0.152.
 */
package com.yixia.videoeditor.adapter;

import android.media.AudioTrack;
import android.util.Log;

public class UtilityAdapter {
    public static final int FLIPTYPE_NORMAL = 0;
    public static final int FLIPTYPE_HORIZONTAL = 1;
    public static final int FLIPTYPE_VERTICAL = 2;
    public static final int OUTPUTFORMAT_YUV = 1;
    public static final int OUTPUTFORMAT_RGBA = 2;
    public static final int OUTPUTFORMAT_MASK_ZIP = 4;
    public static final int OUTPUTFORMAT_MASK_NEED_LASTSNAP = 8;
    public static final int OUTPUTFORMAT_MASK_HARDWARE_ACC = 16;
    public static final int OUTPUTFORMAT_MASK_MP4 = 32;
    public static final int FILTERTYPE_FILTER = 0;
    public static final int FILTERTYPE_FRAME = 1;
    public static final int FILTERINFO_PROCESSEDFRAME = 0;
    public static final int FILTERINFO_CACHEDFRAME = 1;
    public static final int FILTERINFO_STARTPLAY = 2;
    public static final int FILTERINFO_PAUSEPLAY = 3;
    public static final int FILTERINFO_PROGRESS = 4;
    public static final int FILTERINFO_TOTALMS = 5;
    public static final int FILTERINFO_CAUSEGC = 6;
    public static final int PARSERACTION_INIT = 0;
    public static final int PARSERACTION_UPDATE = 1;
    public static final int PARSERACTION_START = 2;
    public static final int PARSERACTION_STOP = 3;
    public static final int PARSERACTION_FREE = 4;
    public static final int PARSERACTION_PROGRESS = 5;
    private static volatile boolean gInitialized;
    protected static AudioTrack mAudioTrack;
    public static final int NOTIFYKEY_PLAYSTATE = 1;
    public static final int NOTIFYVALUE_BUFFEREMPTY = 0;
    public static final int NOTIFYVALUE_BUFFERFULL = 1;
    public static final int NOTIFYVALUE_PLAYFINISH = 2;
    public static final int NOTIFYVALUE_HAVEERROR = 3;
    private static OnNativeListener mOnNativeListener;

    public static native void FFmpegInit(Object var0, String var1);

    public static native int FFmpegVideoGetTransTime(int var0);

    public static native boolean VitamioStartRecord(String var0, String var1);

    public static native int VitamioStopRecord(int var0);

    public static native int GetVitamioVideoCallbackPointer(int var0);

    public static native int GetVitamioAudioCallbackPointer(int var0);

    public static native int VideoGetMetadataRotate(String var0);

    public static native int FFmpegRun(String var0, String var1);

    public static native void FFmpegKill(String var0);

    public static native boolean FFmpegIsRunning(String var0);

    public static native String FFmpegVideoGetInfo(String var0);

    public static native int RenderViewInit(int var0, int var1);

    public static native void RenderInputSettings(int var0, int var1, int var2, int var3);

    public static native void RenderOutputSettings(int var0, int var1, int var2, int var3);

    public static native void RenderSetFilter(int var0, String var1);

    public static native void RenderStep();

    public static native void RenderDataYuv(byte[] var0);

    public static native void RenderDataPcm(byte[] var0);

    public static native int[] RenderGetDataArgb(float var0);

    public static native boolean RenderOpenOutputFile(String var0, String var1);

    public static native void RenderCloseOutputFile();

    public static native boolean RenderIsOutputJobFinish();

    public static native void RenderPause(boolean var0);

    public static void FilterParserPause(boolean pause) {
        if (mAudioTrack != null) {
            if (pause) {
                mAudioTrack.pause();
            } else {
                mAudioTrack.play();
            }
        }
        UtilityAdapter.RenderPause(pause);
    }

    public static native boolean FilterParserInit(String var0, Object var1);

    public static native int FilterParserInfo(int var0);

    public static native void FilterParserFree();

    public static native int FilterParserAction(String var0, int var1);

    public static native boolean SaveData(String var0, int[] var1, int var2);

    public static boolean isInitialized() {
        return gInitialized;
    }

    public static void initFilterParser() {
        if (!gInitialized) {
            gInitialized = true;
            UtilityAdapter.FilterParserAction("", 0);
        }
    }

    public static void freeFilterParser() {
        gInitialized = false;
        UtilityAdapter.FilterParserAction("", 4);
    }

    public static native int SoundEffect(String var0, String var1, float var2, float var3, int var4);

    public static boolean ndkAudioInit() {
        int desiredFrames = AudioTrack.getMinBufferSize((int)44100, (int)2, (int)2);
        if (mAudioTrack == null) {
            mAudioTrack = new AudioTrack(3, 44100, 2, 2, desiredFrames, 1);
            if (mAudioTrack.getState() != 1) {
                mAudioTrack = null;
                Log.w((String)"ndkAudio", (String)"Init failed!");
                return false;
            }
            mAudioTrack.play();
        }
        return true;
    }

    public static void ndkAudioWrite(short[] buffer, int cnt) {
        int limitcount = 100;
        int i = 0;
        while (i < cnt) {
            if (--limitcount <= 0) {
                Log.e((String)"ndkAudio", (String)"avoid dead loop");
                break;
            }
            int result = mAudioTrack.write(buffer, i, cnt - i);
            if (result > 0) {
                i += result;
                continue;
            }
            if (result == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Log.w((String)"ndkAudio", (String)"write failed!");
            return;
        }
    }

    public static void ndkAudioQuit() {
        if (mAudioTrack != null) {
            mAudioTrack.stop();
            mAudioTrack.release();
            mAudioTrack = null;
        }
    }

    public static int ndkNotify(int key, int value) {
        if (mOnNativeListener != null) {
            mOnNativeListener.ndkNotify(key, value);
        } else {
            Log.e((String)"ndkNotify", (String)("ndkNotify key:" + key + ", value: " + value));
        }
        return 0;
    }

    public static void registerNativeListener(OnNativeListener l) {
        mOnNativeListener = l;
    }

    static {
        System.loadLibrary("utility");
    }

    public static interface OnNativeListener {
        public void ndkNotify(int var1, int var2);
    }
}

